// $ANTLR 3.2 Sep 23, 2009 14:05:07 org/xcmis/search/antlr/FullText.g 2011-08-18 19:20:44

package  org.xcmis.search.antlr;
import  org.xcmis.search.lucene.content.ErrorReporter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class FullTextParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "OR", "NOT", "AND", "WS", "QOUTED_SENTENCE", "WORD", "QUOTES", "CHAR", "ESCAPE_SYMBOLS", "VALID_FORM_OF_ESCAPE_SYMBOLS"
    };
    public static final int WORD=9;
    public static final int WS=7;
    public static final int ESCAPE_SYMBOLS=12;
    public static final int QOUTED_SENTENCE=8;
    public static final int OR=4;
    public static final int CHAR=11;
    public static final int QUOTES=10;
    public static final int NOT=5;
    public static final int AND=6;
    public static final int EOF=-1;
    public static final int VALID_FORM_OF_ESCAPE_SYMBOLS=13;

    // delegates
    // delegators


        public FullTextParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public FullTextParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return FullTextParser.tokenNames; }
    public String getGrammarFileName() { return "org/xcmis/search/antlr/FullText.g"; }


    private ErrorReporter reporter = null;
    private Query query=null;
    private List<String> fields;
    private Analyzer analyzer;

    public void setErrorReporter(ErrorReporter errorReporter) {
            this.reporter = errorReporter;
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
      String hdr = getErrorHeader(e);
      if (tokenNames != null) {
        String msg = getErrorMessage(e, tokenNames);
        reporter.reportMessage(hdr + " - " + msg);
      } else {
        reporter.reportMessage(hdr);
      }
    }
        
    public Query getQuery(){
      return query;
    }  


    // private String processEscSymb(String string){
    //    int cp = 0;
    //    while((cp = string.indexOf('\\', cp))!=-1){
    //      switch(string.charAt(cp+1)){
    //      case '\\':
    //      case '-':
    //      case '"':
    //        if(cp>0){
    //          string = string.substring(0, cp) + string.substring(cp+1);
    //        }else{
    //          string = string.substring(1);
    //        }
    //        break;
    //      default:
            // do nothing
    //        break;
    //      }
    //      cp++;
    //    }
    //    }

       /**
       * This method check string fro QueryParser syntax special symbols, and escape it.
       * Esacped symbols arrived from parser (\\ , \- , \") left without changes.
       * Double quotes left without changes (used for quoted term whish is interpreded as phrase).
       */
      private String processEscSymb(String string){
        // process QueryParser escape symbols + - && || ! ( ) { } [ ] ^ " ~ * ? : \

        char[] chars = string.toCharArray();

        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (char c : chars) {

          if(!escaped){
            switch (c) {
            case '-': // there must be no minus (there a checked in parser)
            case '+':
            case '&':
            case '|':
            case '!':
            case '(':
            case ')':
            case '{':
            case '}':
            case '[':        
            case ']':        
            case '^':        
            // case '"':        left for QueryParser as special symbol
            case '~':
            case '*':
            case '?':
            case ':':                
              sb.append('\\');
              sb.append(c);
              break;
            case '\\':
              sb.append('\\');
              escaped = true;
              break;
            default:
              sb.append(c);
              break;
            }
          }else{
              // all escaped symbols goes to QueryParser without changes
              sb.append(c);
              escaped=false;
          } 
        }
        string = sb.toString();
        return string;
      }




    // $ANTLR start "fulltext"
    // org/xcmis/search/antlr/FullText.g:165:1: fulltext[List<String> fd, Analyzer an] : ( ( WS )* expr ( WS )* | ( WS )* a= expr ( ( WS )+ OR ( WS )+ b= expr )+ ( WS )* );
    public final void fulltext(List<String> fd, Analyzer an) throws RecognitionException {
        Query a = null;

        Query b = null;

        Query expr1 = null;



        	fields = fd;
        	analyzer = an;
        	
        try {
            // org/xcmis/search/antlr/FullText.g:170:4: ( ( WS )* expr ( WS )* | ( WS )* a= expr ( ( WS )+ OR ( WS )+ b= expr )+ ( WS )* )
            int alt8=2;
            alt8 = dfa8.predict(input);
            switch (alt8) {
                case 1 :
                    // org/xcmis/search/antlr/FullText.g:170:6: ( WS )* expr ( WS )*
                    {
                    // org/xcmis/search/antlr/FullText.g:170:6: ( WS )*
                    loop1:
                    do {
                        int alt1=2;
                        switch ( input.LA(1) ) {
                        case WS:
                            {
                            alt1=1;
                            }
                            break;

                        }

                        switch (alt1) {
                    	case 1 :
                    	    // org/xcmis/search/antlr/FullText.g:170:6: WS
                    	    {
                    	    match(input,WS,FOLLOW_WS_in_fulltext78); 

                    	    }
                    	    break;

                    	default :
                    	    break loop1;
                        }
                    } while (true);

                    pushFollow(FOLLOW_expr_in_fulltext81);
                    expr1=expr();

                    state._fsp--;

                    // org/xcmis/search/antlr/FullText.g:170:15: ( WS )*
                    loop2:
                    do {
                        int alt2=2;
                        switch ( input.LA(1) ) {
                        case WS:
                            {
                            alt2=1;
                            }
                            break;

                        }

                        switch (alt2) {
                    	case 1 :
                    	    // org/xcmis/search/antlr/FullText.g:170:15: WS
                    	    {
                    	    match(input,WS,FOLLOW_WS_in_fulltext83); 

                    	    }
                    	    break;

                    	default :
                    	    break loop2;
                        }
                    } while (true);

                    query=expr1;

                    }
                    break;
                case 2 :
                    // org/xcmis/search/antlr/FullText.g:171:6: ( WS )* a= expr ( ( WS )+ OR ( WS )+ b= expr )+ ( WS )*
                    {
                    BooleanQuery bq = new BooleanQuery();
                    // org/xcmis/search/antlr/FullText.g:172:3: ( WS )*
                    loop3:
                    do {
                        int alt3=2;
                        switch ( input.LA(1) ) {
                        case WS:
                            {
                            alt3=1;
                            }
                            break;

                        }

                        switch (alt3) {
                    	case 1 :
                    	    // org/xcmis/search/antlr/FullText.g:172:3: WS
                    	    {
                    	    match(input,WS,FOLLOW_WS_in_fulltext98); 

                    	    }
                    	    break;

                    	default :
                    	    break loop3;
                        }
                    } while (true);

                    pushFollow(FOLLOW_expr_in_fulltext103);
                    a=expr();

                    state._fsp--;

                    bq.add(a, BooleanClause.Occur.SHOULD);
                    // org/xcmis/search/antlr/FullText.g:173:3: ( ( WS )+ OR ( WS )+ b= expr )+
                    int cnt6=0;
                    loop6:
                    do {
                        int alt6=2;
                        alt6 = dfa6.predict(input);
                        switch (alt6) {
                    	case 1 :
                    	    // org/xcmis/search/antlr/FullText.g:173:4: ( WS )+ OR ( WS )+ b= expr
                    	    {
                    	    // org/xcmis/search/antlr/FullText.g:173:4: ( WS )+
                    	    int cnt4=0;
                    	    loop4:
                    	    do {
                    	        int alt4=2;
                    	        switch ( input.LA(1) ) {
                    	        case WS:
                    	            {
                    	            alt4=1;
                    	            }
                    	            break;

                    	        }

                    	        switch (alt4) {
                    	    	case 1 :
                    	    	    // org/xcmis/search/antlr/FullText.g:173:4: WS
                    	    	    {
                    	    	    match(input,WS,FOLLOW_WS_in_fulltext118); 

                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    if ( cnt4 >= 1 ) break loop4;
                    	                EarlyExitException eee =
                    	                    new EarlyExitException(4, input);
                    	                throw eee;
                    	        }
                    	        cnt4++;
                    	    } while (true);

                    	    match(input,OR,FOLLOW_OR_in_fulltext121); 
                    	    // org/xcmis/search/antlr/FullText.g:173:11: ( WS )+
                    	    int cnt5=0;
                    	    loop5:
                    	    do {
                    	        int alt5=2;
                    	        switch ( input.LA(1) ) {
                    	        case WS:
                    	            {
                    	            alt5=1;
                    	            }
                    	            break;

                    	        }

                    	        switch (alt5) {
                    	    	case 1 :
                    	    	    // org/xcmis/search/antlr/FullText.g:173:11: WS
                    	    	    {
                    	    	    match(input,WS,FOLLOW_WS_in_fulltext123); 

                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    if ( cnt5 >= 1 ) break loop5;
                    	                EarlyExitException eee =
                    	                    new EarlyExitException(5, input);
                    	                throw eee;
                    	        }
                    	        cnt5++;
                    	    } while (true);

                    	    pushFollow(FOLLOW_expr_in_fulltext128);
                    	    b=expr();

                    	    state._fsp--;

                    	    bq.add(b, BooleanClause.Occur.SHOULD);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt6 >= 1 ) break loop6;
                                EarlyExitException eee =
                                    new EarlyExitException(6, input);
                                throw eee;
                        }
                        cnt6++;
                    } while (true);

                    // org/xcmis/search/antlr/FullText.g:173:68: ( WS )*
                    loop7:
                    do {
                        int alt7=2;
                        switch ( input.LA(1) ) {
                        case WS:
                            {
                            alt7=1;
                            }
                            break;

                        }

                        switch (alt7) {
                    	case 1 :
                    	    // org/xcmis/search/antlr/FullText.g:173:68: WS
                    	    {
                    	    match(input,WS,FOLLOW_WS_in_fulltext134); 

                    	    }
                    	    break;

                    	default :
                    	    break loop7;
                        }
                    } while (true);

                    query=bq;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "fulltext"


    // $ANTLR start "expr"
    // org/xcmis/search/antlr/FullText.g:177:1: expr returns [Query q] : (a= signedterm | a= signedterm ( ( WS )+ b= signedterm )+ );
    public final Query expr() throws RecognitionException {
        Query q = null;

        Query a = null;

        Query b = null;


        try {
            // org/xcmis/search/antlr/FullText.g:178:2: (a= signedterm | a= signedterm ( ( WS )+ b= signedterm )+ )
            int alt11=2;
            alt11 = dfa11.predict(input);
            switch (alt11) {
                case 1 :
                    // org/xcmis/search/antlr/FullText.g:178:4: a= signedterm
                    {
                    pushFollow(FOLLOW_signedterm_in_expr156);
                    a=signedterm();

                    state._fsp--;

                     q = a;

                    }
                    break;
                case 2 :
                    // org/xcmis/search/antlr/FullText.g:179:5: a= signedterm ( ( WS )+ b= signedterm )+
                    {
                    BooleanQuery bq = new BooleanQuery();
                    pushFollow(FOLLOW_signedterm_in_expr177);
                    a=signedterm();

                    state._fsp--;

                    bq.add(a, BooleanClause.Occur.MUST);
                    // org/xcmis/search/antlr/FullText.g:181:10: ( ( WS )+ b= signedterm )+
                    int cnt10=0;
                    loop10:
                    do {
                        int alt10=2;
                        alt10 = dfa10.predict(input);
                        switch (alt10) {
                    	case 1 :
                    	    // org/xcmis/search/antlr/FullText.g:181:11: ( WS )+ b= signedterm
                    	    {
                    	    // org/xcmis/search/antlr/FullText.g:181:11: ( WS )+
                    	    int cnt9=0;
                    	    loop9:
                    	    do {
                    	        int alt9=2;
                    	        switch ( input.LA(1) ) {
                    	        case WS:
                    	            {
                    	            alt9=1;
                    	            }
                    	            break;

                    	        }

                    	        switch (alt9) {
                    	    	case 1 :
                    	    	    // org/xcmis/search/antlr/FullText.g:181:11: WS
                    	    	    {
                    	    	    match(input,WS,FOLLOW_WS_in_expr196); 

                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    if ( cnt9 >= 1 ) break loop9;
                    	                EarlyExitException eee =
                    	                    new EarlyExitException(9, input);
                    	                throw eee;
                    	        }
                    	        cnt9++;
                    	    } while (true);

                    	    pushFollow(FOLLOW_signedterm_in_expr201);
                    	    b=signedterm();

                    	    state._fsp--;

                    	    bq.add(b, BooleanClause.Occur.MUST);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt10 >= 1 ) break loop10;
                                EarlyExitException eee =
                                    new EarlyExitException(10, input);
                                throw eee;
                        }
                        cnt10++;
                    } while (true);

                    q = bq;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return q;
    }
    // $ANTLR end "expr"


    // $ANTLR start "signedterm"
    // org/xcmis/search/antlr/FullText.g:187:1: signedterm returns [Query q] : ( term | NOT term );
    public final Query signedterm() throws RecognitionException {
        Query q = null;

        Query term2 = null;

        Query term3 = null;


        try {
            // org/xcmis/search/antlr/FullText.g:188:2: ( term | NOT term )
            int alt12=2;
            switch ( input.LA(1) ) {
            case QOUTED_SENTENCE:
            case WORD:
                {
                alt12=1;
                }
                break;
            case NOT:
                {
                alt12=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // org/xcmis/search/antlr/FullText.g:188:4: term
                    {
                    pushFollow(FOLLOW_term_in_signedterm242);
                    term2=term();

                    state._fsp--;

                    q = term2;

                    }
                    break;
                case 2 :
                    // org/xcmis/search/antlr/FullText.g:189:4: NOT term
                    {
                    match(input,NOT,FOLLOW_NOT_in_signedterm249); 
                    pushFollow(FOLLOW_term_in_signedterm251);
                    term3=term();

                    state._fsp--;


                    		BooleanQuery bq1 = new BooleanQuery();
                    	 	for(String field : fields)
                    	 	{
                    	 	 BooleanQuery bq = new BooleanQuery();
                         bq.add(new WildcardQuery(new Term(field,"*")),BooleanClause.Occur.SHOULD);
                    		 //bq.add(new MatchAllDocsQuery(),BooleanClause.Occur.SHOULD);
                    		 bq.add(term3, BooleanClause.Occur.MUST_NOT);
                         bq1.add(bq ,BooleanClause.Occur.SHOULD);
                    		}
                    		q =bq1;  
                    		

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return q;
    }
    // $ANTLR end "signedterm"


    // $ANTLR start "term"
    // org/xcmis/search/antlr/FullText.g:204:1: term returns [Query q] : ( word | qoutedterm );
    public final Query term() throws RecognitionException {
        Query q = null;

        FullTextParser.word_return word4 = null;

        FullTextParser.qoutedterm_return qoutedterm5 = null;


        try {
            // org/xcmis/search/antlr/FullText.g:205:2: ( word | qoutedterm )
            int alt13=2;
            switch ( input.LA(1) ) {
            case WORD:
                {
                alt13=1;
                }
                break;
            case QOUTED_SENTENCE:
                {
                alt13=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // org/xcmis/search/antlr/FullText.g:205:5: word
                    {
                    pushFollow(FOLLOW_word_in_term273);
                    word4=word();

                    state._fsp--;

                    q = (word4!=null?word4.q:null);

                    }
                    break;
                case 2 :
                    // org/xcmis/search/antlr/FullText.g:206:4: qoutedterm
                    {
                    pushFollow(FOLLOW_qoutedterm_in_term280);
                    qoutedterm5=qoutedterm();

                    state._fsp--;

                    q = (qoutedterm5!=null?qoutedterm5.q:null);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return q;
    }
    // $ANTLR end "term"

    public static class qoutedterm_return extends ParserRuleReturnScope {
        public Query q;
    };

    // $ANTLR start "qoutedterm"
    // org/xcmis/search/antlr/FullText.g:209:1: qoutedterm returns [Query q] : QOUTED_SENTENCE ;
    public final FullTextParser.qoutedterm_return qoutedterm() throws RecognitionException {
        FullTextParser.qoutedterm_return retval = new FullTextParser.qoutedterm_return();
        retval.start = input.LT(1);

        try {
            // org/xcmis/search/antlr/FullText.g:210:2: ( QOUTED_SENTENCE )
            // org/xcmis/search/antlr/FullText.g:210:4: QOUTED_SENTENCE
            {
            match(input,QOUTED_SENTENCE,FOLLOW_QOUTED_SENTENCE_in_qoutedterm297); 

            		BooleanQuery bq = new BooleanQuery();
            	 	for(String field : fields)
            	 	{
            		 QueryParser parser = new QueryParser(field,analyzer);
            		 try
            		   {
            		   bq.add(parser.parse(processEscSymb(input.toString(retval.start,input.LT(-1)))) ,BooleanClause.Occur.SHOULD); 
            		   }catch(org.apache.lucene.queryParser.ParseException e){
            		     reporter.reportMessage(e.getMessage());
            		   } 
            		 }
            		 retval.q =bq; 
            		

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "qoutedterm"

    public static class word_return extends ParserRuleReturnScope {
        public Query q;
    };

    // $ANTLR start "word"
    // org/xcmis/search/antlr/FullText.g:227:1: word returns [Query q] : WORD ;
    public final FullTextParser.word_return word() throws RecognitionException {
        FullTextParser.word_return retval = new FullTextParser.word_return();
        retval.start = input.LT(1);

        try {
            // org/xcmis/search/antlr/FullText.g:228:2: ( WORD )
            // org/xcmis/search/antlr/FullText.g:228:4: WORD
            {
            match(input,WORD,FOLLOW_WORD_in_word317); 

            	
            		BooleanQuery bq = new BooleanQuery();
            	        for(String field : fields)	  		   
            	 	{
            	 	  QueryParser parser = new QueryParser(field,analyzer);
            		  try{
            //	 	  bq.add( new TermQuery(new Term(field, processEscSymb(input.toString(retval.start,input.LT(-1))))),BooleanClause.Occur.SHOULD);
            		    bq.add(parser.parse(processEscSymb(input.toString(retval.start,input.LT(-1)))) ,BooleanClause.Occur.SHOULD); 
            	 	  }catch(org.apache.lucene.queryParser.ParseException e){
            	 	    reporter.reportMessage(e.getMessage());
            		  } 
            		}
            		retval.q = bq;		
            		

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "word"

    // Delegated rules


    protected DFA8 dfa8 = new DFA8(this);
    protected DFA6 dfa6 = new DFA6(this);
    protected DFA11 dfa11 = new DFA11(this);
    protected DFA10 dfa10 = new DFA10(this);
    static final String DFA8_eotS =
        "\17\uffff";
    static final String DFA8_eofS =
        "\2\uffff\2\6\1\uffff\1\6\1\uffff\4\6\2\uffff\2\6";
    static final String DFA8_minS =
        "\2\5\2\7\1\10\1\4\1\uffff\4\7\1\10\1\uffff\2\7";
    static final String DFA8_maxS =
        "\2\11\2\7\2\11\1\uffff\4\7\1\11\1\uffff\2\7";
    static final String DFA8_acceptS =
        "\6\uffff\1\1\5\uffff\1\2\2\uffff";
    static final String DFA8_specialS =
        "\17\uffff}>";
    static final String[] DFA8_transitionS = {
            "\1\4\1\uffff\1\1\1\3\1\2",
            "\1\4\1\uffff\1\1\1\3\1\2",
            "\1\5",
            "\1\5",
            "\1\10\1\7",
            "\1\14\1\13\1\uffff\1\5\1\12\1\11",
            "",
            "\1\5",
            "\1\5",
            "\1\5",
            "\1\5",
            "\1\16\1\15",
            "",
            "\1\5",
            "\1\5"
    };

    static final short[] DFA8_eot = DFA.unpackEncodedString(DFA8_eotS);
    static final short[] DFA8_eof = DFA.unpackEncodedString(DFA8_eofS);
    static final char[] DFA8_min = DFA.unpackEncodedStringToUnsignedChars(DFA8_minS);
    static final char[] DFA8_max = DFA.unpackEncodedStringToUnsignedChars(DFA8_maxS);
    static final short[] DFA8_accept = DFA.unpackEncodedString(DFA8_acceptS);
    static final short[] DFA8_special = DFA.unpackEncodedString(DFA8_specialS);
    static final short[][] DFA8_transition;

    static {
        int numStates = DFA8_transitionS.length;
        DFA8_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA8_transition[i] = DFA.unpackEncodedString(DFA8_transitionS[i]);
        }
    }

    class DFA8 extends DFA {

        public DFA8(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 8;
            this.eot = DFA8_eot;
            this.eof = DFA8_eof;
            this.min = DFA8_min;
            this.max = DFA8_max;
            this.accept = DFA8_accept;
            this.special = DFA8_special;
            this.transition = DFA8_transition;
        }
        public String getDescription() {
            return "165:1: fulltext[List<String> fd, Analyzer an] : ( ( WS )* expr ( WS )* | ( WS )* a= expr ( ( WS )+ OR ( WS )+ b= expr )+ ( WS )* );";
        }
    }
    static final String DFA6_eotS =
        "\4\uffff";
    static final String DFA6_eofS =
        "\2\2\2\uffff";
    static final String DFA6_minS =
        "\1\7\1\4\2\uffff";
    static final String DFA6_maxS =
        "\2\7\2\uffff";
    static final String DFA6_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA6_specialS =
        "\4\uffff}>";
    static final String[] DFA6_transitionS = {
            "\1\1",
            "\1\3\2\uffff\1\1",
            "",
            ""
    };

    static final short[] DFA6_eot = DFA.unpackEncodedString(DFA6_eotS);
    static final short[] DFA6_eof = DFA.unpackEncodedString(DFA6_eofS);
    static final char[] DFA6_min = DFA.unpackEncodedStringToUnsignedChars(DFA6_minS);
    static final char[] DFA6_max = DFA.unpackEncodedStringToUnsignedChars(DFA6_maxS);
    static final short[] DFA6_accept = DFA.unpackEncodedString(DFA6_acceptS);
    static final short[] DFA6_special = DFA.unpackEncodedString(DFA6_specialS);
    static final short[][] DFA6_transition;

    static {
        int numStates = DFA6_transitionS.length;
        DFA6_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA6_transition[i] = DFA.unpackEncodedString(DFA6_transitionS[i]);
        }
    }

    class DFA6 extends DFA {

        public DFA6(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 6;
            this.eot = DFA6_eot;
            this.eof = DFA6_eof;
            this.min = DFA6_min;
            this.max = DFA6_max;
            this.accept = DFA6_accept;
            this.special = DFA6_special;
            this.transition = DFA6_transition;
        }
        public String getDescription() {
            return "()+ loopback of 173:3: ( ( WS )+ OR ( WS )+ b= expr )+";
        }
    }
    static final String DFA11_eotS =
        "\11\uffff";
    static final String DFA11_eofS =
        "\1\uffff\2\5\1\uffff\1\5\1\uffff\2\5\1\uffff";
    static final String DFA11_minS =
        "\1\5\2\7\1\10\1\4\1\uffff\2\7\1\uffff";
    static final String DFA11_maxS =
        "\1\11\2\7\2\11\1\uffff\2\7\1\uffff";
    static final String DFA11_acceptS =
        "\5\uffff\1\1\2\uffff\1\2";
    static final String DFA11_specialS =
        "\11\uffff}>";
    static final String[] DFA11_transitionS = {
            "\1\3\2\uffff\1\2\1\1",
            "\1\4",
            "\1\4",
            "\1\7\1\6",
            "\1\5\1\10\1\uffff\1\4\2\10",
            "",
            "\1\4",
            "\1\4",
            ""
    };

    static final short[] DFA11_eot = DFA.unpackEncodedString(DFA11_eotS);
    static final short[] DFA11_eof = DFA.unpackEncodedString(DFA11_eofS);
    static final char[] DFA11_min = DFA.unpackEncodedStringToUnsignedChars(DFA11_minS);
    static final char[] DFA11_max = DFA.unpackEncodedStringToUnsignedChars(DFA11_maxS);
    static final short[] DFA11_accept = DFA.unpackEncodedString(DFA11_acceptS);
    static final short[] DFA11_special = DFA.unpackEncodedString(DFA11_specialS);
    static final short[][] DFA11_transition;

    static {
        int numStates = DFA11_transitionS.length;
        DFA11_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA11_transition[i] = DFA.unpackEncodedString(DFA11_transitionS[i]);
        }
    }

    class DFA11 extends DFA {

        public DFA11(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 11;
            this.eot = DFA11_eot;
            this.eof = DFA11_eof;
            this.min = DFA11_min;
            this.max = DFA11_max;
            this.accept = DFA11_accept;
            this.special = DFA11_special;
            this.transition = DFA11_transition;
        }
        public String getDescription() {
            return "177:1: expr returns [Query q] : (a= signedterm | a= signedterm ( ( WS )+ b= signedterm )+ );";
        }
    }
    static final String DFA10_eotS =
        "\4\uffff";
    static final String DFA10_eofS =
        "\2\2\2\uffff";
    static final String DFA10_minS =
        "\1\7\1\4\2\uffff";
    static final String DFA10_maxS =
        "\1\7\1\11\2\uffff";
    static final String DFA10_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA10_specialS =
        "\4\uffff}>";
    static final String[] DFA10_transitionS = {
            "\1\1",
            "\1\2\1\3\1\uffff\1\1\2\3",
            "",
            ""
    };

    static final short[] DFA10_eot = DFA.unpackEncodedString(DFA10_eotS);
    static final short[] DFA10_eof = DFA.unpackEncodedString(DFA10_eofS);
    static final char[] DFA10_min = DFA.unpackEncodedStringToUnsignedChars(DFA10_minS);
    static final char[] DFA10_max = DFA.unpackEncodedStringToUnsignedChars(DFA10_maxS);
    static final short[] DFA10_accept = DFA.unpackEncodedString(DFA10_acceptS);
    static final short[] DFA10_special = DFA.unpackEncodedString(DFA10_specialS);
    static final short[][] DFA10_transition;

    static {
        int numStates = DFA10_transitionS.length;
        DFA10_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA10_transition[i] = DFA.unpackEncodedString(DFA10_transitionS[i]);
        }
    }

    class DFA10 extends DFA {

        public DFA10(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 10;
            this.eot = DFA10_eot;
            this.eof = DFA10_eof;
            this.min = DFA10_min;
            this.max = DFA10_max;
            this.accept = DFA10_accept;
            this.special = DFA10_special;
            this.transition = DFA10_transition;
        }
        public String getDescription() {
            return "()+ loopback of 181:10: ( ( WS )+ b= signedterm )+";
        }
    }
 

    public static final BitSet FOLLOW_WS_in_fulltext78 = new BitSet(new long[]{0x00000000000003A0L});
    public static final BitSet FOLLOW_expr_in_fulltext81 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_WS_in_fulltext83 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_WS_in_fulltext98 = new BitSet(new long[]{0x00000000000003A0L});
    public static final BitSet FOLLOW_expr_in_fulltext103 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_WS_in_fulltext118 = new BitSet(new long[]{0x0000000000000090L});
    public static final BitSet FOLLOW_OR_in_fulltext121 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_WS_in_fulltext123 = new BitSet(new long[]{0x00000000000003A0L});
    public static final BitSet FOLLOW_expr_in_fulltext128 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_WS_in_fulltext134 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_signedterm_in_expr156 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_signedterm_in_expr177 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_WS_in_expr196 = new BitSet(new long[]{0x00000000000003A0L});
    public static final BitSet FOLLOW_signedterm_in_expr201 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_term_in_signedterm242 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_signedterm249 = new BitSet(new long[]{0x0000000000000300L});
    public static final BitSet FOLLOW_term_in_signedterm251 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_word_in_term273 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_qoutedterm_in_term280 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QOUTED_SENTENCE_in_qoutedterm297 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WORD_in_word317 = new BitSet(new long[]{0x0000000000000002L});

}