/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.xcmis.sp.inmemory.BaseObjectData;
import org.xcmis.sp.inmemory.BooleanValue;
import org.xcmis.sp.inmemory.ByteArrayValue;
import org.xcmis.sp.inmemory.DateValue;
import org.xcmis.sp.inmemory.Entry;
import org.xcmis.sp.inmemory.IntegerValue;
import org.xcmis.sp.inmemory.PropertyDefinitions;
import org.xcmis.sp.inmemory.StorageImpl;
import org.xcmis.sp.inmemory.StringValue;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.utils.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocumentDataImpl
extends BaseObjectData
implements DocumentData {
    public DocumentDataImpl(Entry entry, TypeDefinition type, StorageImpl storage) {
        super(entry, type, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCheckout() throws UpdateConflictException, VersioningException, StorageException {
        StorageImpl storageImpl = this.storage;
        synchronized (storageImpl) {
            String vsId = this.getVersionSeriesId();
            String pwcId = this.storage.workingCopies.get(vsId);
            if (pwcId == null) {
                return;
            }
            for (String parent : this.storage.parents.get(pwcId)) {
                this.storage.children.get(parent).remove(pwcId);
            }
            this.storage.parents.remove(pwcId);
            this.storage.unfiled.remove(pwcId);
            this.storage.workingCopies.remove(vsId);
            for (String version : this.storage.versions.get(this.getVersionSeriesId())) {
                Entry ventry = this.storage.entries.get(version);
                ventry.setValue("cmis:isVersionSeriesCheckedOut", new BooleanValue(false));
                ventry.setValue("cmis:versionSeriesCheckedOutId", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentData checkin(boolean major, String checkinComment, Map<String, Property<?>> properties, ContentStream contentStream, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, UpdateConflictException, StorageException {
        if (!this.isPWC()) {
            throw new CmisRuntimeException("Current object is not Private Working Copy.");
        }
        StorageImpl storageImpl = this.storage;
        synchronized (storageImpl) {
            String pwcId = this.getObjectId();
            int i = 1;
            for (String version : this.storage.versions.get(this.getVersionSeriesId())) {
                Entry ventry = this.storage.entries.get(version);
                ventry.setValue("cmis:isVersionSeriesCheckedOut", new BooleanValue(false));
                ventry.setValue("cmis:isLatestVersion", new BooleanValue(false));
                ventry.setValue("cmis:isLatestMajorVersion", new BooleanValue(false));
                ventry.setValue("cmis:versionSeriesCheckedOutBy", null);
                ventry.setValue("cmis:versionSeriesCheckedOutId", null);
                ventry.setValue("cmis:versionLabel", new StringValue("" + i++));
            }
            if (properties != null) {
                for (Property<?> property : properties.values()) {
                    this.doSetProperty(property);
                }
            }
            try {
                if (contentStream != null) {
                    this.doSetContentStream(contentStream);
                }
            }
            catch (IOException ioe) {
                throw new StorageException("Unable checkin PWC. " + ioe.getMessage(), (Throwable)ioe);
            }
            this.entry.setValue("cmis:versionLabel", new StringValue("latest"));
            this.entry.setValue("cmis:isLatestVersion", new BooleanValue(true));
            this.entry.setValue("cmis:isMajorVersion", new BooleanValue(major));
            this.entry.setValue("cmis:isLatestMajorVersion", new BooleanValue(major));
            this.entry.setValue("cmis:isVersionSeriesCheckedOut", new BooleanValue(false));
            this.entry.setValue("cmis:versionSeriesCheckedOutId", null);
            this.entry.setValue("cmis:versionSeriesCheckedOutBy", null);
            if (checkinComment != null) {
                this.entry.setValue("cmis:checkinComment", new StringValue(checkinComment));
            }
            this.storage.workingCopies.remove(this.getVersionSeriesId());
            this.storage.versions.get(this.getVersionSeriesId()).add(pwcId);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentData checkout() throws UpdateConflictException, VersioningException, StorageException {
        StorageImpl storageImpl = this.storage;
        synchronized (storageImpl) {
            if (this.storage.workingCopies.get(this.getVersionSeriesId()) != null) {
                throw new VersioningException("Version series already checked-out. Not allowed have more then one PWC for version series at a time.");
            }
            Entry pwc = new Entry();
            pwc.setValue("cmis:objectTypeId", new StringValue(this.type.getId()));
            pwc.setValue("cmis:baseTypeId", new StringValue(this.type.getBaseId().value()));
            pwc.setValue("cmis:versionSeriesId", new StringValue(this.getVersionSeriesId()));
            String pwcId = StorageImpl.generateId();
            pwc.setValue("cmis:objectId", new StringValue(pwcId));
            String userId = this.storage.getCurrentUser();
            pwc.setValue("cmis:createdBy", new StringValue(userId));
            pwc.setValue("cmis:lastModifiedBy", new StringValue(userId));
            Calendar cal = Calendar.getInstance();
            pwc.setValue("cmis:creationDate", new DateValue(cal));
            pwc.setValue("cmis:lastModificationDate", new DateValue(cal));
            pwc.setValue("cmis:isLatestVersion", new BooleanValue(false));
            pwc.setValue("cmis:isMajorVersion", new BooleanValue(false));
            pwc.setValue("cmis:versionLabel", new StringValue("pwc"));
            pwc.setValue("cmis:isVersionSeriesCheckedOut", new BooleanValue(true));
            pwc.setValue("cmis:versionSeriesCheckedOutId", new StringValue(pwcId));
            pwc.setValue("cmis:versionSeriesCheckedOutBy", new StringValue(userId));
            ByteArrayValue contentValue = (ByteArrayValue)this.entry.getValue("xcmis:content");
            if (contentValue != null) {
                String charset;
                byte[] src = contentValue.getBytes();
                this.storage.validateMemSize(src);
                byte[] bytes = new byte[src.length];
                System.arraycopy(src, 0, bytes, 0, bytes.length);
                pwc.setValue("xcmis:content", new ByteArrayValue(bytes));
                String mimeType = this.getContentStreamMimeType();
                if (mimeType != null) {
                    pwc.setValue("cmis:contentStreamMimeType", new StringValue(mimeType));
                }
                if ((charset = this.getString("charset")) != null) {
                    this.entry.setValue("charset", new StringValue(charset));
                }
                this.entry.setValue("cmis:contentStreamLength", new IntegerValue(BigInteger.valueOf(bytes.length)));
            }
            for (String version : this.storage.versions.get(this.getVersionSeriesId())) {
                Entry ventry = this.storage.entries.get(version);
                ventry.setValue("cmis:isVersionSeriesCheckedOut", new BooleanValue(true));
                ventry.setValue("cmis:versionSeriesCheckedOutId", new StringValue(pwcId));
                ventry.setValue("cmis:versionSeriesCheckedOutBy", new StringValue(userId));
            }
            this.storage.entries.put(pwcId, pwc);
            for (String parent : this.storage.parents.get(this.getObjectId())) {
                this.storage.children.get(parent).add(pwcId);
            }
            this.storage.parents.put(pwcId, new CopyOnWriteArraySet(this.storage.parents.get(this.getObjectId())));
            this.storage.workingCopies.put(this.getVersionSeriesId(), pwcId);
            DocumentDataImpl pwcObject = new DocumentDataImpl(pwc, new TypeDefinition(this.type.getId(), this.type.getBaseId(), this.type.getQueryName(), this.type.getLocalName(), this.type.getLocalNamespace(), this.type.getParentId(), this.type.getDisplayName(), this.type.getDescription(), this.type.isCreatable(), this.type.isFileable(), this.type.isQueryable(), this.type.isFulltextIndexed(), this.type.isIncludedInSupertypeQuery(), this.type.isControllablePolicy(), this.type.isControllableACL(), this.type.isVersionable(), this.type.getAllowedSourceTypes(), this.type.getAllowedTargetTypes(), this.type.getContentStreamAllowed(), PropertyDefinitions.getAll(this.getTypeId())), this.storage);
            return pwcObject;
        }
    }

    public ContentStream getContentStream() {
        ByteArrayValue contentValue = (ByteArrayValue)this.entry.getValue("xcmis:content");
        if (contentValue != null) {
            MimeType mimeType = MimeType.fromString((String)this.getString("cmis:contentStreamMimeType"));
            String charset = this.getString("charset");
            if (charset != null) {
                mimeType.getParameters().put("charset", charset);
            }
            return new BaseContentStream(contentValue.getBytes(), this.getName(), mimeType);
        }
        return null;
    }

    public ContentStream getContentStream(String streamId) {
        if (streamId == null || streamId.equals(this.getString("cmis:contentStreamId"))) {
            return this.getContentStream();
        }
        try {
            if (this.storage.renditionManager != null) {
                return this.storage.renditionManager.getStream((ObjectData)this, streamId);
            }
            return null;
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Unable get rendition stream. " + e.getMessage(), (Throwable)e);
        }
    }

    public String getContentStreamMimeType() {
        return this.getString("cmis:contentStreamMimeType");
    }

    public String getVersionLabel() {
        return this.getString("cmis:versionLabel");
    }

    public String getVersionSeriesCheckedOutBy() {
        return this.getString("cmis:versionSeriesCheckedOutBy");
    }

    public String getVersionSeriesCheckedOutId() {
        return this.getString("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesId() {
        return this.getString("cmis:versionSeriesId");
    }

    public boolean hasContent() {
        ByteArrayValue cv = (ByteArrayValue)this.entry.getValue("xcmis:content");
        return cv != null && cv.getBytes().length > 0;
    }

    public boolean isLatestMajorVersion() {
        return this.isLatestVersion() && this.isMajorVersion();
    }

    public boolean isLatestVersion() {
        Boolean latest = this.getBoolean("cmis:isLatestVersion");
        return latest == null ? true : latest;
    }

    public boolean isMajorVersion() {
        Boolean major = this.getBoolean("cmis:isMajorVersion");
        return major == null ? false : major;
    }

    public boolean isPWC() {
        return this.getObjectId().equals(this.getVersionSeriesCheckedOutId());
    }

    public boolean isVersionSeriesCheckedOut() {
        Boolean checkout = this.getBoolean("cmis:isVersionSeriesCheckedOut");
        return checkout == null ? false : checkout;
    }

    public void setContentStream(ContentStream contentStream) throws IOException, UpdateConflictException, VersioningException, StorageException {
        this.doSetContentStream(contentStream);
        this.save();
    }

    private void doSetContentStream(ContentStream contentStream) throws IOException, StorageException {
        if (contentStream == null || contentStream.getStream() == null) {
            this.entry.setValue("xcmis:content", null);
            this.entry.setValue("cmis:contentStreamMimeType", null);
            this.entry.setValue("charset", null);
            this.entry.setValue("cmis:contentStreamLength", new IntegerValue(BigInteger.valueOf(0L)));
        } else {
            ByteArrayValue cv = ByteArrayValue.fromStream(contentStream.getStream());
            this.storage.validateMemSize(cv.getBytes());
            MimeType mimeType = contentStream.getMediaType();
            this.entry.setValue("xcmis:content", cv);
            this.entry.setValue("cmis:contentStreamMimeType", new StringValue(mimeType.getBaseType()));
            String charset = mimeType.getParameter("charset");
            if (charset != null) {
                this.entry.setValue("charset", new StringValue(charset));
            }
            this.entry.setValue("cmis:contentStreamLength", new IntegerValue(BigInteger.valueOf(cv.getBytes().length)));
        }
    }

    @Override
    protected void delete() throws StorageException, UpdateConflictException, VersioningException {
        ItemsIterator<RelationshipData> relationships = this.getRelationships(RelationshipDirection.EITHER, null, true);
        if (relationships.hasNext()) {
            throw new StorageException("Object can't be deleted cause to storage referential integrity. Object is source or target at least one Relationship.");
        }
        if (this.isPWC()) {
            this.cancelCheckout();
        } else {
            String objectId = this.getObjectId();
            String vsId = this.getVersionSeriesId();
            this.storage.entries.remove(objectId);
            for (String parent : this.storage.parents.get(objectId)) {
                this.storage.children.get(parent).remove(objectId);
            }
            this.storage.parents.remove(objectId);
            this.storage.unfiled.remove(objectId);
            this.storage.versions.get(vsId).remove(objectId);
        }
    }
}

