/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Choice;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDefinitions {
    private static final Map<String, Map<String, PropertyDefinition<?>>> all = new HashMap();
    static final String CONTENT = "xcmis:content";
    static final String LATEST_LABEL = "latest";
    static final String PWC_LABEL = "pwc";

    public static Map<String, PropertyDefinition<?>> getAll(String objectTypeId) {
        Map<String, PropertyDefinition<?>> defs = all.get(objectTypeId);
        if (defs == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(defs);
    }

    public static PropertyDefinition<?> getPropertyDefinition(String objectTypeId, String propDefId) {
        Map<String, PropertyDefinition<?>> defs = all.get(objectTypeId);
        if (defs == null) {
            return null;
        }
        return defs.get(propDefId);
    }

    public static Set<String> getPropertyIds(String objectTypeId) {
        Map<String, PropertyDefinition<?>> defs = all.get(objectTypeId);
        if (defs == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(defs.keySet());
    }

    public static void put(String typeId, PropertyDefinition<?> propDef) {
        Map<String, PropertyDefinition<?>> defs = all.get(typeId);
        if (defs == null) {
            defs = new HashMap();
            all.put(typeId, defs);
        }
        defs.put(propDef.getId(), propDef);
    }

    public static void putAll(String typeId, Map<String, PropertyDefinition<?>> propDefs) {
        Map<String, PropertyDefinition<?>> defs = all.get(typeId);
        if (defs == null) {
            defs = new HashMap();
            all.put(typeId, defs);
        }
        defs.putAll(propDefs);
    }

    public static void removeAll(String typeId) {
        all.remove(typeId);
    }

    private static <T> PropertyDefinition<T> createPropertyDefinition(String id, PropertyType propertyType, String queryName, String localName, String localNamespace, String displayName, boolean required, boolean queryable, boolean orderable, boolean inherited, boolean isMultivalued, Updatability updatability, String description, Boolean openChoice, List<Choice<T>> choices, T[] defValue) {
        PropertyDefinition propertyDefinition = new PropertyDefinition(id, queryName, localName, localNamespace, displayName, description, propertyType, updatability, inherited, required, queryable, orderable, openChoice, isMultivalued, choices, (Object[])defValue);
        return propertyDefinition;
    }

    private PropertyDefinitions() {
    }

    static {
        for (BaseType objectType : BaseType.values()) {
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:baseTypeId", PropertyType.ID, "cmis:baseTypeId", "cmis:baseTypeId", null, "cmis:baseTypeId", false, false, false, false, false, Updatability.READONLY, "Base type id.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:objectTypeId", PropertyType.ID, "cmis:objectTypeId", "cmis:objectTypeId", null, "cmis:objectTypeId", false, false, false, false, false, Updatability.READONLY, "Object type id.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:objectId", PropertyType.ID, "cmis:objectId", "cmis:objectId", null, "cmis:objectId", false, false, false, false, false, Updatability.READONLY, "Object id.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:name", PropertyType.STRING, "cmis:name", "cmis:name", null, "cmis:name", true, false, false, false, false, Updatability.READWRITE, "Object name.", true, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:createdBy", PropertyType.STRING, "cmis:createdBy", "cmis:createdBy", null, "cmis:createdBy", false, false, false, false, false, Updatability.READONLY, "User who created the object.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:creationDate", PropertyType.DATETIME, "cmis:creationDate", "cmis:creationDate", null, "cmis:creationDate", false, false, false, false, false, Updatability.READONLY, "DateTime when the object was created.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:lastModifiedBy", PropertyType.STRING, "cmis:lastModifiedBy", "cmis:lastModifiedBy", null, "cmis:lastModifiedBy", false, false, false, false, false, Updatability.READONLY, "User who last modified the object.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:lastModificationDate", PropertyType.DATETIME, "cmis:lastModificationDate", "cmis:lastModificationDate", null, "cmis:lastModificationDate", false, false, false, false, false, Updatability.READONLY, "DateTime when the object was last modified.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:changeToken", PropertyType.STRING, "cmis:changeToken", "cmis:changeToken", null, "cmis:changeToken", false, false, false, false, false, Updatability.READONLY, "Opaque token used for optimistic locking.", null, null, null));
            if (objectType == BaseType.DOCUMENT) {
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:isImmutable", PropertyType.BOOLEAN, "cmis:isImmutable", "cmis:isImmutable", null, "cmis:isImmutable", false, false, false, false, false, Updatability.READONLY, "TRUE if the repository MUST throw an error at any attempt to update or delete the object.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:isLatestVersion", PropertyType.BOOLEAN, "cmis:isLatestVersion", "cmis:isLatestVersion", null, "cmis:isLatestVersion", false, false, false, false, false, Updatability.READONLY, "TRUE if object represents latest version of object.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:isMajorVersion", PropertyType.BOOLEAN, "cmis:isMajorVersion", "cmis:isMajorVersion", null, "cmis:isMajorVersion", false, false, false, false, false, Updatability.WHENCHECKEDOUT, "TRUE if object represents major version of object.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:isLatestMajorVersion", PropertyType.BOOLEAN, "cmis:isLatestMajorVersion", "cmis:isLatestMajorVersion", null, "cmis:isLatestMajorVersion", false, false, false, false, false, Updatability.READONLY, "TRUE if object represents latest major version of object.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:versionLabel", PropertyType.STRING, "cmis:versionLabel", "cmis:versionLabel", null, "cmis:versionLabel", false, false, false, false, false, Updatability.READONLY, "Version label.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:versionSeriesId", PropertyType.ID, "cmis:versionSeriesId", "cmis:versionSeriesId", null, "cmis:versionSeriesId", false, false, false, false, false, Updatability.READONLY, "ID of version series.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:isVersionSeriesCheckedOut", PropertyType.BOOLEAN, "cmis:isVersionSeriesCheckedOut", "cmis:isVersionSeriesCheckedOut", null, "cmis:isVersionSeriesCheckedOut", false, false, false, false, false, Updatability.READONLY, "TRUE if some document in version series is checkedout.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:versionSeriesCheckedOutBy", PropertyType.STRING, "cmis:versionSeriesCheckedOutBy", "cmis:versionSeriesCheckedOutBy", null, "cmis:versionSeriesCheckedOutBy", false, false, false, false, false, Updatability.READONLY, "User who checkedout document.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:versionSeriesCheckedOutId", PropertyType.ID, "cmis:versionSeriesCheckedOutId", "cmis:versionSeriesCheckedOutId", null, "cmis:versionSeriesCheckedOutId", false, false, false, false, false, Updatability.READONLY, "ID of checkedout document.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:checkinComment", PropertyType.STRING, "cmis:checkinComment", "cmis:checkinComment", null, "cmis:checkinComment", false, false, false, false, false, Updatability.WHENCHECKEDOUT, "Check-In comment.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:contentStreamLength", PropertyType.INTEGER, "cmis:contentStreamLength", "cmis:contentStreamLength", null, "cmis:contentStreamLength", false, false, false, false, false, Updatability.READONLY, "Length of document content in bytes.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:contentStreamMimeType", PropertyType.STRING, "cmis:contentStreamMimeType", "cmis:contentStreamMimeType", null, "cmis:contentStreamMimeType", false, false, false, false, false, Updatability.READONLY, "Media type of document content.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:contentStreamFileName", PropertyType.STRING, "cmis:contentStreamFileName", "cmis:contentStreamFileName", null, "cmis:contentStreamFileName", false, false, false, false, false, Updatability.READONLY, "Document's content file name.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:contentStreamId", PropertyType.ID, "cmis:contentStreamId", "cmis:contentStreamId", null, "cmis:contentStreamId", false, false, false, false, false, Updatability.READONLY, "Document's content stream ID.", null, null, null));
                continue;
            }
            if (objectType == BaseType.FOLDER) {
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:parentId", PropertyType.ID, "cmis:parentId", "cmis:parentId", null, "cmis:parentId", false, false, false, false, false, Updatability.READONLY, "ID of parent folder.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:allowedChildObjectTypeIds", PropertyType.ID, "cmis:allowedChildObjectTypeIds", "cmis:allowedChildObjectTypeIds", null, "cmis:allowedChildObjectTypeIds", false, false, false, false, true, Updatability.READONLY, "Set of allowed child types for folder.", null, null, null));
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:path", PropertyType.STRING, "cmis:path", "cmis:path", null, "cmis:path", false, false, false, false, false, Updatability.READONLY, "Full path to folder object.", null, null, null));
                continue;
            }
            if (objectType == BaseType.POLICY) {
                PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:policyText", PropertyType.STRING, "cmis:policyText", "cmis:policyText", null, "cmis:policyText", true, false, false, false, false, Updatability.ONCREATE, "User-friendly description of the policy.", null, null, null));
                continue;
            }
            if (objectType != BaseType.RELATIONSHIP) continue;
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:sourceId", PropertyType.ID, "cmis:sourceId", "cmis:sourceId", null, "cmis:sourceId", false, false, false, false, false, Updatability.READONLY, "ID of relationship's source object.", null, null, null));
            PropertyDefinitions.put(objectType.value(), PropertyDefinitions.createPropertyDefinition("cmis:targetId", PropertyType.ID, "cmis:targetId", "cmis:targetId", null, "cmis:targetId", false, false, false, false, false, Updatability.READONLY, "ID of relationship's target object.", null, null, null));
        }
    }
}

