/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.sp.inmemory.BaseObjectData;
import org.xcmis.sp.inmemory.Entry;
import org.xcmis.sp.inmemory.StorageImpl;
import org.xcmis.sp.inmemory.Value;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FolderDataImpl
extends BaseObjectData
implements FolderData {
    private static final Log LOG = ExoLogger.getLogger(FolderDataImpl.class);

    public FolderDataImpl(Entry entry, TypeDefinition type, StorageImpl storage) {
        super(entry, type, storage);
    }

    public void addObject(ObjectData object) throws ConstraintException {
        this.storage.children.get(this.getObjectId()).add(object.getObjectId());
        this.storage.parents.get(object.getObjectId()).add(this.getObjectId());
        this.storage.unfiled.remove(object.getObjectId());
        this.storage.indexListener.updated(object);
    }

    public ItemsIterator<ObjectData> getChildren(String orderBy) {
        Set<String> childrenIds = this.storage.children.get(this.getObjectId());
        ArrayList<ObjectData> children = new ArrayList<ObjectData>(childrenIds.size());
        for (String ch : childrenIds) {
            ObjectData object = null;
            try {
                object = this.storage.getObjectById(ch);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn((Object)("Object " + ch + " not found in storage."));
                continue;
            }
            if (object.getBaseType() == BaseType.DOCUMENT && !((DocumentData)object).isLatestVersion()) continue;
            children.add(object);
        }
        return new BaseItemsIterator(children);
    }

    public ContentStream getContentStream(String streamId) {
        return null;
    }

    public String getPath() {
        return this.calculatePath().toString();
    }

    public boolean hasChildren() {
        return this.storage.children.get(this.getObjectId()).size() > 0;
    }

    public boolean isAllowedChildType(String typeId) {
        Value value = this.entry.getValue("cmis:allowedChildObjectTypeIds");
        return value == null || value.getStrings().length <= 0 || Arrays.asList(value.getStrings()).contains(typeId);
    }

    public boolean isRoot() {
        return "abcdef12-3456-7890-0987-654321fedcba".equals(this.getObjectId());
    }

    public void removeObject(ObjectData object) {
        this.storage.children.get(this.getObjectId()).remove(object.getObjectId());
        this.storage.parents.get(object.getObjectId()).remove(this.getObjectId());
        if (this.storage.parents.get(object.getObjectId()).size() == 0) {
            this.storage.unfiled.add(object.getObjectId());
        }
        if (this.storage.indexListener != null) {
            this.storage.indexListener.updated(object);
        }
    }

    private String calculatePath() {
        if (this.isRoot()) {
            return "/";
        }
        LinkedList<String> pathSegms = new LinkedList<String>();
        pathSegms.add(this.getName());
        try {
            FolderData parent = this.getParent();
            while (!parent.isRoot()) {
                pathSegms.addFirst(parent.getName());
                parent = parent.getParent();
            }
        }
        catch (ConstraintException e) {
            throw new CmisRuntimeException("Unable get object path.", (Throwable)e);
        }
        StringBuilder path = new StringBuilder();
        path.append('/');
        for (String seg : pathSegms) {
            if (path.length() > 1) {
                path.append('/');
            }
            path.append(seg);
        }
        return path.toString();
    }

    @Override
    protected void delete() throws UpdateConflictException, VersioningException, StorageException {
        ItemsIterator<RelationshipData> relationships = this.getRelationships(RelationshipDirection.EITHER, null, true);
        if (relationships.hasNext()) {
            throw new StorageException("Object can't be deleted cause to storage referential integrity. Object is source or target at least one Relationship.");
        }
        String objectId = this.getObjectId();
        this.storage.entries.remove(objectId);
        for (String parent : this.storage.parents.get(objectId)) {
            this.storage.children.get(parent).remove(objectId);
        }
        this.storage.parents.remove(objectId);
        this.storage.children.remove(objectId);
    }
}

