/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageConfiguration {
    private String id;
    private String name;
    private String description;
    private Map<String, Object> properties;
    public static String MAX_STORAGE_MEM_SIZE = "org.xcmis.inmemory.maxmem";
    public static String MAX_ITEMS_NUMBER = "org.xcmis.inmemory.maxitems";
    public static int DEFAULT_MAX_STORAGE_MEM_SIZE = 0x6400000;
    public static int DEFAULT_MAX_STORAGE_NUMBER_ITEMS = 100;

    public StorageConfiguration() {
    }

    public StorageConfiguration(String id, Map<String, Object> properties) {
        this.id = id;
        this.properties = properties;
    }

    public StorageConfiguration(String id, String name, String description, String maxMem, String maxObjects) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.properties = new HashMap<String, Object>();
        if (maxMem != null) {
            this.properties.put(MAX_STORAGE_MEM_SIZE, maxMem);
        }
        if (maxObjects != null) {
            this.properties.put(MAX_ITEMS_NUMBER, maxObjects);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Double parseNumber(String text) {
        if ((text = text.toUpperCase()).endsWith("K")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1024.0;
        }
        if (text.endsWith("KB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1024.0;
        }
        if (text.endsWith("M")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1048576.0;
        }
        if (text.endsWith("MB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1048576.0;
        }
        if (text.endsWith("G")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1.073741824E9;
        }
        if (text.endsWith("GB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1.073741824E9;
        }
        if (text.endsWith("T")) {
            return Double.valueOf(text.substring(0, text.length() - 1)) * 1.099511627776E12;
        }
        if (text.endsWith("TB")) {
            return Double.valueOf(text.substring(0, text.length() - 2)) * 1.099511627776E12;
        }
        return Double.valueOf(text);
    }
}

