/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.SearchService;
import org.xcmis.search.SearchServiceException;
import org.xcmis.search.Visitors;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.SearchServiceConfiguration;
import org.xcmis.search.content.Schema;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.interceptors.ContentReaderInterceptor;
import org.xcmis.search.lucene.content.VirtualTableResolver;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.parser.CmisQueryParser;
import org.xcmis.search.parser.QueryParser;
import org.xcmis.search.query.QueryExecutionException;
import org.xcmis.search.result.ScoredRow;
import org.xcmis.search.value.NameConverter;
import org.xcmis.search.value.PathSplitter;
import org.xcmis.search.value.SlashSplitter;
import org.xcmis.search.value.ToStringNameConverter;
import org.xcmis.sp.inmemory.BaseObjectData;
import org.xcmis.sp.inmemory.BooleanValue;
import org.xcmis.sp.inmemory.ByteArrayValue;
import org.xcmis.sp.inmemory.DateValue;
import org.xcmis.sp.inmemory.DocumentDataImpl;
import org.xcmis.sp.inmemory.Entry;
import org.xcmis.sp.inmemory.FolderDataImpl;
import org.xcmis.sp.inmemory.IntegerValue;
import org.xcmis.sp.inmemory.PolicyDataImpl;
import org.xcmis.sp.inmemory.PropertyDefinitions;
import org.xcmis.sp.inmemory.RelationshipDataImpl;
import org.xcmis.sp.inmemory.StorageConfiguration;
import org.xcmis.sp.inmemory.StringValue;
import org.xcmis.sp.inmemory.Value;
import org.xcmis.sp.inmemory.query.CmisContentReader;
import org.xcmis.sp.inmemory.query.CmisSchema;
import org.xcmis.sp.inmemory.query.CmisSchemaTableResolver;
import org.xcmis.sp.inmemory.query.IndexListener;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectDataVisitor;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.Storage;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeManager;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.ACLCapability;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AccessControlPropagation;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.CapabilityChanges;
import org.xcmis.spi.model.CapabilityContentStreamUpdatable;
import org.xcmis.spi.model.CapabilityJoin;
import org.xcmis.spi.model.CapabilityQuery;
import org.xcmis.spi.model.CapabilityRendition;
import org.xcmis.spi.model.ChangeEvent;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.Permission;
import org.xcmis.spi.model.PermissionMapping;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.RepositoryCapabilities;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.SupportedPermissions;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.query.Query;
import org.xcmis.spi.query.Result;
import org.xcmis.spi.query.Score;
import org.xcmis.spi.utils.CmisDocumentReaderService;
import org.xcmis.spi.utils.CmisUtils;
import org.xcmis.spi.utils.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageImpl
implements Storage {
    private static final Log LOG = ExoLogger.getLogger(StorageImpl.class);
    final Map<String, Entry> entries;
    final Map<String, Set<String>> children;
    final Map<String, Set<String>> parents;
    final Set<String> unfiled;
    final Map<String, Set<String>> relationships;
    final Map<String, List<String>> versions;
    final Map<String, String> workingCopies;
    final Map<String, TypeDefinition> types;
    final Map<String, Set<String>> typeChildren;
    private RepositoryInfo repositoryInfo;
    final SearchService searchService;
    final QueryParser cmisQueryParser;
    protected RenditionManager renditionManager;
    private final StorageConfiguration configuration;
    final IndexListener indexListener;
    static final String ROOT_FOLDER_ID = "abcdef12-3456-7890-0987-654321fedcba";
    static final Set<String> EMPTY_PARENTS = Collections.emptySet();
    private static final String VENDOR_NAME = "eXo";
    private static final String REPOSITORY_DESCRIPTION = "xCMIS (eXo InMemory SP)";
    private static final String PRODUCT_VERSION = "1.1";
    private static final String PRODUCT_NAME = "xCMIS (eXo InMemory SP)";
    private final long maxStorageMemSize;
    private final int maxItemsNumber;
    private PermissionService permissionService;

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public StorageImpl(StorageConfiguration configuration, RenditionManager manager, PermissionService permissionService) {
        this(configuration);
        this.renditionManager = manager;
        this.permissionService = permissionService;
    }

    public StorageImpl(StorageConfiguration configuration) {
        this.configuration = configuration;
        this.maxStorageMemSize = configuration.getProperties().get(StorageConfiguration.MAX_STORAGE_MEM_SIZE) == null ? (long)StorageConfiguration.DEFAULT_MAX_STORAGE_MEM_SIZE : StorageConfiguration.parseNumber((String)configuration.getProperties().get(StorageConfiguration.MAX_STORAGE_MEM_SIZE)).longValue();
        this.maxItemsNumber = configuration.getProperties().get(StorageConfiguration.MAX_ITEMS_NUMBER) == null ? StorageConfiguration.DEFAULT_MAX_STORAGE_NUMBER_ITEMS : StorageConfiguration.parseNumber((String)configuration.getProperties().get(StorageConfiguration.MAX_ITEMS_NUMBER)).intValue();
        this.entries = new ConcurrentHashMap<String, Entry>();
        this.children = new ConcurrentHashMap<String, Set<String>>();
        this.parents = new ConcurrentHashMap<String, Set<String>>();
        this.versions = new ConcurrentHashMap<String, List<String>>();
        this.workingCopies = new ConcurrentHashMap<String, String>();
        this.unfiled = new CopyOnWriteArraySet<String>();
        this.relationships = new ConcurrentHashMap<String, Set<String>>();
        this.types = new ConcurrentHashMap<String, TypeDefinition>();
        PermissionMapping permissionMapping = new PermissionMapping();
        permissionMapping.put("canGetDescendents.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetFolderTree.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetChildren.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetObjectParents.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetFolderParent.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canCreateDocument.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canCreateFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canCreateRelationship.Source", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canCreateRelationship.Target", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetProperties.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetContentStream.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canRenditions.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canUpdateProperties.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canMoveObject.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canMoveObject.Target", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canMoveObject.Source", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canDelete.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canDeleteTree.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canSetContentStream.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canDeleteContentStream.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canAddToFolder.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canAddToFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canRemoveObjectFromFolder.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canRemoveObjectFromFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canCheckout.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canCancelCheckout.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canCheckin.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canGetAllVersions.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetObjectRelationships.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canAddPolicy.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canAddPolicy.Policy", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canRemovePolicy.Object", Arrays.asList(Permission.BasicPermissions.CMIS_WRITE.value()));
        permissionMapping.put("canRemovePolicy.Policy", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetAppliedPolicies.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canGetACL.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
        permissionMapping.put("canApplyACL.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
        ArrayList<Permission> supportedPermissions = new ArrayList<Permission>(4);
        for (Permission.BasicPermissions b : Permission.BasicPermissions.values()) {
            supportedPermissions.add(new Permission(b.value(), ""));
        }
        this.repositoryInfo = new RepositoryInfo(this.getId(), this.getId(), ROOT_FOLDER_ID, "1.0", new RepositoryCapabilities(CapabilityACL.MANAGE, CapabilityChanges.NONE, CapabilityContentStreamUpdatable.ANYTIME, CapabilityJoin.NONE, CapabilityQuery.BOTHCOMBINED, CapabilityRendition.READ, false, true, true, true, false, true, true, false), new ACLCapability(permissionMapping, Collections.unmodifiableList(supportedPermissions), AccessControlPropagation.REPOSITORYDETERMINED, SupportedPermissions.BASIC), "anonymous", "any", null, null, true, "xCMIS (eXo InMemory SP)", VENDOR_NAME, "xCMIS (eXo InMemory SP)", PRODUCT_VERSION, null);
        this.types.put("cmis:document", new TypeDefinition("cmis:document", BaseType.DOCUMENT, "cmis:document", "cmis:document", "", null, "cmis:document", "Cmis Document Type", true, true, true, true, true, true, true, true, null, null, ContentStreamAllowed.ALLOWED, null));
        this.types.put("cmis:folder", new TypeDefinition("cmis:folder", BaseType.FOLDER, "cmis:folder", "cmis:folder", "", null, "cmis:folder", "Cmis Folder type", true, true, true, false, true, true, true, false, null, null, ContentStreamAllowed.NOT_ALLOWED, null));
        this.types.put("cmis:policy", new TypeDefinition("cmis:policy", BaseType.POLICY, "cmis:policy", "cmis:policy", "", null, "cmis:policy", "Cmis Policy type", true, false, true, false, true, true, true, false, null, null, ContentStreamAllowed.NOT_ALLOWED, null));
        this.types.put("cmis:relationship", new TypeDefinition("cmis:relationship", BaseType.RELATIONSHIP, "cmis:relationship", "cmis:relationship", "", null, "cmis:relationship", "Cmis Relationship type.", true, false, true, false, true, true, true, false, null, null, ContentStreamAllowed.NOT_ALLOWED, null));
        this.typeChildren = new ConcurrentHashMap<String, Set<String>>();
        this.typeChildren.put("cmis:document", new HashSet());
        this.typeChildren.put("cmis:folder", new HashSet());
        this.typeChildren.put("cmis:policy", new HashSet());
        this.typeChildren.put("cmis:relationship", new HashSet());
        ConcurrentHashMap<String, Value> root = new ConcurrentHashMap<String, Value>();
        root.put("cmis:name", new StringValue(""));
        root.put("cmis:objectId", new StringValue(ROOT_FOLDER_ID));
        root.put("cmis:objectTypeId", new StringValue("cmis:folder"));
        root.put("cmis:baseTypeId", new StringValue(BaseType.FOLDER.value()));
        root.put("cmis:creationDate", new DateValue(Calendar.getInstance()));
        root.put("cmis:createdBy", new StringValue("system"));
        root.put("cmis:lastModificationDate", new DateValue(Calendar.getInstance()));
        root.put("cmis:lastModifiedBy", new StringValue("system"));
        HashMap<String, Set<String>> pm = new HashMap<String, Set<String>>();
        HashSet<String> perms = new HashSet<String>();
        perms.add("cmis:all");
        pm.put("any", perms);
        Entry rootEntry = new Entry(root, null, pm);
        this.entries.put(rootEntry.getId(), rootEntry);
        this.parents.put(ROOT_FOLDER_ID, EMPTY_PARENTS);
        this.children.put(ROOT_FOLDER_ID, new CopyOnWriteArraySet());
        this.searchService = this.getInitializedSearchService();
        this.indexListener = new IndexListener(this, this.searchService);
        this.cmisQueryParser = new CmisQueryParser();
    }

    public AllowableActions calculateAllowableActions(ObjectData object) {
        ConversationState state = ConversationState.getCurrent();
        AllowableActions actions = this.permissionService.calculateAllowableActions(object, state != null ? state.getIdentity() : null, this.getRepositoryInfo());
        return actions;
    }

    public DocumentData copyDocument(DocumentData source, FolderData parent, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, StorageException {
        TypeDefinition typeDefinition = source.getTypeDefinition();
        Property<?> nameProperty = null;
        if (properties == null) {
            properties = new HashMap();
        } else {
            nameProperty = properties.get("cmis:name");
        }
        String name = null;
        if (nameProperty == null || nameProperty.getValues().size() == 0 || (name = (String)nameProperty.getValues().get(0)) == null || name.length() == 0) {
            name = source.getName();
            PropertyDefinition namePropertyDefinition = typeDefinition.getPropertyDefinition("cmis:name");
            properties.put(namePropertyDefinition.getId(), (Property<?>)new StringProperty(namePropertyDefinition.getId(), namePropertyDefinition.getQueryName(), namePropertyDefinition.getLocalName(), namePropertyDefinition.getDisplayName(), name));
        }
        try {
            return this.createDocument(parent, typeDefinition, properties, source.getContentStream(), acl, policies, versioningState);
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException("Unable copy content for new document. " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    public DocumentData createDocument(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, IOException, StorageException {
        Collection<String> set;
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null && nameProperty.getValues().size() > 0) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null && content != null) {
            name = content.getFileName();
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new document must be provided.");
        }
        if (parent != null) {
            ItemsIterator iterator = parent.getChildren(null);
            while (iterator.hasNext()) {
                if (!name.equals(((ObjectData)iterator.next()).getName())) continue;
                throw new NameConstraintViolationException("Object with name " + name + " already exists in parent folder.");
            }
        }
        Entry docEntry = new Entry();
        docEntry.setValue("cmis:objectTypeId", new StringValue(typeDefinition.getId()));
        docEntry.setValue("cmis:baseTypeId", new StringValue(typeDefinition.getBaseId().value()));
        docEntry.setValue("cmis:isImmutable", new BooleanValue(false));
        String docId = StorageImpl.generateId();
        String verSerId = StorageImpl.generateId();
        docEntry.setValue("cmis:objectId", new StringValue(docId));
        docEntry.setValue("cmis:versionSeriesId", new StringValue(verSerId));
        String userId = this.getCurrentUser();
        docEntry.setValue("cmis:createdBy", new StringValue(userId));
        docEntry.setValue("cmis:lastModifiedBy", new StringValue(userId));
        Calendar cal = Calendar.getInstance();
        docEntry.setValue("cmis:creationDate", new DateValue(cal));
        docEntry.setValue("cmis:lastModificationDate", new DateValue(cal));
        docEntry.setValue("cmis:isLatestVersion", new BooleanValue(true));
        docEntry.setValue("cmis:isMajorVersion", new BooleanValue(versioningState == VersioningState.MAJOR));
        docEntry.setValue("cmis:isLatestMajorVersion", new BooleanValue(versioningState == VersioningState.MAJOR));
        docEntry.setValue("cmis:versionLabel", new StringValue("latest"));
        docEntry.setValue("cmis:isVersionSeriesCheckedOut", new BooleanValue(false));
        if (content != null) {
            ByteArrayValue cv = ByteArrayValue.fromStream(content.getStream());
            docEntry.setValue("xcmis:content", cv);
            MimeType mimeType = content.getMediaType();
            docEntry.setValue("cmis:contentStreamMimeType", new StringValue(mimeType.getBaseType()));
            String charset = mimeType.getParameter("charset");
            if (charset != null) {
                docEntry.setValue("charset", new StringValue(charset));
            }
            docEntry.setValue("cmis:contentStreamLength", new IntegerValue(BigInteger.valueOf(cv.getBytes().length)));
            docEntry.setValue("cmis:contentStreamId", new StringValue(docId));
            docEntry.setValue("cmis:contentStreamFileName", new StringValue(name));
        }
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            docEntry.setProperty(property);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                docEntry.addPolicy(policy);
            }
        }
        if (acl != null && acl.size() > 0) {
            CmisUtils.addAclToPermissionMap(docEntry.getPermissions(), acl);
        }
        if (parent != null) {
            this.children.get(parent.getObjectId()).add(docId);
            set = new CopyOnWriteArraySet<String>();
            set.add(parent.getObjectId());
            this.parents.put(docId, (Set<String>)set);
        } else {
            this.unfiled.add(docId);
            this.parents.put(docId, new CopyOnWriteArraySet());
        }
        set = new CopyOnWriteArrayList();
        set.add(docId);
        this.versions.put(verSerId, (List<String>)set);
        this.entries.put(docId, docEntry);
        DocumentDataImpl document = new DocumentDataImpl(docEntry, typeDefinition, this);
        if (this.indexListener != null) {
            this.indexListener.created(document);
        }
        return document;
    }

    public FolderData createFolder(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        if (parent == null) {
            throw new ConstraintException("Parent folder must be provided.");
        }
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null && nameProperty.getValues().size() > 0) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new folder must be provided.");
        }
        ItemsIterator iterator = parent.getChildren(null);
        while (iterator.hasNext()) {
            if (!name.equals(((ObjectData)iterator.next()).getName())) continue;
            throw new NameConstraintViolationException("Object with name " + name + " already exists in parent folder.");
        }
        Entry folderEntry = new Entry();
        folderEntry.setValue("cmis:objectTypeId", new StringValue(typeDefinition.getId()));
        folderEntry.setValue("cmis:baseTypeId", new StringValue(typeDefinition.getBaseId().value()));
        String folderId = StorageImpl.generateId();
        folderEntry.setValue("cmis:objectId", new StringValue(folderId));
        String userId = this.getCurrentUser();
        folderEntry.setValue("cmis:createdBy", new StringValue(userId));
        folderEntry.setValue("cmis:lastModifiedBy", new StringValue(userId));
        Calendar cal = Calendar.getInstance();
        folderEntry.setValue("cmis:creationDate", new DateValue(cal));
        folderEntry.setValue("cmis:lastModificationDate", new DateValue(cal));
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            folderEntry.setProperty(property);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                folderEntry.addPolicy(policy);
            }
        }
        if (acl != null && acl.size() > 0) {
            CmisUtils.addAclToPermissionMap(folderEntry.getPermissions(), acl);
        }
        this.children.get(parent.getObjectId()).add(folderId);
        CopyOnWriteArraySet<String> set = new CopyOnWriteArraySet<String>();
        set.add(parent.getObjectId());
        this.parents.put(folderId, set);
        this.entries.put(folderId, folderEntry);
        this.children.put(folderId, new CopyOnWriteArraySet());
        FolderDataImpl folder = new FolderDataImpl(folderEntry, typeDefinition, this);
        if (this.indexListener != null) {
            this.indexListener.created(folder);
        }
        return folder;
    }

    public PolicyData createPolicy(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null && nameProperty.getValues().size() > 0) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new policy must be provided.");
        }
        for (Entry next : this.entries.values()) {
            String typeId = next.getTypeId();
            try {
                String name1;
                TypeDefinition type = this.getTypeDefinition(typeId, false);
                if (type.getBaseId() != BaseType.POLICY || !name.equals(name1 = next.getValue("cmis:name").getStrings()[0])) continue;
                throw new NameConstraintViolationException("Policy with name " + name + " already exists.");
            }
            catch (TypeNotFoundException e) {
            }
        }
        Entry policyEntry = new Entry();
        policyEntry.setValue("cmis:objectTypeId", new StringValue(typeDefinition.getId()));
        policyEntry.setValue("cmis:baseTypeId", new StringValue(typeDefinition.getBaseId().value()));
        String policyId = StorageImpl.generateId();
        policyEntry.setValue("cmis:objectId", new StringValue(policyId));
        String userId = this.getCurrentUser();
        policyEntry.setValue("cmis:createdBy", new StringValue(userId));
        policyEntry.setValue("cmis:lastModifiedBy", new StringValue(userId));
        Calendar cal = Calendar.getInstance();
        policyEntry.setValue("cmis:creationDate", new DateValue(cal));
        policyEntry.setValue("cmis:lastModificationDate", new DateValue(cal));
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            policyEntry.setProperty(property);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                policyEntry.addPolicy(policy);
            }
        }
        if (acl != null && acl.size() > 0) {
            CmisUtils.addAclToPermissionMap(policyEntry.getPermissions(), acl);
        }
        this.parents.put(policyId, EMPTY_PARENTS);
        this.entries.put(policyId, policyEntry);
        PolicyDataImpl policy = new PolicyDataImpl(policyEntry, typeDefinition, this);
        if (this.indexListener != null) {
            this.indexListener.created(policy);
        }
        return policy;
    }

    public RelationshipData createRelationship(ObjectData source, ObjectData target, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, StorageException {
        String name = null;
        Property<?> nameProperty = properties.get("cmis:name");
        if (nameProperty != null && nameProperty.getValues().size() > 0) {
            name = (String)nameProperty.getValues().get(0);
        }
        if (name == null || name.length() == 0) {
            throw new NameConstraintViolationException("Name for new relationship must be provided.");
        }
        for (Entry next : this.entries.values()) {
            String typeId = next.getTypeId();
            try {
                String name1;
                TypeDefinition type = this.getTypeDefinition(typeId, false);
                if (type.getBaseId() != BaseType.RELATIONSHIP || !name.equals(name1 = next.getValue("cmis:name").getStrings()[0])) continue;
                throw new NameConstraintViolationException("Relationship with name " + name + " already exists.");
            }
            catch (TypeNotFoundException e) {
            }
        }
        Entry relationshipEntry = new Entry();
        relationshipEntry.setValue("cmis:objectTypeId", new StringValue(typeDefinition.getId()));
        relationshipEntry.setValue("cmis:baseTypeId", new StringValue(typeDefinition.getBaseId().value()));
        String relationshipId = StorageImpl.generateId();
        relationshipEntry.setValue("cmis:objectId", new StringValue(relationshipId));
        String userId = this.getCurrentUser();
        relationshipEntry.setValue("cmis:createdBy", new StringValue(userId));
        relationshipEntry.setValue("cmis:lastModifiedBy", new StringValue(userId));
        Calendar cal = Calendar.getInstance();
        relationshipEntry.setValue("cmis:creationDate", new DateValue(cal));
        relationshipEntry.setValue("cmis:lastModificationDate", new DateValue(cal));
        relationshipEntry.setValue("cmis:sourceId", new StringValue(source.getObjectId()));
        relationshipEntry.setValue("cmis:targetId", new StringValue(target.getObjectId()));
        for (Property<?> property : properties.values()) {
            PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
            Updatability updatability = definition.getUpdatability();
            if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
            relationshipEntry.setProperty(property);
        }
        if (policies != null && policies.size() > 0) {
            for (PolicyData policy : policies) {
                relationshipEntry.addPolicy(policy);
            }
        }
        if (acl != null && acl.size() > 0) {
            CmisUtils.addAclToPermissionMap(relationshipEntry.getPermissions(), acl);
        }
        this.parents.put(relationshipId, EMPTY_PARENTS);
        this.entries.put(relationshipId, relationshipEntry);
        Set<String> sourceRels = this.relationships.get(source.getObjectId());
        if (sourceRels == null) {
            sourceRels = new CopyOnWriteArraySet<String>();
            this.relationships.put(source.getObjectId(), sourceRels);
        }
        sourceRels.add(relationshipId);
        Set<String> targetRels = this.relationships.get(target.getObjectId());
        if (targetRels == null) {
            targetRels = new CopyOnWriteArraySet<String>();
            this.relationships.put(target.getObjectId(), targetRels);
        }
        targetRels.add(relationshipId);
        RelationshipDataImpl relationship = new RelationshipDataImpl(relationshipEntry, typeDefinition, this);
        if (this.indexListener != null) {
            this.indexListener.created(relationship);
        }
        return relationship;
    }

    public void deleteObject(ObjectData object, boolean deleteAllVersions) throws VersioningException, UpdateConflictException, StorageException {
        String objectId = object.getObjectId();
        ((BaseObjectData)object).delete();
        if (this.indexListener != null) {
            HashSet<String> removed = new HashSet<String>();
            removed.add(objectId);
            this.indexListener.removed(removed);
        }
    }

    public Collection<String> deleteTree(FolderData folder, boolean deleteAllVersions, UnfileObject unfileObject, boolean continueOnFailure) throws UpdateConflictException {
        if (!deleteAllVersions) {
            throw new CmisRuntimeException("Unable delete only specified version.");
        }
        String folderId = folder.getObjectId();
        TreeVisitor visitor = new TreeVisitor();
        folder.accept((ObjectDataVisitor)visitor);
        for (BaseObjectData o : visitor.items) {
            try {
                o.delete();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)("Unable delete object " + o.getObjectId()));
                }
                if (continueOnFailure) continue;
                break;
            }
        }
        try {
            folder = (FolderData)this.getObjectById(folderId);
            visitor = new TreeVisitor();
            folder.accept((ObjectDataVisitor)visitor);
            ArrayList<String> failedToDelete = new ArrayList<String>(visitor.items.size());
            for (BaseObjectData o : visitor.items) {
                failedToDelete.add(o.getObjectId());
            }
            return failedToDelete;
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public Collection<DocumentData> getAllVersions(String versionSeriesId) throws ObjectNotFoundException {
        ArrayList<DocumentData> v = new ArrayList<DocumentData>();
        if (!this.workingCopies.containsKey(versionSeriesId) && !this.versions.containsKey(versionSeriesId)) {
            throw new ObjectNotFoundException("Version series '" + versionSeriesId + "' does not exist.");
        }
        String pwc = this.workingCopies.get(versionSeriesId);
        if (pwc != null) {
            v.add((DocumentData)this.getObjectById(pwc));
        }
        for (String vId : this.versions.get(versionSeriesId)) {
            v.add((DocumentData)this.getObjectById(vId));
        }
        Collections.reverse(v);
        return v;
    }

    public ItemsIterator<ChangeEvent> getChangeLog(String changeLogToken) throws ConstraintException {
        return CmisUtils.emptyItemsIterator();
    }

    public ItemsIterator<DocumentData> getCheckedOutDocuments(FolderData folder, String orderBy) {
        ArrayList<DocumentData> checkedOut = new ArrayList<DocumentData>();
        for (String pwcId : this.workingCopies.values()) {
            DocumentData pwc = null;
            try {
                pwc = (DocumentData)this.getObjectById(pwcId);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn((Object)("Object " + pwcId + " not found."));
                continue;
            }
            if (folder != null) {
                for (FolderData parent : pwc.getParents()) {
                    if (!parent.getObjectId().equals(folder.getObjectId())) continue;
                    checkedOut.add(pwc);
                }
                continue;
            }
            checkedOut.add(pwc);
        }
        return new BaseItemsIterator(checkedOut);
    }

    public String getId() {
        return this.configuration.getId();
    }

    public ObjectData getObjectById(String objectId) throws ObjectNotFoundException {
        Entry entry = this.entries.get(objectId);
        if (entry == null) {
            throw new ObjectNotFoundException("Object '" + objectId + "' does not exist.");
        }
        BaseType baseType = entry.getBaseTypeId();
        String typeId = entry.getTypeId();
        TypeDefinition typeDefinition = null;
        try {
            typeDefinition = this.getTypeDefinition(typeId, true);
        }
        catch (TypeNotFoundException e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
        switch (baseType) {
            case DOCUMENT: {
                return new DocumentDataImpl(entry, typeDefinition, this);
            }
            case FOLDER: {
                return new FolderDataImpl(entry, typeDefinition, this);
            }
            case POLICY: {
                return new PolicyDataImpl(entry, typeDefinition, this);
            }
            case RELATIONSHIP: {
                return new RelationshipDataImpl(entry, typeDefinition, this);
            }
        }
        throw new CmisRuntimeException("Unknown base type. ");
    }

    public ObjectData getObjectByPath(String path) throws ObjectNotFoundException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        String point = ROOT_FOLDER_ID;
        block0: while (tokenizer.hasMoreTokens() && point != null) {
            String segName = tokenizer.nextToken();
            Set<String> childrenIds = this.children.get(point);
            if (childrenIds == null || childrenIds.isEmpty()) {
                point = null;
                continue;
            }
            for (String id : childrenIds) {
                ObjectData seg = this.getObjectById(id);
                String name = seg.getName();
                if ((BaseType.FOLDER == seg.getBaseType() || !tokenizer.hasMoreElements()) && segName.equals(name)) {
                    point = id;
                    continue block0;
                }
                point = null;
            }
        }
        if (point == null) {
            throw new ObjectNotFoundException("Path '" + path + "' not found.");
        }
        return this.getObjectById(point);
    }

    public ItemsIterator<Rendition> getRenditions(ObjectData object) {
        if (this.renditionManager != null) {
            ItemsIterator renditions = this.renditionManager.getRenditions(object);
            return renditions;
        }
        return CmisUtils.emptyItemsIterator();
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public ObjectData moveObject(ObjectData object, FolderData target, FolderData source) throws UpdateConflictException, VersioningException, NameConstraintViolationException, StorageException {
        String name = object.getName();
        ItemsIterator iterator = target.getChildren(null);
        while (iterator.hasNext()) {
            if (!name.equals(((ObjectData)iterator.next()).getName())) continue;
            throw new NameConstraintViolationException("Object with name " + name + " already exists in destination folder.");
        }
        String objectid = object.getObjectId();
        String sourceId = source.getObjectId();
        String targetId = target.getObjectId();
        this.children.get(sourceId).remove(objectid);
        this.children.get(targetId).add(objectid);
        this.parents.get(object.getObjectId()).remove(sourceId);
        this.parents.get(object.getObjectId()).add(targetId);
        try {
            return this.getObjectById(objectid);
        }
        catch (ObjectNotFoundException e) {
            throw new CmisRuntimeException("Unable get object after moving.");
        }
    }

    public ItemsIterator<Result> query(Query query) throws InvalidArgumentException {
        try {
            org.xcmis.search.model.Query qom = this.cmisQueryParser.parseQuery(query.getStatement());
            List rows = this.searchService.execute(qom);
            if (qom.getOrderings().size() == 0) {
                Set selectorsReferencedBy = Visitors.getSelectorsReferencedBy((QueryElement)qom);
                Collections.sort(rows, new DocumentOrderResultSorter(((SelectorName)selectorsReferencedBy.iterator().next()).getName(), this));
            }
            return new QueryResultIterator(rows, qom);
        }
        catch (InvalidQueryException e) {
            throw new InvalidArgumentException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (QueryExecutionException e) {
            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void unfileObject(ObjectData object) {
        String objectId = object.getObjectId();
        Set<String> parentIds = this.parents.get(object.getObjectId());
        for (String id : parentIds) {
            this.children.get(id).remove(objectId);
        }
        parentIds.clear();
        this.unfiled.add(objectId);
        if (this.indexListener != null) {
            this.indexListener.updated(object);
        }
    }

    public Iterator<String> getUnfiledObjectsId() throws StorageException {
        return this.unfiled.iterator();
    }

    public String addType(TypeDefinition type) throws StorageException, CmisRuntimeException {
        TypeDefinition superType;
        if (this.types.get(type.getId()) != null) {
            throw new InvalidArgumentException("Type " + type.getId() + " already exists.");
        }
        if (type.getBaseId() == null) {
            throw new InvalidArgumentException("Base type id must be specified.");
        }
        if (type.getParentId() == null) {
            throw new InvalidArgumentException("Unable add root type. Parent type id must be specified");
        }
        try {
            superType = this.getTypeDefinition(type.getParentId(), true);
        }
        catch (TypeNotFoundException e) {
            throw new InvalidArgumentException("Specified parent type '" + type.getParentId() + "' does not exist.");
        }
        if (type.getPropertyDefinitions() != null) {
            for (PropertyDefinition newDefinition : type.getPropertyDefinitions()) {
                PropertyDefinition definition = superType.getPropertyDefinition(newDefinition.getId());
                if (definition == null) continue;
                throw new InvalidArgumentException("Property " + newDefinition.getId() + " already defined");
            }
        }
        HashMap m = new HashMap();
        for (PropertyDefinition next : superType.getPropertyDefinitions()) {
            m.put(next.getId(), next);
        }
        if (type.getPropertyDefinitions() != null) {
            for (PropertyDefinition next : type.getPropertyDefinitions()) {
                m.put(next.getId(), next);
            }
        }
        this.types.put(type.getId(), type);
        this.typeChildren.get(superType.getId()).add(type.getId());
        this.typeChildren.put(type.getId(), new HashSet());
        PropertyDefinitions.putAll(type.getId(), m);
        return type.getId();
    }

    public ItemsIterator<TypeDefinition> getTypeChildren(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException, CmisRuntimeException {
        ArrayList<TypeDefinition> types = new ArrayList<TypeDefinition>();
        if (typeId == null) {
            for (String t : new String[]{"cmis:document", "cmis:folder", "cmis:policy", "cmis:relationship"}) {
                types.add(this.getTypeDefinition(t, includePropertyDefinitions));
            }
        } else {
            if (this.types.get(typeId) == null) {
                throw new TypeNotFoundException("Type '" + typeId + "' does not exist.");
            }
            for (String t : this.typeChildren.get(typeId)) {
                types.add(this.getTypeDefinition(t, includePropertyDefinitions));
            }
        }
        return new BaseItemsIterator(types);
    }

    public TypeDefinition getTypeDefinition(String typeId, boolean includePropertyDefinition) throws TypeNotFoundException, CmisRuntimeException {
        TypeDefinition type = this.types.get(typeId);
        if (type == null) {
            throw new TypeNotFoundException("Type '" + typeId + "' does not exist.");
        }
        TypeDefinition copy = new TypeDefinition(type.getId(), type.getBaseId(), type.getQueryName(), type.getLocalName(), type.getLocalNamespace(), type.getParentId(), type.getDisplayName(), type.getDescription(), type.isCreatable(), type.isFileable(), type.isQueryable(), type.isFulltextIndexed(), type.isIncludedInSupertypeQuery(), type.isControllablePolicy(), type.isControllableACL(), type.isVersionable(), type.getAllowedSourceTypes(), type.getAllowedTargetTypes(), type.getContentStreamAllowed(), includePropertyDefinition ? PropertyDefinitions.getAll(typeId) : null);
        return copy;
    }

    public Collection<TypeDefinition> getSubTypes(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException {
        ArrayList<TypeDefinition> subTypes = new ArrayList<TypeDefinition>();
        ItemsIterator<TypeDefinition> children = this.getTypeChildren(typeId, includePropertyDefinitions);
        while (children.hasNext()) {
            TypeDefinition type = (TypeDefinition)children.next();
            subTypes.add(type);
            Collection<TypeDefinition> cchildren = this.getSubTypes(type.getId(), includePropertyDefinitions);
            if (cchildren.size() <= 0) continue;
            subTypes.addAll(cchildren);
        }
        return subTypes;
    }

    public void removeType(String typeId) throws TypeNotFoundException, StorageException, ConstraintException {
        TypeDefinition type = this.types.get(typeId);
        if (type == null) {
            throw new TypeNotFoundException("Type '" + typeId + "' does not exist.");
        }
        if (type.getParentId() == null) {
            throw new ConstraintException("Unable remove root type " + typeId);
        }
        if (this.typeChildren.get(typeId).size() > 0) {
            throw new ConstraintException("Unable remove type " + typeId + ". Type has descendant types.");
        }
        Iterator<Entry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            if (!typeId.equals(iterator.next().getTypeId())) continue;
            throw new ConstraintException("Unable remove type definition if at least one object of this type exists.");
        }
        this.types.remove(typeId);
        this.typeChildren.get(type.getParentId()).remove(typeId);
        PropertyDefinitions.removeAll(typeId);
    }

    protected String getCurrentUser() {
        ConversationState state = ConversationState.getCurrent();
        if (state != null) {
            return state.getIdentity().getUserId();
        }
        return this.getRepositoryInfo().getPrincipalAnonymous();
    }

    void validateMaxItemsNumber(ObjectData object) throws StorageException {
        if (this.entries.size() > this.maxItemsNumber) {
            throw new StorageException("Unable add new object in storage. Max number '" + this.maxItemsNumber + "' of items is reached." + " Increase or set storage configuration property 'org.xcmis.inmemory.maxitems'.");
        }
    }

    void validateMemSize(byte[] content) throws StorageException {
        if (content == null || content.length == 0) {
            return;
        }
        long size = 0L;
        for (Entry c : this.entries.values()) {
            ByteArrayValue contentValue = (ByteArrayValue)c.getValue("xcmis:content");
            if (contentValue == null) continue;
            size += (long)contentValue.getBytes().length;
        }
        if (size + (long)content.length > this.maxStorageMemSize) {
            throw new StorageException("Unable add new object in storage. Max allowed memory size '" + this.maxStorageMemSize + "' bytes is reached." + " Increase or set storage configuration property 'org.xcmis.inmemory.maxmem'.");
        }
    }

    private SearchService getInitializedSearchService() {
        CmisSchema schema = new CmisSchema((TypeManager)this);
        CmisSchemaTableResolver tableResolver = new CmisSchemaTableResolver((NameConverter)new ToStringNameConverter(), schema, (TypeManager)this);
        IndexConfiguration indexConfiguration = new IndexConfiguration();
        indexConfiguration.setQueryableIndexStorage("org.xcmis.search.lucene.InMemoryLuceneQueryableIndexStorage");
        indexConfiguration.setRootUuid(this.getRepositoryInfo().getRootFolderId());
        indexConfiguration.setRootParentUuid("");
        indexConfiguration.setDocumentReaderService((DocumentReaderService)new CmisDocumentReaderService());
        InvocationContext invocationContext = new InvocationContext();
        invocationContext.setNameConverter((NameConverter)new ToStringNameConverter());
        invocationContext.setSchema((Schema)schema);
        invocationContext.setPathSplitter((PathSplitter)new SlashSplitter());
        invocationContext.setTableResolver((VirtualTableResolver)tableResolver);
        SearchServiceConfiguration searchConfiguration = new SearchServiceConfiguration();
        searchConfiguration.setIndexConfiguration(indexConfiguration);
        searchConfiguration.setContentReader((ContentReaderInterceptor)new CmisContentReader(this));
        searchConfiguration.setNameConverter((NameConverter)new ToStringNameConverter());
        searchConfiguration.setDefaultInvocationContext(invocationContext);
        searchConfiguration.setTableResolver((VirtualTableResolver)tableResolver);
        searchConfiguration.setPathSplitter((PathSplitter)new SlashSplitter());
        try {
            SearchService searchService = new SearchService(searchConfiguration);
            searchService.start();
            return searchService;
        }
        catch (SearchServiceException e) {
            LOG.error((Object)"Unable to initialize storage. ", (Throwable)e);
            return null;
        }
    }

    private class TreeVisitor
    implements ObjectDataVisitor {
        private Collection<BaseObjectData> items = new LinkedHashSet<BaseObjectData>();

        private TreeVisitor() {
        }

        public void visit(ObjectData object) {
            TypeDefinition type = object.getTypeDefinition();
            if (type.getBaseId() == BaseType.FOLDER) {
                ItemsIterator<ObjectData> children = ((FolderDataImpl)object).getChildren(null);
                while (children.hasNext()) {
                    ((ObjectData)children.next()).accept((ObjectDataVisitor)this);
                }
                this.items.add((BaseObjectData)object);
            } else {
                this.items.add((BaseObjectData)object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryResultIterator
    implements ItemsIterator<Result> {
        private final Iterator<ScoredRow> rows;
        private final Set<SelectorName> selectors;
        private final int size;
        private final org.xcmis.search.model.Query qom;
        private Result next;

        QueryResultIterator(List<ScoredRow> rows, org.xcmis.search.model.Query qom) {
            this.size = rows.size();
            this.rows = rows.iterator();
            this.selectors = Visitors.getSelectorsReferencedBy((QueryElement)qom);
            this.qom = qom;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Result next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Result r = this.next;
            this.fetchNext();
            return r;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int size() {
            return this.size;
        }

        public void skip(int skip) throws NoSuchElementException {
            while (skip-- > 0) {
                this.next();
            }
        }

        protected void fetchNext() {
            this.next = null;
            while (this.next == null && this.rows.hasNext()) {
                ScoredRow row = this.rows.next();
                for (SelectorName selectorName : this.selectors) {
                    String objectId = row.getNodeIdentifer(selectorName.getName());
                    ArrayList<String> properties = null;
                    Score score = null;
                    for (Column column : this.qom.getColumns()) {
                        if (column.isFunction()) {
                            score = new Score(column.getColumnName(), BigDecimal.valueOf(row.getScore()));
                            continue;
                        }
                        if (!selectorName.getName().equals(column.getSelectorName()) || column.getPropertyName() == null) continue;
                        if (properties == null) {
                            properties = new ArrayList<String>();
                        }
                        properties.add(column.getPropertyName());
                    }
                    this.next = new ResultImpl(objectId, properties == null ? null : properties.toArray(new String[properties.size()]), score);
                }
            }
        }
    }

    private class ResultImpl
    implements Result {
        private final String id;
        private final String[] properties;
        private final Score score;

        ResultImpl(String id, String[] properties, Score score) {
            this.id = id;
            this.properties = properties;
            this.score = score;
        }

        public String[] getPropertyNames() {
            return this.properties;
        }

        public String getObjectId() {
            return this.id;
        }

        public Score getScore() {
            return this.score;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DocumentOrderResultSorter
    implements Comparator<ScoredRow> {
        private final String selectorName;
        private final Map<String, ObjectData> itemCache;
        private final Storage storage;

        DocumentOrderResultSorter(String selectorName, Storage storage) {
            this.selectorName = selectorName;
            this.storage = storage;
            this.itemCache = new HashMap<String, ObjectData>();
        }

        @Override
        public int compare(ScoredRow o1, ScoredRow o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            String path1 = this.getPath(o1.getNodeIdentifer(this.selectorName));
            String path2 = this.getPath(o2.getNodeIdentifer(this.selectorName));
            if (path1 == null || path2 == null) {
                return 0;
            }
            return path1.compareTo(path2);
        }

        public String getPath(String identifer) {
            ObjectData obj = this.itemCache.get(identifer);
            if (obj == null) {
                try {
                    obj = this.storage.getObjectById(identifer);
                }
                catch (ObjectNotFoundException e) {
                    return null;
                }
                this.itemCache.put(identifer, obj);
            }
            if (obj.getBaseType() == BaseType.FOLDER && ((FolderData)obj).isRoot()) {
                return obj.getName();
            }
            Collection parents = obj.getParents();
            if (parents.size() == 0) {
                return obj.getName();
            }
            return ((FolderData)parents.iterator().next()).getPath() + "/" + obj.getName();
        }
    }
}

