/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.sp.inmemory.InmemConnection;
import org.xcmis.sp.inmemory.StorageConfiguration;
import org.xcmis.sp.inmemory.StorageImpl;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageProvider;

public class StorageProviderImpl
implements StorageProvider {
    private static final Log LOG = ExoLogger.getLogger(StorageProviderImpl.class);
    private StorageImpl storageImpl = null;
    private StorageConfiguration storageConfig = null;
    private RenditionManager renditionManager;

    public StorageProviderImpl(InitParams initParams, PermissionService permissionService) {
        if (initParams != null) {
            ObjectParameter param = initParams.getObjectParam("configs");
            if (param == null) {
                LOG.error((Object)"Init-params does not contain configuration for any CMIS repository.");
            }
            StorageProviderConfig confs = (StorageProviderConfig)param.getObject();
            this.storageConfig = confs.getStorage();
            this.renditionManager = RenditionManager.getInstance();
            this.storageImpl = new StorageImpl(this.storageConfig, this.renditionManager, permissionService);
        } else {
            LOG.error((Object)"Not found configuration for any storages.");
        }
    }

    public StorageProviderImpl(String repositoryId, String repositoryName, String description, String maxStorageMemSize, String maxItemsNumber) {
        this.storageConfig = new StorageConfiguration(repositoryId, repositoryName, description, maxStorageMemSize, maxItemsNumber);
        this.renditionManager = RenditionManager.getInstance();
        this.storageImpl = new StorageImpl(this.storageConfig, this.renditionManager, new PermissionService());
    }

    public Connection getConnection() {
        if (this.storageImpl == null) {
            throw new InvalidArgumentException("CMIS repository does not exist.");
        }
        return new InmemConnection(this.storageImpl);
    }

    public String getStorageID() {
        return this.storageConfig.getId();
    }

    public void stop() {
    }

    public static class StorageProviderConfig {
        private StorageConfiguration storage;

        public StorageConfiguration getStorage() {
            return this.storage;
        }

        public void setStorage(StorageConfiguration storage) {
            this.storage = storage;
        }
    }
}

