/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.sp.jcr.exo.DocumentDataImpl;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.PolicyDataImpl;
import org.xcmis.sp.jcr.exo.RelationshipDataImpl;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectDataVisitor;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.PropertyFilter;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.impl.BooleanProperty;
import org.xcmis.spi.model.impl.DateTimeProperty;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.IntegerProperty;
import org.xcmis.spi.model.impl.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseObjectData
implements ObjectData {
    private static final Log LOG = ExoLogger.getLogger(BaseObjectData.class);
    protected IndexListener indexListener;
    protected JcrNodeEntry jcrEntry;

    public BaseObjectData(JcrNodeEntry jcrEntry, IndexListener indexListener) {
        this.jcrEntry = jcrEntry;
        this.indexListener = indexListener;
    }

    public void accept(ObjectDataVisitor visitor) {
        visitor.visit((ObjectData)this);
    }

    public void applyPolicy(PolicyData policy) {
        this.jcrEntry.applyPolicy(policy);
        try {
            this.save();
        }
        catch (StorageException se) {
            throw new CmisRuntimeException("Unable apply policy. " + se.getMessage(), (Throwable)se);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((BaseObjectData)obj).getObjectId().equals(this.getObjectId());
    }

    public List<AccessControlEntry> getACL(boolean onlyBasicPermissions) {
        if (!this.getTypeDefinition().isControllableACL()) {
            return Collections.emptyList();
        }
        return this.jcrEntry.getACL();
    }

    public BaseType getBaseType() {
        return this.jcrEntry.getBaseType();
    }

    public String getChangeToken() {
        return this.jcrEntry.getString("cmis:changeToken");
    }

    public String getCreatedBy() {
        return this.jcrEntry.getString("cmis:createdBy");
    }

    public Calendar getCreationDate() {
        return this.jcrEntry.getDate("cmis:creationDate");
    }

    public Calendar getLastModificationDate() {
        return this.jcrEntry.getDate("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return this.jcrEntry.getString("cmis:lastModifiedBy");
    }

    public String getName() {
        return this.jcrEntry.getName();
    }

    public String getObjectId() {
        return this.jcrEntry.getId();
    }

    public Collection<PolicyData> getPolicies() {
        if (!this.getTypeDefinition().isControllablePolicy()) {
            return Collections.emptyList();
        }
        Collection<JcrNodeEntry> policyEntries = this.jcrEntry.getPolicies();
        HashSet<PolicyData> policies = new HashSet<PolicyData>(policyEntries.size());
        for (JcrNodeEntry pe : policyEntries) {
            policies.add(new PolicyDataImpl(pe, this.indexListener));
        }
        return policies;
    }

    public Map<String, Property<?>> getProperties() {
        HashMap properties = new HashMap();
        TypeDefinition type = this.getTypeDefinition();
        for (PropertyDefinition definition : type.getPropertyDefinitions()) {
            properties.put(definition.getId(), this.doGetProperty(definition));
        }
        return properties;
    }

    public Map<String, Property<?>> getProperties(PropertyFilter filter) {
        HashMap properties = new HashMap();
        for (PropertyDefinition definition : this.getTypeDefinition().getPropertyDefinitions()) {
            String queryName = definition.getQueryName();
            if (!filter.accept(queryName)) continue;
            String id = definition.getId();
            properties.put(id, this.doGetProperty(definition));
        }
        return properties;
    }

    public Property<?> getProperty(String id) {
        PropertyDefinition definition = this.getTypeDefinition().getPropertyDefinition(id);
        if (definition == null) {
            return null;
        }
        return this.doGetProperty(definition);
    }

    public ItemsIterator<RelationshipData> getRelationships(RelationshipDirection direction, TypeDefinition type, boolean includeSubRelationshipTypes) {
        try {
            PropertyIterator iter = this.getNode().getReferences();
            return new RelationshipIterator(iter, type, direction, includeSubRelationshipTypes);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get relationships. " + re.getMessage(), (Throwable)re);
        }
    }

    public TypeDefinition getTypeDefinition() {
        return this.jcrEntry.getType();
    }

    public String getTypeId() {
        return this.getTypeDefinition().getId();
    }

    public int hashCode() {
        return this.getObjectId().hashCode();
    }

    public void removePolicy(PolicyData policy) {
        this.jcrEntry.removePolicy(policy);
        try {
            this.save();
        }
        catch (StorageException se) {
            throw new CmisRuntimeException(se.getMessage(), (Throwable)se);
        }
    }

    public void setACL(List<AccessControlEntry> acl) {
        this.jcrEntry.setACL(acl);
        try {
            this.save();
        }
        catch (StorageException se) {
            throw new CmisRuntimeException(se.getMessage(), (Throwable)se);
        }
    }

    public void setProperties(Map<String, Property<?>> properties) throws NameConstraintViolationException, UpdateConflictException, VersioningException, StorageException {
        for (Property<?> property : properties.values()) {
            this.doSetProperty(property);
        }
        this.save();
    }

    public void setProperty(Property<?> property) throws NameConstraintViolationException, UpdateConflictException, VersioningException, StorageException {
        this.doSetProperty(property);
        this.save();
    }

    protected Property<?> doGetProperty(PropertyDefinition<?> definition) {
        if (definition.getId().equals("cmis:objectId")) {
            return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getObjectId());
        }
        if (definition.getId().equals("cmis:objectTypeId")) {
            return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getTypeId());
        }
        if (definition.getId().equals("cmis:baseTypeId")) {
            return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getBaseType().value());
        }
        if (definition.getId().equals("cmis:name")) {
            return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getName());
        }
        if (definition.getId().equals("cmis:creationDate")) {
            return new DateTimeProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getCreationDate());
        }
        if (definition.getId().equals("cmis:path")) {
            return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((FolderData)this).getPath());
        }
        if (definition.getId().equals("cmis:parentId") && this.getBaseType() == BaseType.FOLDER && !((FolderData)this).isRoot()) {
            try {
                return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getParent().getObjectId());
            }
            catch (ConstraintException never) {
                LOG.error((Object)("Unable get parent id. " + never.getMessage()));
            }
        } else if (definition.getId().equals("cmis:contentStreamFileName")) {
            if (((DocumentData)this).hasContent()) {
                return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), this.getName());
            }
        } else if (definition.getId().equals("cmis:contentStreamMimeType")) {
            if (((DocumentData)this).hasContent()) {
                return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentData)this).getContentStreamMimeType());
            }
        } else if (definition.getId().equals("cmis:contentStreamLength")) {
            if (((DocumentData)this).hasContent()) {
                return new IntegerProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), BigInteger.valueOf(((DocumentDataImpl)this).getContentStreamLength()));
            }
        } else {
            if (definition.getId().equals("cmis:versionSeriesId")) {
                return new IdProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentData)this).getVersionSeriesId());
            }
            if (definition.getId().equals("cmis:versionLabel")) {
                return new StringProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), ((DocumentData)this).getVersionLabel());
            }
            if (definition.getId().equals("cmis:isLatestMajorVersion")) {
                return new BooleanProperty(definition.getId(), definition.getQueryName(), definition.getLocalName(), definition.getDisplayName(), Boolean.valueOf(((DocumentData)this).isLatestMajorVersion()));
            }
        }
        return this.jcrEntry.getProperty(definition);
    }

    protected void doSetProperty(Property<?> property) throws NameConstraintViolationException {
        PropertyDefinition definition = this.getTypeDefinition().getPropertyDefinition(property.getId());
        Updatability updatability = definition.getUpdatability();
        if (updatability == Updatability.READWRITE || updatability == Updatability.WHENCHECKEDOUT && this.getBaseType() == BaseType.DOCUMENT && ((DocumentData)this).isPWC()) {
            Iterator i = property.getValues().iterator();
            while (i.hasNext()) {
                Object v = i.next();
                if (v != null) continue;
                i.remove();
            }
            this.jcrEntry.setProperty(property);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Property " + property.getId() + " is not updatable."));
        }
    }

    Node getNode() {
        return this.jcrEntry.getNode();
    }

    JcrNodeEntry getNodeEntry() {
        return this.jcrEntry;
    }

    protected void save() throws StorageException {
        boolean isNew = this.getNode().isNew();
        this.jcrEntry.updateAndSave();
        if (this.indexListener != null) {
            if (isNew) {
                this.indexListener.created(this);
            } else {
                this.indexListener.updated(this);
            }
        }
    }

    protected abstract void delete() throws StorageException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelationshipIterator
    implements ItemsIterator<RelationshipData> {
        private final PropertyIterator iter;
        private final TypeDefinition type;
        private final boolean includeSubRelationshipTypes;
        private final RelationshipDirection direction;
        private RelationshipData next;

        RelationshipIterator(PropertyIterator iter, TypeDefinition type, RelationshipDirection direction, boolean includeSubRelationshipTypes) {
            this.iter = iter;
            this.type = type;
            this.direction = direction;
            this.includeSubRelationshipTypes = includeSubRelationshipTypes;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public RelationshipData next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            RelationshipData n = this.next;
            this.fetchNext();
            return n;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int size() {
            return -1;
        }

        public void skip(int skip) throws NoSuchElementException {
            while (skip-- > 0) {
                this.fetchNext();
                if (this.next != null) continue;
                throw new NoSuchElementException();
            }
        }

        void fetchNext() {
            this.next = null;
            while (this.next == null && this.iter.hasNext()) {
                javax.jcr.Property prop = this.iter.nextProperty();
                try {
                    Node relNode;
                    NodeType nodeType;
                    String propName = prop.getName();
                    if ((this.direction != RelationshipDirection.EITHER || !propName.equals("cmis:sourceId") && !propName.equals("cmis:targetId")) && (this.direction != RelationshipDirection.SOURCE || !propName.equals("cmis:sourceId")) && (this.direction != RelationshipDirection.TARGET || !propName.equals("cmis:targetId")) || !(nodeType = (relNode = prop.getParent()).getPrimaryNodeType()).getName().equals(this.type.getLocalName()) && (!this.includeSubRelationshipTypes || !nodeType.isNodeType(this.type.getLocalName()))) continue;
                    this.next = new RelationshipDataImpl(new JcrNodeEntry(relNode), BaseObjectData.this.indexListener);
                }
                catch (RepositoryException re) {
                    LOG.error((Object)re.getMessage());
                }
            }
        }
    }
}

