/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.sp.jcr.exo.BaseObjectData;
import org.xcmis.sp.jcr.exo.DocumentDataImpl;
import org.xcmis.sp.jcr.exo.JcrFile;
import org.xcmis.sp.jcr.exo.JcrFolder;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.JcrTypeHelper;
import org.xcmis.sp.jcr.exo.NotSupportedNodeTypeException;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FolderDataImpl
extends BaseObjectData
implements FolderData {
    static final Set<String> SKIP_CHILD_ITEMS = new HashSet<String>();
    private static final Log LOG;
    protected final RenditionManager renditionManager;

    public FolderDataImpl(JcrNodeEntry jcrEntry, IndexListener indexListener, RenditionManager renditionManager) {
        super(jcrEntry, indexListener);
        this.renditionManager = renditionManager;
    }

    public void addObject(ObjectData object) throws ConstraintException {
        try {
            Node node = this.getNode();
            Session session = node.getSession();
            Node add = ((BaseObjectData)object).getNode();
            if (add.getParent().isNodeType("xcmis:unfiledObject")) {
                Node unfiled = add.getParent();
                String dataName = add.getName();
                String destPath = node.getPath();
                destPath = destPath + (destPath.equals("/") ? dataName : "/" + dataName);
                session.move(add.getPath(), destPath);
                unfiled.remove();
            } else {
                Node link = node.addNode(object.getName(), "nt:linkedFile");
                link.setProperty("jcr:content", add);
            }
            session.save();
            if (this.indexListener != null) {
                this.indexListener.updated(object);
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable add object to current folder. " + re.getMessage(), (Throwable)re);
        }
    }

    public ItemsIterator<ObjectData> getChildren(String orderBy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get children " + this.getObjectId() + ", name " + this.getName()));
        }
        try {
            return new FolderChildrenIterator(this.getNode().getNodes(), this.indexListener);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get children for folder " + this.getObjectId() + ". " + re.getMessage(), (Throwable)re);
        }
    }

    public ContentStream getContentStream(String streamId) {
        return null;
    }

    public FolderData getParent() throws ConstraintException {
        try {
            Node node = this.getNode();
            if (node.getDepth() == 0) {
                throw new ConstraintException("Unable get parent of root folder.");
            }
            Node parent = node.getParent();
            return new FolderDataImpl(new JcrNodeEntry(parent), this.indexListener, this.renditionManager);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object parent. " + re.getMessage(), (Throwable)re);
        }
    }

    public Collection<FolderData> getParents() {
        try {
            Node node = this.getNode();
            if (node.getDepth() == 0) {
                return Collections.emptyList();
            }
            Node parent = node.getParent();
            ArrayList<FolderData> parents = new ArrayList<FolderData>(1);
            parents.add(new FolderDataImpl(new JcrNodeEntry(parent), this.indexListener, this.renditionManager));
            return parents;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object parent. " + re.getMessage(), (Throwable)re);
        }
    }

    public String getPath() {
        return this.jcrEntry.getPath();
    }

    public boolean hasChildren() {
        try {
            return this.getNode().hasNodes();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unexpected error. " + re.getMessage(), (Throwable)re);
        }
    }

    public boolean isAllowedChildType(String typeId) {
        return true;
    }

    public boolean isRoot() {
        try {
            return this.getNode().getDepth() == 0;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unexpected error. " + re.getMessage(), (Throwable)re);
        }
    }

    public void removeObject(ObjectData object) {
        try {
            Node remove = ((BaseObjectData)object).getNode();
            Node node = this.getNode();
            Session session = node.getSession();
            if (((ExtendedNode)remove.getParent()).getIdentifier().equals(((ExtendedNode)node).getIdentifier())) {
                String destPath;
                Node link = null;
                PropertyIterator references = remove.getReferences();
                while (references.hasNext()) {
                    Node next = references.nextProperty().getParent();
                    if (!next.isNodeType("nt:linkedFile")) continue;
                    link = next;
                    break;
                }
                if (link != null) {
                    destPath = link.getPath();
                    link.remove();
                } else {
                    Node unfiledStore = (Node)session.getItem("/xcmis:system/xcmis:unfileStore");
                    Node unfiled = unfiledStore.addNode(object.getObjectId(), "xcmis:unfiledObject");
                    destPath = unfiled.getPath() + "/" + remove.getName();
                }
                session.move(remove.getPath(), destPath);
            } else {
                PropertyIterator references = remove.getReferences();
                while (references.hasNext()) {
                    Node next = references.nextProperty().getParent();
                    if (!next.isNodeType("nt:linkedFile") || !((ExtendedNode)next.getParent()).getIdentifier().equals(((ExtendedNode)node).getIdentifier())) continue;
                    next.remove();
                    break;
                }
            }
            session.save();
            if (this.indexListener != null) {
                this.indexListener.updated(object);
            }
        }
        catch (PathNotFoundException pe) {
            throw new InvalidArgumentException("Object " + object.getObjectId() + " is not filed in current folder.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable remove object from current folder. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    protected void delete() throws StorageException {
        if (this.isRoot()) {
            throw new StorageException("Root folder can't be deleted.");
        }
        String objectId = this.getObjectId();
        try {
            Node node = this.getNode();
            Session session = node.getSession();
            node.remove();
            session.save();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable delete object. " + re.getMessage(), (Throwable)re);
        }
        if (this.indexListener != null) {
            HashSet<String> removed = new HashSet<String>();
            removed.add(objectId);
            this.indexListener.removed(removed);
        }
    }

    static {
        SKIP_CHILD_ITEMS.add("jcr:system");
        SKIP_CHILD_ITEMS.add("xcmis:system");
        LOG = ExoLogger.getLogger(FolderDataImpl.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderChildrenIterator
    implements ItemsIterator<ObjectData> {
        protected final NodeIterator iter;
        protected ObjectData next;
        private final IndexListener indexListener;

        FolderChildrenIterator(NodeIterator iter, IndexListener indexListener) {
            this.iter = iter;
            this.indexListener = indexListener;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public ObjectData next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ObjectData n = this.next;
            this.fetchNext();
            return n;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int size() {
            return -1;
        }

        public void skip(int skip) throws NoSuchElementException {
            while (skip-- > 0) {
                this.fetchNext();
                if (this.next != null) continue;
                throw new NoSuchElementException();
            }
        }

        protected void fetchNext() {
            this.next = null;
            while (this.next == null && this.iter.hasNext()) {
                Node node = this.iter.nextNode();
                try {
                    NodeIterator child;
                    if (SKIP_CHILD_ITEMS.contains(node.getName()) || !((NodeImpl)node).isValid()) continue;
                    if (node.isNodeType("nt:linkedFile")) {
                        node = node.getProperty("jcr:content").getNode();
                    } else if (node.isNodeType("xcmis:unfiledObject") && (child = node.getNodes()).hasNext()) {
                        node = child.nextNode();
                    }
                    TypeDefinition type = JcrTypeHelper.getTypeDefinition(node.getPrimaryNodeType(), true);
                    if (type.getBaseId() == BaseType.DOCUMENT) {
                        if (!node.isNodeType("cmis:document")) {
                            this.next = new JcrFile(new JcrNodeEntry(node, type), this.indexListener, FolderDataImpl.this.renditionManager);
                            continue;
                        }
                        this.next = new DocumentDataImpl(new JcrNodeEntry(node, type), this.indexListener, FolderDataImpl.this.renditionManager);
                        continue;
                    }
                    if (type.getBaseId() != BaseType.FOLDER) continue;
                    if (!node.isNodeType("cmis:folder")) {
                        this.next = new JcrFolder(new JcrNodeEntry(node, type), this.indexListener, FolderDataImpl.this.renditionManager);
                        continue;
                    }
                    this.next = new FolderDataImpl(new JcrNodeEntry(node, type), this.indexListener, FolderDataImpl.this.renditionManager);
                }
                catch (NotSupportedNodeTypeException iae) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.warn((Object)("Unable get next object . " + iae.getMessage()));
                }
                catch (RepositoryException re) {
                    LOG.warn((Object)("Unexpected error. Failed get next CMIS object. " + re.getMessage()));
                }
            }
        }
    }
}

