/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.xcmis.sp.jcr.exo.NotSupportedNodeTypeException;
import org.xcmis.sp.jcr.exo.PropertyDefinitions;
import org.xcmis.sp.jcr.exo.StorageImpl;
import org.xcmis.spi.CmisConstants;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.Choice;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.DateResolution;
import org.xcmis.spi.model.Precision;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JcrTypeHelper {
    static final Set<Pattern> ignoredProperties = new HashSet<Pattern>();

    JcrTypeHelper() {
    }

    public static TypeDefinition getTypeDefinition(NodeType nt, boolean includePropertyDefinition) throws NotSupportedNodeTypeException {
        if (nt.isNodeType("nt:file")) {
            return JcrTypeHelper.getDocumentDefinition(nt, includePropertyDefinition);
        }
        if (nt.isNodeType("nt:folder") || nt.isNodeType("nt:unstructured")) {
            return JcrTypeHelper.getFolderDefinition(nt, includePropertyDefinition);
        }
        if (nt.isNodeType("cmis:relationship")) {
            return JcrTypeHelper.getRelationshipDefinition(nt, includePropertyDefinition);
        }
        if (nt.isNodeType("cmis:policy")) {
            return JcrTypeHelper.getPolicyDefinition(nt, includePropertyDefinition);
        }
        throw new NotSupportedNodeTypeException("Type " + nt.getName() + " is unsupported for xCMIS.");
    }

    public static String getCmisTypeId(String ntName) {
        if (ntName.equals("nt:file")) {
            return BaseType.DOCUMENT.value();
        }
        if (ntName.equals("nt:folder") || ntName.equals("nt:unstructured")) {
            return BaseType.FOLDER.value();
        }
        return ntName;
    }

    public static String getNodeTypeName(String typeId) {
        if (typeId.equals(BaseType.DOCUMENT.value())) {
            return "nt:file";
        }
        if (typeId.equals(BaseType.FOLDER.value())) {
            return "nt:folder";
        }
        return typeId;
    }

    protected static TypeDefinition getDocumentDefinition(NodeType nt, boolean includePropertyDefinition) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = JcrTypeHelper.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.DOCUMENT);
        def.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        def.setControllableACL(true);
        def.setControllablePolicy(true);
        def.setCreatable(true);
        def.setDescription("Cmis Document Type");
        def.setDisplayName(typeId);
        def.setFileable(true);
        def.setFulltextIndexed(true);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(true);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals(BaseType.DOCUMENT.value())) {
            def.setParentId(null);
        } else {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("nt:file")) continue;
                def.setParentId(JcrTypeHelper.getCmisTypeId(superType.getName()));
                break;
            }
        }
        def.setQueryable(true);
        def.setQueryName(typeId);
        def.setVersionable(true);
        if (includePropertyDefinition) {
            JcrTypeHelper.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    protected static TypeDefinition getFolderDefinition(NodeType nt, boolean includePropertyDefinition) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = JcrTypeHelper.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.FOLDER);
        def.setControllableACL(true);
        def.setControllablePolicy(true);
        def.setCreatable(true);
        def.setDescription("Cmis Folder Type");
        def.setDisplayName(typeId);
        def.setFileable(true);
        def.setFulltextIndexed(false);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(true);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals(BaseType.FOLDER.value())) {
            def.setParentId(null);
        } else {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("nt:folder")) continue;
                def.setParentId(JcrTypeHelper.getCmisTypeId(superType.getName()));
                break;
            }
        }
        def.setQueryable(true);
        def.setQueryName(typeId);
        if (includePropertyDefinition) {
            JcrTypeHelper.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    protected static TypeDefinition getPolicyDefinition(NodeType nt, boolean includePropertyDefinition) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = JcrTypeHelper.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.POLICY);
        def.setControllableACL(true);
        def.setControllablePolicy(true);
        def.setCreatable(true);
        def.setDescription("Cmis Policy Type");
        def.setDisplayName(typeId);
        def.setFileable(false);
        def.setFulltextIndexed(false);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(false);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals(BaseType.POLICY.value())) {
            def.setParentId(null);
        } else {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("cmis:policy")) continue;
                def.setParentId(JcrTypeHelper.getCmisTypeId(superType.getName()));
                break;
            }
        }
        def.setQueryable(false);
        def.setQueryName(typeId);
        if (includePropertyDefinition) {
            JcrTypeHelper.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    protected static TypeDefinition getRelationshipDefinition(NodeType nt, boolean includePropertyDefinition) {
        TypeDefinition def = new TypeDefinition();
        String localTypeName = nt.getName();
        String typeId = JcrTypeHelper.getCmisTypeId(localTypeName);
        def.setBaseId(BaseType.RELATIONSHIP);
        def.setControllableACL(false);
        def.setControllablePolicy(false);
        def.setCreatable(true);
        def.setDescription("Cmis Relationship Type");
        def.setDisplayName(typeId);
        def.setFileable(false);
        def.setFulltextIndexed(false);
        def.setId(typeId);
        def.setIncludedInSupertypeQuery(false);
        def.setLocalName(localTypeName);
        def.setLocalNamespace("");
        if (typeId.equals(BaseType.RELATIONSHIP.value())) {
            def.setParentId(null);
        } else {
            NodeType[] superTypes;
            for (NodeType superType : superTypes = nt.getDeclaredSupertypes()) {
                if (!superType.isNodeType("cmis:relationship")) continue;
                def.setParentId(JcrTypeHelper.getCmisTypeId(superType.getName()));
                break;
            }
        }
        def.setQueryable(false);
        def.setQueryName(typeId);
        if (includePropertyDefinition) {
            JcrTypeHelper.addPropertyDefinitions(def, nt);
        }
        return def;
    }

    private static void addPropertyDefinitions(TypeDefinition typeDefinition, NodeType nt) {
        HashMap pd = new HashMap(PropertyDefinitions.getAll(typeDefinition.getBaseId().value()));
        Set<String> knownIds = PropertyDefinitions.getPropertyIds(typeDefinition.getBaseId().value());
        PropertyDefinition[] propertyDefinitions = nt.getPropertyDefinitions();
        HashMap<String, PropertyDefinition> propertyDefinitionsMap = new HashMap<String, PropertyDefinition>(propertyDefinitions.length);
        for (int i = 0; i < propertyDefinitions.length; ++i) {
            propertyDefinitionsMap.put(propertyDefinitions[i].getName(), propertyDefinitions[i]);
        }
        for (PropertyDefinition jcrPropertyDef : propertyDefinitions) {
            String pdName = jcrPropertyDef.getName();
            boolean shouldBeIgnored = false;
            for (Pattern ignoredPattern : ignoredProperties) {
                if (!ignoredPattern.matcher(pdName).matches()) continue;
                shouldBeIgnored = true;
                break;
            }
            if (shouldBeIgnored || knownIds.contains(pdName)) continue;
            org.xcmis.spi.model.PropertyDefinition cmisPropDef = null;
            switch (jcrPropertyDef.getRequiredType()) {
                case 6: {
                    org.xcmis.spi.model.PropertyDefinition boolDef;
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    cmisPropDef = boolDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.BOOLEAN, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? JcrTypeHelper.createDefaultValues(jcrDefaultValues, new Boolean[jcrDefaultValues.length]) : null);
                    break;
                }
                case 5: {
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    org.xcmis.spi.model.PropertyDefinition dateDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.DATETIME, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? JcrTypeHelper.createDefaultValues(jcrDefaultValues, new Calendar[jcrDefaultValues.length]) : null);
                    dateDef.setDateResolution(DateResolution.TIME);
                    cmisPropDef = dateDef;
                    break;
                }
                case 4: {
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    org.xcmis.spi.model.PropertyDefinition decimalDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.DECIMAL, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? JcrTypeHelper.createDefaultValues(jcrDefaultValues, new BigDecimal[jcrDefaultValues.length]) : null);
                    decimalDef.setDecimalPrecision(Precision.Bit32);
                    decimalDef.setMaxDecimal(CmisConstants.MAX_DECIMAL_VALUE);
                    decimalDef.setMinDecimal(CmisConstants.MIN_DECIMAL_VALUE);
                    cmisPropDef = decimalDef;
                    break;
                }
                case 3: {
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    org.xcmis.spi.model.PropertyDefinition integerDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, PropertyType.INTEGER, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, null, jcrPropertyDef.isMultiple(), null, jcrDefaultValues != null ? JcrTypeHelper.createDefaultValues(jcrDefaultValues, new BigInteger[jcrDefaultValues.length]) : null);
                    integerDef.setMaxInteger(CmisConstants.MAX_INTEGER_VALUE);
                    integerDef.setMinInteger(CmisConstants.MIN_INTEGER_VALUE);
                    cmisPropDef = integerDef;
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 9: {
                    String[] vc;
                    Value[] jcrDefaultValues = jcrPropertyDef.getDefaultValues();
                    ArrayList<Choice> choices = null;
                    Boolean openChoice = null;
                    if (1 == jcrPropertyDef.getRequiredType() && (vc = jcrPropertyDef.getValueConstraints()) != null && vc.length > 0) {
                        openChoice = false;
                        choices = new ArrayList<Choice>();
                        if (jcrPropertyDef.isMultiple()) {
                            ArrayList<String> vals = new ArrayList<String>();
                            for (String chVal : vc) {
                                if (".*".equals(chVal)) {
                                    openChoice = true;
                                    continue;
                                }
                                vals.add(chVal);
                            }
                            choices.add(new Choice((Object[])vals.toArray(new String[vals.size()]), ""));
                        } else {
                            for (String chVal : vc) {
                                if (".*".equals(chVal)) {
                                    openChoice = true;
                                    continue;
                                }
                                choices.add(new Choice((Object[])new String[]{chVal}, ""));
                            }
                        }
                    }
                    PropertyType propertyType = PropertyType.STRING;
                    if (propertyDefinitionsMap.containsKey(pdName + "_xcmis_property_type")) {
                        try {
                            Value[] defaultValues = ((PropertyDefinition)propertyDefinitionsMap.get(pdName + "_xcmis_property_type")).getDefaultValues();
                            if (defaultValues.length > 0) {
                                propertyType = PropertyType.fromValue((String)defaultValues[0].getString());
                            }
                        }
                        catch (IllegalStateException e) {
                            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (RepositoryException e) {
                            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    org.xcmis.spi.model.PropertyDefinition stringDef = new org.xcmis.spi.model.PropertyDefinition(pdName, pdName, pdName, null, pdName, null, propertyType, jcrPropertyDef.isProtected() ? Updatability.READONLY : Updatability.READWRITE, false, jcrPropertyDef.isMandatory(), true, true, openChoice, jcrPropertyDef.isMultiple(), choices, jcrDefaultValues != null ? JcrTypeHelper.createDefaultValues(jcrDefaultValues, new String[jcrDefaultValues.length]) : null);
                    stringDef.setMaxLength(65536);
                    cmisPropDef = stringDef;
                    break;
                }
            }
            pd.put(cmisPropDef.getId(), cmisPropDef);
        }
        typeDefinition.setPropertyDefinitions(pd);
    }

    private static <T> T[] createDefaultValues(Value[] jcrValues, T[] a) {
        try {
            Object[] tmp = new Object[jcrValues.length];
            block9: for (int i = 0; i < jcrValues.length; ++i) {
                Value v = jcrValues[i];
                switch (v.getType()) {
                    case 6: {
                        tmp[i] = v.getBoolean();
                        continue block9;
                    }
                    case 5: {
                        tmp[i] = v.getDate();
                        continue block9;
                    }
                    case 4: {
                        tmp[i] = BigDecimal.valueOf(v.getDouble());
                        continue block9;
                    }
                    case 3: {
                        tmp[i] = BigInteger.valueOf(v.getLong());
                        continue block9;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: 
                    case 9: {
                        tmp[i] = v.getString();
                    }
                }
            }
            System.arraycopy(tmp, 0, a, 0, tmp.length);
            return a;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get property definition. " + re.getMessage(), (Throwable)re);
        }
    }

    static {
        ignoredProperties.add(Pattern.compile("jcr:created"));
        ignoredProperties.add(Pattern.compile("jcr:mixinTypes"));
        ignoredProperties.add(Pattern.compile("jcr:uuid"));
        ignoredProperties.add(Pattern.compile("jcr:primaryType"));
        ignoredProperties.add(Pattern.compile("exo:owner"));
        ignoredProperties.add(Pattern.compile("\\*"));
        ignoredProperties.add(StorageImpl.XCMIS_PROPERTY_TYPE_PATTERN);
    }
}

