/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Session;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.SearchService;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.parser.CmisQueryParser;
import org.xcmis.search.parser.QueryParser;
import org.xcmis.search.query.QueryExecutionException;
import org.xcmis.search.result.ScoredRow;
import org.xcmis.sp.jcr.exo.StorageConfiguration;
import org.xcmis.sp.jcr.exo.StorageImpl;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.Storage;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.query.Result;
import org.xcmis.spi.query.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableStorage
extends StorageImpl {
    private final SearchService searchService;
    private final QueryParser cmisQueryParser;

    public QueryableStorage(Session session, StorageConfiguration configuration, SearchService searchService, PermissionService permissionService) {
        super(session, configuration, permissionService);
        this.searchService = searchService;
        this.cmisQueryParser = new CmisQueryParser();
    }

    public QueryableStorage(Session session, StorageConfiguration configuration, RenditionManager renditionManager, SearchService searchService, PermissionService permissionService) {
        super(session, configuration, renditionManager, permissionService);
        this.searchService = searchService;
        this.cmisQueryParser = new CmisQueryParser();
    }

    @Override
    public ItemsIterator<Result> query(org.xcmis.spi.query.Query query) throws InvalidArgumentException {
        try {
            Query qom = this.cmisQueryParser.parseQuery(query.getStatement());
            List rows = this.searchService.execute(qom);
            if (qom.getOrderings().size() == 0) {
                Set selectorsReferencedBy = Visitors.getSelectorsReferencedBy((QueryElement)qom);
                Collections.sort(rows, new DocumentOrderResultSorter(((SelectorName)selectorsReferencedBy.iterator().next()).getName(), this));
            }
            return new QueryResultIterator(rows, qom);
        }
        catch (InvalidQueryException e) {
            throw new InvalidArgumentException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (QueryExecutionException e) {
            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocumentOrderResultSorter
    implements Comparator<ScoredRow> {
        private final String selectorName;
        private final Map<String, ObjectData> itemCache;
        private final Storage storage;

        public DocumentOrderResultSorter(String selectorName, Storage storage) {
            this.selectorName = selectorName;
            this.storage = storage;
            this.itemCache = new HashMap<String, ObjectData>();
        }

        @Override
        public int compare(ScoredRow o1, ScoredRow o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            String path1 = this.getPath(o1.getNodeIdentifer(this.selectorName));
            String path2 = this.getPath(o2.getNodeIdentifer(this.selectorName));
            if (path1 == null || path2 == null) {
                return 0;
            }
            return path1.compareTo(path2);
        }

        public String getPath(String identifer) {
            ObjectData obj = this.itemCache.get(identifer);
            if (obj == null) {
                try {
                    obj = this.storage.getObjectById(identifer);
                }
                catch (ObjectNotFoundException e) {
                    return null;
                }
                this.itemCache.put(identifer, obj);
            }
            if (obj.getBaseType() == BaseType.FOLDER && ((FolderData)obj).isRoot()) {
                return obj.getName();
            }
            Collection parents = obj.getParents();
            if (parents.size() == 0) {
                return obj.getName();
            }
            return ((FolderData)parents.iterator().next()).getPath() + "/" + obj.getName();
        }
    }

    public static class ResultImpl
    implements Result {
        private final String id;
        private final String[] properties;
        private final Score score;

        public ResultImpl(String id, String[] properties, Score score) {
            this.id = id;
            this.properties = properties;
            this.score = score;
        }

        public String[] getPropertyNames() {
            return this.properties;
        }

        public String getObjectId() {
            return this.id;
        }

        public Score getScore() {
            return this.score;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryResultIterator
    implements ItemsIterator<Result> {
        private final Iterator<ScoredRow> rows;
        private final Set<SelectorName> selectors;
        private final int size;
        private final Query qom;
        private Result next;

        public QueryResultIterator(List<ScoredRow> rows, Query qom) {
            this.size = rows.size();
            this.rows = rows.iterator();
            this.selectors = Visitors.getSelectorsReferencedBy((QueryElement)qom);
            this.qom = qom;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Result next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Result r = this.next;
            this.fetchNext();
            return r;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int size() {
            return this.size;
        }

        public void skip(int skip) throws NoSuchElementException {
            while (skip-- > 0) {
                this.next();
            }
        }

        protected void fetchNext() {
            this.next = null;
            while (this.next == null && this.rows.hasNext()) {
                ScoredRow row = this.rows.next();
                for (SelectorName selectorName : this.selectors) {
                    String objectId = row.getNodeIdentifer(selectorName.getName());
                    ArrayList<String> properties = null;
                    Score score = null;
                    for (Column column : this.qom.getColumns()) {
                        if (column.isFunction()) {
                            score = new Score(column.getColumnName(), BigDecimal.valueOf(row.getScore()));
                            continue;
                        }
                        if (!selectorName.getName().equals(column.getSelectorName()) || column.getPropertyName() == null) continue;
                        if (properties == null) {
                            properties = new ArrayList<String>();
                        }
                        properties.add(column.getPropertyName());
                    }
                    this.next = new ResultImpl(objectId, properties == null ? null : properties.toArray(new String[properties.size()]), score);
                }
            }
        }
    }
}

