/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.xcmis.sp.jcr.exo.BaseObjectData;
import org.xcmis.sp.jcr.exo.DocumentDataImpl;
import org.xcmis.sp.jcr.exo.DocumentVersion;
import org.xcmis.sp.jcr.exo.FolderDataImpl;
import org.xcmis.sp.jcr.exo.JcrFile;
import org.xcmis.sp.jcr.exo.JcrFolder;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.JcrTypeHelper;
import org.xcmis.sp.jcr.exo.PWC;
import org.xcmis.sp.jcr.exo.PolicyDataImpl;
import org.xcmis.sp.jcr.exo.RelationshipDataImpl;
import org.xcmis.sp.jcr.exo.StorageConfiguration;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.Storage;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.ACLCapability;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AccessControlPropagation;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.CapabilityChanges;
import org.xcmis.spi.model.CapabilityContentStreamUpdatable;
import org.xcmis.spi.model.CapabilityJoin;
import org.xcmis.spi.model.CapabilityQuery;
import org.xcmis.spi.model.CapabilityRendition;
import org.xcmis.spi.model.ChangeEvent;
import org.xcmis.spi.model.Permission;
import org.xcmis.spi.model.PermissionMapping;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.RepositoryCapabilities;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.SupportedPermissions;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.query.Query;
import org.xcmis.spi.query.Result;
import org.xcmis.spi.utils.CmisUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageImpl
implements Storage {
    private static final Log LOG = ExoLogger.getLogger(StorageImpl.class);
    public static final String XCMIS_SYSTEM_PATH = "/xcmis:system";
    public static final String XCMIS_UNFILED = "xcmis:unfileStore";
    public static final String XCMIS_WORKING_COPIES = "xcmis:workingCopyStore";
    public static final String XCMIS_RELATIONSHIPS = "xcmis:relationshipStore";
    public static final String XCMIS_POLICIES = "xcmis:policiesStore";
    public static final String XCMIS_PROPERTY_TYPE = "_xcmis_property_type";
    public static final Pattern XCMIS_PROPERTY_TYPE_PATTERN = Pattern.compile(".*_xcmis_property_type");
    static String LATEST_LABEL = "latest";
    static String PWC_LABEL = "pwc";
    protected final Session session;
    private final StorageConfiguration configuration;
    private RenditionManager renditionManager;
    private IndexListener indexListener;
    private RepositoryInfo repositoryInfo;
    private PermissionService permissionService;

    public StorageImpl(Session session, IndexListener indexListener, StorageConfiguration configuration, RenditionManager renditionManager, PermissionService permissionService) {
        this.session = session;
        this.indexListener = indexListener;
        this.configuration = configuration;
        this.renditionManager = renditionManager;
        this.permissionService = permissionService;
    }

    public StorageImpl(Session session, StorageConfiguration configuration, PermissionService permissionService) {
        this.session = session;
        this.configuration = configuration;
        this.permissionService = permissionService;
    }

    public StorageImpl(Session session, StorageConfiguration configuration, RenditionManager renditionManager, PermissionService permissionService) {
        this.session = session;
        this.configuration = configuration;
        this.renditionManager = renditionManager;
        this.permissionService = permissionService;
    }

    public String addType(TypeDefinition type) throws ConstraintException, StorageException {
        try {
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
            NodeTypeValue nodeTypeValue = new NodeTypeValue();
            String parentId = type.getParentId();
            if (parentId == null) {
                String msg = "Unable add root type. Parent Type Id must be specified.";
                throw new InvalidArgumentException(msg);
            }
            TypeDefinition parentType = null;
            try {
                parentType = this.getTypeDefinition(parentId, false);
            }
            catch (TypeNotFoundException tnfe) {
                throw new ConstraintException("Parent type " + parentId + " does not exist");
            }
            ArrayList<String> declaredSupertypeNames = new ArrayList<String>();
            declaredSupertypeNames.add(JcrTypeHelper.getNodeTypeName(parentId));
            if (parentType.getBaseId() == BaseType.DOCUMENT) {
                declaredSupertypeNames.add("cmis:document");
            } else if (parentType.getBaseId() == BaseType.FOLDER) {
                declaredSupertypeNames.add("cmis:folder");
            }
            nodeTypeValue.setDeclaredSupertypeNames(declaredSupertypeNames);
            nodeTypeValue.setMixin(false);
            nodeTypeValue.setName(type.getId());
            nodeTypeValue.setOrderableChild(false);
            nodeTypeValue.setPrimaryItemName("");
            ArrayList<PropertyDefinitionValue> jcrPropDefintions = null;
            if (type.getPropertyDefinitions() != null && type.getPropertyDefinitions().size() > 0) {
                jcrPropDefintions = new ArrayList<PropertyDefinitionValue>();
                for (PropertyDefinition propDef : type.getPropertyDefinitions()) {
                    if (propDef.getPropertyType() == null) {
                        String msg = "Property Type required.";
                        throw new InvalidArgumentException(msg);
                    }
                    if (XCMIS_PROPERTY_TYPE_PATTERN.matcher(propDef.getId()).matches()) {
                        throw new InvalidArgumentException("Unacceptable property definition name " + propDef.getId() + " type " + type.getId());
                    }
                    PropertyDefinitionValue jcrPropDef = new PropertyDefinitionValue();
                    ArrayList<String> defaultValues = null;
                    switch (propDef.getPropertyType()) {
                        case BOOLEAN: {
                            jcrPropDef.setRequiredType(6);
                            Boolean[] booleans = (Boolean[])propDef.getDefaultValue();
                            if (booleans == null || booleans.length <= 0) break;
                            defaultValues = new ArrayList<String>(booleans.length);
                            for (Boolean v : booleans) {
                                defaultValues.add(v.toString());
                            }
                            break;
                        }
                        case DATETIME: {
                            jcrPropDef.setRequiredType(5);
                            Calendar[] dates = (Calendar[])propDef.getDefaultValue();
                            if (dates == null || dates.length <= 0) break;
                            defaultValues = new ArrayList(dates.length);
                            for (Calendar v : dates) {
                                defaultValues.add(this.createJcrDate(v));
                            }
                            break;
                        }
                        case DECIMAL: {
                            jcrPropDef.setRequiredType(4);
                            BigDecimal[] decimals = (BigDecimal[])propDef.getDefaultValue();
                            if (decimals == null || decimals.length <= 0) break;
                            defaultValues = new ArrayList(decimals.length);
                            for (BigDecimal v : decimals) {
                                defaultValues.add(Double.toString(v.doubleValue()));
                            }
                            break;
                        }
                        case INTEGER: {
                            jcrPropDef.setRequiredType(3);
                            BigInteger[] ints = (BigInteger[])propDef.getDefaultValue();
                            if (ints == null || ints.length <= 0) break;
                            defaultValues = new ArrayList(ints.length);
                            for (BigInteger v : ints) {
                                defaultValues.add(Long.toString(v.longValue()));
                            }
                            break;
                        }
                        case ID: 
                        case HTML: 
                        case URI: 
                        case STRING: {
                            jcrPropDef.setRequiredType(1);
                            String[] str = (String[])propDef.getDefaultValue();
                            if (str == null || str.length <= 0) break;
                            defaultValues = new ArrayList(str.length);
                            for (String v : str) {
                                defaultValues.add(v);
                            }
                            break;
                        }
                    }
                    if (defaultValues != null) {
                        jcrPropDef.setDefaultValueStrings(defaultValues);
                        jcrPropDef.setAutoCreate(true);
                    } else {
                        jcrPropDef.setAutoCreate(false);
                    }
                    jcrPropDef.setMandatory(propDef.isRequired());
                    jcrPropDef.setMultiple(propDef.isMultivalued());
                    jcrPropDef.setName(propDef.getId());
                    jcrPropDef.setOnVersion(1);
                    jcrPropDef.setReadOnly(false);
                    jcrPropDefintions.add(jcrPropDef);
                    if (propDef.getPropertyType() != PropertyType.ID && propDef.getPropertyType() != PropertyType.HTML && propDef.getPropertyType() != PropertyType.URI) continue;
                    ArrayList<String> actualTypeStorage = new ArrayList<String>();
                    actualTypeStorage.add(propDef.getPropertyType().toString());
                    jcrPropDefintions.add(new PropertyDefinitionValue(propDef.getId() + XCMIS_PROPERTY_TYPE, false, false, 1, false, actualTypeStorage, false, 0, new ArrayList()));
                }
                nodeTypeValue.setDeclaredPropertyDefinitionValues(jcrPropDefintions);
            }
            NodeType nodeType = nodeTypeManager.registerNodeType(nodeTypeValue, 2);
            return nodeType.getName();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable add new CMIS type. " + re.getMessage(), (Throwable)re);
        }
    }

    public AllowableActions calculateAllowableActions(ObjectData object) {
        ConversationState state = ConversationState.getCurrent();
        AllowableActions actions = this.permissionService.calculateAllowableActions(object, state != null ? state.getIdentity() : null, this.getRepositoryInfo());
        return actions;
    }

    public DocumentData copyDocument(DocumentData source, FolderData parent, Map<String, org.xcmis.spi.model.Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, StorageException {
        try {
            String name = null;
            org.xcmis.spi.model.Property<?> nameProperty = properties.get("cmis:name");
            if (nameProperty != null && nameProperty.getValues().size() > 0) {
                name = (String)nameProperty.getValues().get(0);
            }
            if (name == null || name.length() == 0) {
                name = source.getName();
            }
            TypeDefinition typeDefinition = source.getTypeDefinition();
            Node copyNode = null;
            if (parent != null) {
                Node parentNode = ((FolderDataImpl)parent).getNode();
                if (parentNode.hasNode(name)) {
                    throw new NameConstraintViolationException("Object with name " + name + " already exists in specified folder.");
                }
                copyNode = parentNode.addNode(name, typeDefinition.getLocalName());
            } else {
                Node unfiledStore = (Node)this.session.getItem("/xcmis:system/xcmis:unfileStore");
                Node unfiled = unfiledStore.addNode(IdGenerator.generate(), "xcmis:unfiledObject");
                copyNode = unfiled.addNode(name, typeDefinition.getLocalName());
            }
            if (!copyNode.isNodeType("cmis:document")) {
                copyNode.addMixin("cmis:document");
            }
            if (copyNode.canAddMixin("mix:versionable")) {
                copyNode.addMixin("mix:versionable");
            }
            JcrNodeEntry copyNodeEntry = new JcrNodeEntry(copyNode, typeDefinition);
            copyNodeEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
            copyNodeEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
            String userId = this.session.getUserID();
            copyNodeEntry.setValue("cmis:createdBy", userId);
            Calendar cal = Calendar.getInstance();
            copyNodeEntry.setValue("cmis:creationDate", cal);
            copyNodeEntry.setValue("cmis:versionSeriesId", copyNode.getProperty("jcr:versionHistory").getString());
            copyNodeEntry.setValue("cmis:isLatestVersion", true);
            copyNodeEntry.setValue("cmis:isMajorVersion", versioningState == VersioningState.MAJOR);
            copyNodeEntry.setValue("cmis:versionLabel", LATEST_LABEL);
            for (org.xcmis.spi.model.Property<?> property : properties.values()) {
                PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
                Updatability updatability = definition.getUpdatability();
                if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
                copyNodeEntry.setProperty(property);
            }
            try {
                copyNodeEntry.setContentStream(source.getContentStream());
            }
            catch (IOException ioe) {
                throw new CmisRuntimeException("Unable copy content for new document. " + ioe.getMessage(), (Throwable)ioe);
            }
            if (acl != null && acl.size() > 0) {
                copyNodeEntry.setACL(acl);
            }
            if (policies != null && policies.size() > 0) {
                for (PolicyData policy : policies) {
                    copyNodeEntry.applyPolicy(policy);
                }
            }
            DocumentDataImpl copy = new DocumentDataImpl(copyNodeEntry, this.indexListener, this.renditionManager);
            copy.save();
            return copy;
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable to create a copy of document. " + re.getMessage(), (Throwable)re);
        }
    }

    public DocumentData createDocument(FolderData parent, TypeDefinition typeDefinition, Map<String, org.xcmis.spi.model.Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, IOException, StorageException {
        try {
            String name = null;
            org.xcmis.spi.model.Property<?> nameProperty = properties.get("cmis:name");
            if (nameProperty != null && nameProperty.getValues().size() > 0) {
                name = (String)nameProperty.getValues().get(0);
            }
            if (name == null && content != null) {
                name = content.getFileName();
            }
            if (name == null || name.length() == 0) {
                throw new NameConstraintViolationException("Name for new document must be provided.");
            }
            Node documentNode = null;
            if (parent != null) {
                Node parentNode = ((FolderDataImpl)parent).getNode();
                if (parentNode.hasNode(name)) {
                    throw new NameConstraintViolationException("Object with name " + name + " already exists in specified folder.");
                }
                documentNode = parentNode.addNode(name, typeDefinition.getLocalName());
            } else {
                Node unfiledStore = (Node)this.session.getItem("/xcmis:system/xcmis:unfileStore");
                Node unfiled = unfiledStore.addNode(IdGenerator.generate(), "xcmis:unfiledObject");
                documentNode = unfiled.addNode(name, typeDefinition.getLocalName());
            }
            if (!documentNode.isNodeType("cmis:document")) {
                documentNode.addMixin("cmis:document");
            }
            if (documentNode.canAddMixin("mix:versionable")) {
                documentNode.addMixin("mix:versionable");
            }
            JcrNodeEntry documentNodeEntry = new JcrNodeEntry(documentNode, typeDefinition);
            documentNodeEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
            documentNodeEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
            String userId = this.session.getUserID();
            documentNodeEntry.setValue("cmis:createdBy", userId);
            Calendar cal = Calendar.getInstance();
            documentNodeEntry.setValue("cmis:creationDate", cal);
            documentNodeEntry.setValue("cmis:versionSeriesId", documentNode.getProperty("jcr:versionHistory").getString());
            documentNodeEntry.setValue("cmis:isLatestVersion", true);
            documentNodeEntry.setValue("cmis:isMajorVersion", versioningState == VersioningState.MAJOR);
            documentNodeEntry.setValue("cmis:versionLabel", LATEST_LABEL);
            for (org.xcmis.spi.model.Property<?> property : properties.values()) {
                PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
                Updatability updatability = definition.getUpdatability();
                if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
                documentNodeEntry.setProperty(property);
            }
            documentNodeEntry.setContentStream(content);
            if (acl != null && acl.size() > 0) {
                documentNodeEntry.setACL(acl);
            }
            if (policies != null && policies.size() > 0) {
                for (PolicyData policy : policies) {
                    documentNodeEntry.applyPolicy(policy);
                }
            }
            DocumentDataImpl document = new DocumentDataImpl(documentNodeEntry, this.indexListener, this.renditionManager);
            document.save();
            return document;
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable to create Document. " + re.getMessage(), (Throwable)re);
        }
    }

    public FolderData createFolder(FolderData parent, TypeDefinition typeDefinition, Map<String, org.xcmis.spi.model.Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        if (parent == null) {
            throw new ConstraintException("Parent folder must be provided.");
        }
        try {
            String name = null;
            org.xcmis.spi.model.Property<?> nameProperty = properties.get("cmis:name");
            if (nameProperty != null && nameProperty.getValues().size() > 0) {
                name = (String)nameProperty.getValues().get(0);
            }
            if (name == null || name.length() == 0) {
                throw new NameConstraintViolationException("Name for new folder must be provided.");
            }
            Node parentNode = ((FolderDataImpl)parent).getNode();
            if (parentNode.hasNode(name)) {
                throw new NameConstraintViolationException("Object with name " + name + " already exists in specified folder.");
            }
            Node folderNode = parentNode.addNode(name, typeDefinition.getLocalName());
            if (!folderNode.isNodeType("cmis:folder")) {
                folderNode.addMixin("cmis:folder");
            }
            JcrNodeEntry folderNodeEntry = new JcrNodeEntry(folderNode, typeDefinition);
            folderNodeEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
            folderNodeEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
            String userId = this.session.getUserID();
            folderNodeEntry.setValue("cmis:createdBy", userId);
            Calendar cal = Calendar.getInstance();
            folderNodeEntry.setValue("cmis:creationDate", cal);
            for (org.xcmis.spi.model.Property<?> property : properties.values()) {
                PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
                Updatability updatability = definition.getUpdatability();
                if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
                folderNodeEntry.setProperty(property);
            }
            if (acl != null && acl.size() > 0) {
                folderNodeEntry.setACL(acl);
            }
            if (policies != null && policies.size() > 0) {
                for (PolicyData policy : policies) {
                    folderNodeEntry.applyPolicy(policy);
                }
            }
            FolderDataImpl folder = new FolderDataImpl(folderNodeEntry, this.indexListener, this.renditionManager);
            folder.save();
            return folder;
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable to create Folder. " + re.getMessage(), (Throwable)re);
        }
    }

    public PolicyData createPolicy(FolderData parent, TypeDefinition typeDefinition, Map<String, org.xcmis.spi.model.Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        try {
            String name = null;
            org.xcmis.spi.model.Property<?> nameProperty = properties.get("cmis:name");
            if (nameProperty != null && nameProperty.getValues().size() > 0) {
                name = (String)nameProperty.getValues().get(0);
            }
            if (name == null || name.length() == 0) {
                throw new NameConstraintViolationException("Name for new policy must be provided.");
            }
            Node policiesStore = (Node)this.session.getItem("/xcmis:system/xcmis:policiesStore");
            if (policiesStore.hasNode(name)) {
                throw new NameConstraintViolationException("Policy with name " + name + " already exists.");
            }
            Node policyNode = policiesStore.addNode(name, typeDefinition.getLocalName());
            JcrNodeEntry policyNodeEntry = new JcrNodeEntry(policyNode, typeDefinition);
            policyNodeEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
            policyNodeEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
            String userId = this.session.getUserID();
            policyNodeEntry.setValue("cmis:createdBy", userId);
            Calendar cal = Calendar.getInstance();
            policyNodeEntry.setValue("cmis:creationDate", cal);
            for (org.xcmis.spi.model.Property<?> property : properties.values()) {
                PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
                Updatability updatability = definition.getUpdatability();
                if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
                policyNodeEntry.setProperty(property);
            }
            if (acl != null && acl.size() > 0) {
                policyNodeEntry.setACL(acl);
            }
            if (policies != null && policies.size() > 0) {
                for (PolicyData policy : policies) {
                    policyNodeEntry.applyPolicy(policy);
                }
            }
            PolicyDataImpl policy = new PolicyDataImpl(policyNodeEntry, this.indexListener);
            policy.save();
            return policy;
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable create new policy. " + re.getMessage(), (Throwable)re);
        }
    }

    public RelationshipData createRelationship(ObjectData source, ObjectData target, TypeDefinition typeDefinition, Map<String, org.xcmis.spi.model.Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, StorageException {
        try {
            String name = null;
            org.xcmis.spi.model.Property<?> nameProperty = properties.get("cmis:name");
            if (nameProperty != null) {
                name = (String)nameProperty.getValues().get(0);
            }
            if (name == null || name.length() == 0) {
                throw new NameConstraintViolationException("Name for new relationship must be provided.");
            }
            Node relationships = (Node)this.session.getItem("/xcmis:system/xcmis:relationshipStore");
            if (relationships.hasNode(name)) {
                throw new NameConstraintViolationException("Relationship with name " + name + " already exists.");
            }
            Node relationshipNode = relationships.addNode(name, typeDefinition.getLocalName());
            relationshipNode.setProperty("cmis:sourceId", ((BaseObjectData)source).getNode());
            relationshipNode.setProperty("cmis:targetId", ((BaseObjectData)target).getNode());
            JcrNodeEntry relationshipNodeEntry = new JcrNodeEntry(relationshipNode);
            relationshipNodeEntry.setValue("cmis:objectTypeId", typeDefinition.getId());
            relationshipNodeEntry.setValue("cmis:baseTypeId", typeDefinition.getBaseId().value());
            String userId = this.session.getUserID();
            relationshipNodeEntry.setValue("cmis:createdBy", userId);
            Calendar cal = Calendar.getInstance();
            relationshipNodeEntry.setValue("cmis:creationDate", cal);
            for (org.xcmis.spi.model.Property<?> property : properties.values()) {
                PropertyDefinition definition = typeDefinition.getPropertyDefinition(property.getId());
                Updatability updatability = definition.getUpdatability();
                if (updatability != Updatability.READWRITE && updatability != Updatability.ONCREATE) continue;
                relationshipNodeEntry.setProperty(property);
            }
            if (acl != null && acl.size() > 0) {
                relationshipNodeEntry.setACL(acl);
            }
            if (policies != null && policies.size() > 0) {
                for (PolicyData policy : policies) {
                    relationshipNodeEntry.applyPolicy(policy);
                }
            }
            RelationshipDataImpl relationship = new RelationshipDataImpl(relationshipNodeEntry, this.indexListener);
            relationship.save();
            return relationship;
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable create new policy. " + re.getMessage(), (Throwable)re);
        }
    }

    public void deleteObject(ObjectData object, boolean deleteAllVersions) throws UpdateConflictException, VersioningException, StorageException {
        if (object.getBaseType() == BaseType.DOCUMENT && object.getTypeDefinition().isVersionable() && !deleteAllVersions) {
            throw new VersioningException("Unable delete only specified version.");
        }
        ((BaseObjectData)object).delete();
    }

    public Collection<String> deleteTree(FolderData folder, boolean deleteAllVersions, UnfileObject unfileObject, boolean continueOnFailure) throws UpdateConflictException {
        if (!deleteAllVersions) {
            throw new CmisRuntimeException("Unable delete only specified version.");
        }
        ArrayList<String> failedToDelete = new ArrayList<String>();
        try {
            DeleteTreeVisitor v = new DeleteTreeVisitor(folder.getPath(), unfileObject);
            v.visit(((FolderDataImpl)folder).getNode());
            DeleteTreeLog deleteLog = v.getDeleteLog();
            for (String string : deleteLog.getDeleteLinks()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Delete link " + string));
                }
                ((ExtendedSession)this.session).getNodeByIdentifier(string).remove();
            }
            for (Map.Entry entry : deleteLog.getMoveMapping().entrySet()) {
                String scrPath = (String)entry.getKey();
                String destPath = (String)entry.getValue();
                if (destPath == null) {
                    ExtendedNode unfiledStore = (ExtendedNode)this.session.getItem("/xcmis:system/xcmis:unfileStore");
                    ExtendedNode src = (ExtendedNode)this.session.getItem(scrPath);
                    Node unfiled = unfiledStore.addNode(src.getIdentifier(), "xcmis:unfiledObject");
                    destPath = unfiled.getPath() + "/" + src.getName();
                } else {
                    this.session.getItem(destPath).remove();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Move " + scrPath + " to " + destPath));
                }
                this.session.move(scrPath, destPath);
            }
            for (String string : deleteLog.getDeleteObjects()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Delete: " + string));
                }
                ((ExtendedSession)this.session).getNodeByIdentifier(string).remove();
            }
            this.session.save();
            if (this.indexListener != null) {
                this.indexListener.removed(new HashSet<String>(deleteLog.getDeleteObjects()));
            }
        }
        catch (RepositoryException re) {
            try {
                TreeVisitor v = new TreeVisitor();
                v.visit(((FolderDataImpl)folder).getNode());
                failedToDelete.addAll(v.getDescendantsIds());
            }
            catch (RepositoryException e) {
                throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
            }
        }
        return failedToDelete;
    }

    public Collection<DocumentData> getAllVersions(String versionSeriesId) throws ObjectNotFoundException {
        try {
            Node node = ((ExtendedSession)this.session).getNodeByIdentifier(versionSeriesId);
            VersionHistory vh = (VersionHistory)node;
            LinkedList<DocumentData> versions = new LinkedList<DocumentData>();
            VersionIterator iterator = vh.getAllVersions();
            iterator.next();
            while (iterator.hasNext()) {
                Version v = iterator.nextVersion();
                versions.addFirst(this.getDocumentVersion(v.getNode("jcr:frozenNode")));
            }
            DocumentData latest = (DocumentData)this.getObjectById(vh.getVersionableUUID());
            versions.addFirst(latest);
            String pwcId = latest.getVersionSeriesCheckedOutId();
            if (pwcId != null) {
                PWC pwc = (PWC)this.getObjectById(pwcId);
                versions.addFirst(pwc);
            }
            return versions;
        }
        catch (ItemNotFoundException infe) {
            throw new ObjectNotFoundException("Version series '" + versionSeriesId + "' does not exist.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get version series " + versionSeriesId + ". " + re.getMessage(), (Throwable)re);
        }
    }

    public ItemsIterator<ChangeEvent> getChangeLog(String changeLogToken) throws ConstraintException {
        throw new NotSupportedException("Changes log feature is not supported.");
    }

    public ItemsIterator<DocumentData> getCheckedOutDocuments(FolderData folder, String orderBy) {
        try {
            Node workingCopies = (Node)this.session.getItem("/xcmis:system/xcmis:workingCopyStore");
            ArrayList<PWC> checkedOut = new ArrayList<PWC>();
            NodeIterator iterator = workingCopies.getNodes();
            block2: while (iterator.hasNext()) {
                Node wc = iterator.nextNode();
                if (!wc.hasNodes()) {
                    LOG.error((Object)"PWC node not fould.");
                    continue;
                }
                Node node = wc.getNodes().nextNode();
                PWC pwc = this.getPWC(node);
                if (folder != null) {
                    for (FolderData parent : pwc.getParents()) {
                        if (!parent.getObjectId().equals(folder.getObjectId())) continue;
                        checkedOut.add(pwc);
                        continue block2;
                    }
                    continue;
                }
                checkedOut.add(pwc);
            }
            return new BaseItemsIterator(checkedOut);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get checked-out documents. " + re.getMessage(), (Throwable)re);
        }
    }

    public String getId() {
        return this.configuration.getId();
    }

    public IndexListener getIndexListener() {
        return this.indexListener;
    }

    public ObjectData getObjectById(String objectId) throws ObjectNotFoundException {
        if (objectId == null) {
            throw new CmisRuntimeException("Object id may not be null.");
        }
        try {
            Node node = ((ExtendedSession)this.session).getNodeByIdentifier(objectId);
            if (node.isNodeType("nt:frozenNode")) {
                return this.getDocumentVersion(node);
            }
            return this.getObject(node);
        }
        catch (ItemNotFoundException nfe) {
            throw new ObjectNotFoundException("Object '" + objectId + "' does not exist.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    public ObjectData getObjectByPath(String path) throws ObjectNotFoundException {
        if (path == null) {
            throw new CmisRuntimeException("Object path may not be null.");
        }
        try {
            Item item = this.session.getItem(path);
            if (!item.isNode()) {
                throw new ObjectNotFoundException("Object '" + path + "' does not exist.");
            }
            Node node = (Node)item;
            return this.getObject(node);
        }
        catch (ItemNotFoundException nfe) {
            throw new ObjectNotFoundException("Object  '" + path + "' does not exist.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException(re.getMessage(), (Throwable)re);
        }
    }

    public ItemsIterator<Rendition> getRenditions(ObjectData object) {
        try {
            RenditionIterator it = new RenditionIterator(((BaseObjectData)object).getNode().getNodes());
            if (it.hasNext()) {
                return it;
            }
            if (this.renditionManager != null) {
                return this.renditionManager.getRenditions(object);
            }
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get renditions for object " + object.getObjectId() + ". Unexpected error " + re.getMessage(), (Throwable)re);
        }
        return CmisUtils.emptyItemsIterator();
    }

    public RepositoryInfo getRepositoryInfo() {
        if (this.repositoryInfo == null) {
            PermissionMapping permissionMapping = new PermissionMapping();
            permissionMapping.put("canGetDescendents.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetFolderTree.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetChildren.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetObjectParents.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetFolderParent.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateDocument.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateRelationship.Source", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCreateRelationship.Target", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetProperties.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetContentStream.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRenditions.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canUpdateProperties.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canMoveObject.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canMoveObject.Target", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canMoveObject.Source", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canDelete.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canDeleteTree.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canSetContentStream.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canDeleteContentStream.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canAddToFolder.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canAddToFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRemoveObjectFromFolder.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRemoveObjectFromFolder.Folder", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canCheckout.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canCancelCheckout.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canCheckin.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canGetAllVersions.Document", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetObjectRelationships.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canAddPolicy.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canAddPolicy.Policy", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canRemovePolicy.Object", Arrays.asList(Permission.BasicPermissions.CMIS_WRITE.value()));
            permissionMapping.put("canRemovePolicy.Policy", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetAppliedPolicies.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canGetACL.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value()));
            permissionMapping.put("canApplyACL.Object", Arrays.asList(Permission.BasicPermissions.CMIS_READ.value(), Permission.BasicPermissions.CMIS_WRITE.value()));
            ArrayList<Permission> permissions = new ArrayList<Permission>(4);
            for (Permission.BasicPermissions b : Permission.BasicPermissions.values()) {
                permissions.add(new Permission(b.value(), ""));
            }
            this.repositoryInfo = new RepositoryInfo(this.getId(), this.getId(), "00exo0jcr0root0uuid0000000000000", "1.0", new RepositoryCapabilities(CapabilityACL.MANAGE, CapabilityChanges.NONE, CapabilityContentStreamUpdatable.ANYTIME, CapabilityJoin.NONE, CapabilityQuery.BOTHCOMBINED, CapabilityRendition.READ, false, true, true, true, false, true, true, false), new ACLCapability(permissionMapping, Collections.unmodifiableList(permissions), AccessControlPropagation.OBJECTONLY, SupportedPermissions.BASIC), SystemIdentity.ANONIM, SystemIdentity.ANY, null, null, true, null, "eXo", "xCMIS (eXo JCR SP)", "1.0", null);
        }
        return this.repositoryInfo;
    }

    public ItemsIterator<TypeDefinition> getTypeChildren(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException {
        try {
            ArrayList<TypeDefinition> types = new ArrayList<TypeDefinition>();
            if (typeId == null) {
                for (String t : new String[]{"cmis:document", "cmis:folder", "cmis:policy", "cmis:relationship"}) {
                    types.add(this.getTypeDefinition(t, includePropertyDefinitions));
                }
            } else {
                String nodeTypeName = JcrTypeHelper.getNodeTypeName(typeId);
                NodeTypeIterator iter = this.session.getWorkspace().getNodeTypeManager().getPrimaryNodeTypes();
                while (iter.hasNext()) {
                    NodeType nt = iter.nextNodeType();
                    if (!nt.isNodeType(nodeTypeName) || this.getTypeLevelHierarchy(nt, nodeTypeName) != 1) continue;
                    types.add(JcrTypeHelper.getTypeDefinition(nt, includePropertyDefinitions));
                }
            }
            return new BaseItemsIterator(types);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get type children. " + re.getMessage(), (Throwable)re);
        }
    }

    public TypeDefinition getTypeDefinition(String typeId, boolean includePropertyDefinition) throws TypeNotFoundException, CmisRuntimeException {
        try {
            return JcrTypeHelper.getTypeDefinition(this.getNodeType(JcrTypeHelper.getNodeTypeName(typeId)), includePropertyDefinition);
        }
        catch (NoSuchNodeTypeException e) {
            throw new TypeNotFoundException("Type with id " + typeId + " not found in repository.");
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object type " + typeId, (Throwable)re);
        }
    }

    public Iterator<String> getUnfiledObjectsId() throws StorageException {
        try {
            Node unfiledStore = (Node)this.session.getItem("/xcmis:system/xcmis:unfileStore");
            final NodeIterator nodes = unfiledStore.getNodes();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return nodes.hasNext();
                }

                @Override
                public String next() {
                    if (nodes.hasNext()) {
                        Node nextNode = nodes.nextNode();
                        try {
                            NodeIterator etries = nextNode.getNodes();
                            if (etries.hasNext()) {
                                return ((ExtendedNode)etries.nextNode()).getIdentifier();
                            }
                            throw new CmisRuntimeException("Unfiled node object not found for wrapper object " + nextNode.getPath());
                        }
                        catch (RepositoryException e) {
                            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (RepositoryException e) {
            throw new StorageException("Unable unfiled objects. " + e.getMessage(), (Throwable)e);
        }
    }

    public ObjectData moveObject(ObjectData object, FolderData target, FolderData source) throws UpdateConflictException, VersioningException, NameConstraintViolationException, StorageException {
        try {
            String objectPath = ((BaseObjectData)object).getNode().getPath();
            String destinationPath = ((BaseObjectData)target).getNode().getPath();
            destinationPath = destinationPath + (destinationPath.equals("/") ? object.getName() : "/" + object.getName());
            this.session.getWorkspace().move(objectPath, destinationPath);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Object moved in " + destinationPath));
            }
            return this.getObject((Node)this.session.getItem(destinationPath));
        }
        catch (ItemExistsException ie) {
            throw new NameConstraintViolationException("Object with the same name already exists in target folder.");
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable to move object. " + re.getMessage(), (Throwable)re);
        }
    }

    public ItemsIterator<Result> query(Query query) throws InvalidArgumentException {
        throw new UnsupportedOperationException();
    }

    public void removeType(String typeId) throws TypeNotFoundException, StorageException, CmisRuntimeException {
        this.getTypeDefinition(typeId, false);
        try {
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
            nodeTypeManager.unregisterNodeType(typeId);
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable remove CMIS type " + typeId + ". " + re.getMessage(), (Throwable)re);
        }
    }

    public void setIndexListener(IndexListener indexListener) {
        this.indexListener = indexListener;
    }

    public void unfileObject(ObjectData object) {
        ((DocumentDataImpl)object).unfile();
    }

    private DocumentVersion getDocumentVersion(Node node) throws RepositoryException {
        TypeDefinition typeDefinition = JcrTypeHelper.getTypeDefinition(this.getNodeType(node.getProperty("jcr:frozenPrimaryType").getString()), true);
        return new DocumentVersion(new JcrNodeEntry(node, typeDefinition), this.indexListener, this.renditionManager);
    }

    private PWC getPWC(Node node) throws RepositoryException {
        return new PWC(new JcrNodeEntry(node), this.indexListener, this.renditionManager);
    }

    private ObjectData getObject(Node node) throws RepositoryException {
        TypeDefinition typeDefinition = JcrTypeHelper.getTypeDefinition(node.getPrimaryNodeType(), true);
        if (typeDefinition.getBaseId() == BaseType.DOCUMENT) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            if (node.getParent().isNodeType("xcmis:workingCopy")) {
                return this.getPWC(node);
            }
            if (!node.isNodeType("cmis:document")) {
                return new JcrFile(new JcrNodeEntry(node, typeDefinition), this.indexListener, this.renditionManager);
            }
            return new DocumentDataImpl(new JcrNodeEntry(node, typeDefinition), this.indexListener, this.renditionManager);
        }
        if (typeDefinition.getBaseId() == BaseType.FOLDER) {
            if (!node.isNodeType("cmis:folder")) {
                return new JcrFolder(new JcrNodeEntry(node, typeDefinition), this.indexListener, this.renditionManager);
            }
            return new FolderDataImpl(new JcrNodeEntry(node, typeDefinition), this.indexListener, this.renditionManager);
        }
        if (typeDefinition.getBaseId() == BaseType.POLICY) {
            return new PolicyDataImpl(new JcrNodeEntry(node, typeDefinition), this.indexListener);
        }
        if (typeDefinition.getBaseId() == BaseType.RELATIONSHIP) {
            return new RelationshipDataImpl(new JcrNodeEntry(node, typeDefinition), this.indexListener);
        }
        throw new CmisRuntimeException("Unknown base type. ");
    }

    private int getTypeLevelHierarchy(NodeType discovered, String match) {
        int level = 0;
        for (NodeType sup : discovered.getSupertypes()) {
            if (!sup.isNodeType(match)) continue;
            ++level;
        }
        return level;
    }

    protected String createJcrDate(Calendar c) {
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
    }

    protected NodeType getNodeType(String name) throws NoSuchNodeTypeException, RepositoryException {
        NodeType nt = this.session.getWorkspace().getNodeTypeManager().getNodeType(name);
        return nt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RenditionIterator
    implements ItemsIterator<Rendition> {
        protected final NodeIterator iter;
        protected Rendition next;

        public RenditionIterator(NodeIterator iter) {
            this.iter = iter;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Rendition next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Rendition n = this.next;
            this.fetchNext();
            return n;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public int size() {
            return -1;
        }

        public void skip(int skip) throws NoSuchElementException {
            while (skip-- > 0) {
                this.fetchNext();
                if (this.next != null) continue;
                throw new NoSuchElementException();
            }
        }

        protected void fetchNext() {
            this.next = null;
            if (this.iter == null) {
                return;
            }
            while (this.next == null && this.iter.hasNext()) {
                Node node = this.iter.nextNode();
                try {
                    if (!node.isNodeType("xcmis:rendition")) continue;
                    Rendition rendition = new Rendition();
                    rendition.setStreamId(node.getName());
                    rendition.setKind(node.getProperty("xcmis:renditionKind").getString());
                    rendition.setMimeType(node.getProperty("xcmis:renditionMimeType").getString());
                    rendition.setLength(node.getProperty("xcmis:renditionStream").getLength());
                    try {
                        rendition.setHeight(Long.valueOf(node.getProperty("xcmis:renditionHeight").getLong()).intValue());
                        rendition.setWidth(Long.valueOf(node.getProperty("xcmis:renditionWidth").getLong()).intValue());
                    }
                    catch (PathNotFoundException pnfe) {
                        // empty catch block
                    }
                    this.next = rendition;
                }
                catch (RepositoryException re) {
                    String msg = "Unexpected error. Failed get next CMIS object. " + re.getMessage();
                    LOG.warn((Object)msg);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeVisitor
    implements ItemVisitor {
        private final Collection<String> allChildrenObjects = new HashSet<String>();

        TreeVisitor() {
        }

        public Collection<String> getDescendantsIds() {
            return this.allChildrenObjects;
        }

        public void visit(Property property) throws RepositoryException {
        }

        public void visit(Node node) throws RepositoryException {
            NodeType nt = node.getPrimaryNodeType();
            String uuid = ((ExtendedNode)node).getIdentifier();
            if (nt.isNodeType("nt:folder") || nt.isNodeType("nt:unstructured")) {
                NodeIterator children = node.getNodes();
                while (children.hasNext()) {
                    children.nextNode().accept((ItemVisitor)this);
                }
                this.allChildrenObjects.add(uuid);
            } else if (!this.allChildrenObjects.contains(uuid)) {
                this.allChildrenObjects.add(uuid);
            }
        }
    }

    private class DeleteTreeVisitor
    implements ItemVisitor {
        private final String treePath;
        private final UnfileObject unfileObject;
        private final DeleteTreeLog deleteLog;

        DeleteTreeVisitor(String path, UnfileObject unfileObject) {
            this.deleteLog = new DeleteTreeLog();
            this.treePath = path;
            this.unfileObject = unfileObject != null ? unfileObject : UnfileObject.DELETE;
        }

        public DeleteTreeLog getDeleteLog() {
            return this.deleteLog;
        }

        public void visit(Property property) throws RepositoryException {
        }

        public void visit(Node node) throws RepositoryException {
            NodeType nt = node.getPrimaryNodeType();
            String uuid = ((ExtendedNode)node).getIdentifier();
            String path = node.getPath();
            if (nt.isNodeType("nt:folder") || nt.isNodeType("nt:unstructured")) {
                NodeIterator children = node.getNodes();
                while (children.hasNext()) {
                    children.nextNode().accept((ItemVisitor)this);
                }
                this.deleteLog.getDeleteObjects().add(uuid);
            }
            if (nt.isNodeType("nt:linkedFile")) {
                if (!this.deleteLog.getDeleteLinks().contains(uuid)) {
                    this.deleteLog.getDeleteLinks().add(uuid);
                }
                if (this.unfileObject == UnfileObject.DELETE) {
                    Node doc = node.getProperty("jcr:content").getNode();
                    String targetPath = doc.getPath();
                    String targetUuid = ((ExtendedNode)doc).getIdentifier();
                    if (!targetPath.startsWith(this.treePath) && !this.deleteLog.getDeleteObjects().contains(targetUuid)) {
                        this.deleteLog.getDeleteObjects().add(targetUuid);
                    }
                }
            } else if (nt.isNodeType("nt:file")) {
                String moveTo = null;
                PropertyIterator references = node.getReferences();
                while (references.hasNext()) {
                    Node link = references.nextProperty().getParent();
                    String linkPath = link.getPath();
                    String linkUuid = ((ExtendedNode)link).getIdentifier();
                    if ((this.unfileObject == UnfileObject.DELETE || linkPath.startsWith(this.treePath)) && !this.deleteLog.getDeleteLinks().contains(linkUuid)) {
                        this.deleteLog.getDeleteLinks().add(linkUuid);
                        continue;
                    }
                    if (linkPath.startsWith(this.treePath) || moveTo != null) continue;
                    moveTo = linkPath;
                }
                if (this.unfileObject == UnfileObject.UNFILE || this.unfileObject == UnfileObject.DELETESINGLEFILED && moveTo != null) {
                    this.deleteLog.getMoveMapping().put(path, moveTo);
                } else if (!this.deleteLog.getDeleteObjects().contains(uuid)) {
                    this.deleteLog.getDeleteObjects().add(uuid);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteTreeLog {
        private final List<String> deleteObjects = new ArrayList<String>();
        private final List<String> deleteLinks = new ArrayList<String>();
        private final Map<String, String> moveMapping = new HashMap<String, String>();

        private DeleteTreeLog() {
        }

        public List<String> getDeleteLinks() {
            return this.deleteLinks;
        }

        public List<String> getDeleteObjects() {
            return this.deleteObjects;
        }

        public Map<String, String> getMoveMapping() {
            return this.moveMapping;
        }
    }
}

