/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.xcmis.search.SearchService;
import org.xcmis.search.SearchServiceException;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.SearchServiceConfiguration;
import org.xcmis.search.content.Schema;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.interceptors.ContentReaderInterceptor;
import org.xcmis.search.lucene.content.VirtualTableResolver;
import org.xcmis.search.value.NameConverter;
import org.xcmis.search.value.PathSplitter;
import org.xcmis.search.value.SlashSplitter;
import org.xcmis.search.value.ToStringNameConverter;
import org.xcmis.sp.jcr.exo.JcrConnection;
import org.xcmis.sp.jcr.exo.QueryableStorage;
import org.xcmis.sp.jcr.exo.RenditionsUpdateListener;
import org.xcmis.sp.jcr.exo.StorageConfiguration;
import org.xcmis.sp.jcr.exo.StorageImpl;
import org.xcmis.sp.jcr.exo.index.CmisContentReader;
import org.xcmis.sp.jcr.exo.index.CmisSchema;
import org.xcmis.sp.jcr.exo.index.CmisSchemaTableResolver;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageProvider;
import org.xcmis.spi.TypeManager;

public class StorageProviderImpl
implements StorageProvider,
Startable {
    private static final Log LOG = ExoLogger.getLogger(StorageProviderImpl.class);
    private final RepositoryService repositoryService;
    private final DocumentReaderService documentReaderService;
    private RenditionManager renditionManager;
    private StorageConfiguration storageConfig = null;
    private PermissionService permissionService;
    private final Map<String, SearchService> searchServices = new HashMap<String, SearchService>();

    public StorageProviderImpl(RepositoryService repositoryService, InitParams initParams, DocumentReaderService documentReaderService, PermissionService permissionService) {
        this.repositoryService = repositoryService;
        this.documentReaderService = documentReaderService;
        this.permissionService = permissionService;
        if (initParams != null) {
            ObjectParameter param = initParams.getObjectParam("configs");
            if (param == null) {
                LOG.error((Object)"Init-params does not contain configuration for any CMIS repository.");
            }
            StorageProviderConfig confs = (StorageProviderConfig)param.getObject();
            this.storageConfig = confs.getStorage();
        } else {
            LOG.error((Object)"Not found configuration for any storages.");
        }
    }

    public Connection getConnection() {
        if (this.storageConfig == null) {
            throw new InvalidArgumentException("Not any CMIS repository  exist.");
        }
        String repositoryId = this.storageConfig.getRepository();
        String ws = this.storageConfig.getWorkspace();
        try {
            ManageableRepository repository = this.repositoryService.getRepository(repositoryId);
            Session session = repository.login(ws);
            SearchService searchService = this.getSearchService(this.storageConfig.getId());
            QueryableStorage storage = new QueryableStorage(session, this.storageConfig, this.renditionManager, searchService, this.permissionService);
            IndexListener indexListener = new IndexListener(storage, searchService);
            ((StorageImpl)storage).setIndexListener(indexListener);
            return new JcrConnection(storage);
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get CMIS repository " + this.storageConfig.getId() + ". " + re.getMessage(), (Throwable)re);
        }
        catch (RepositoryConfigurationException rce) {
            throw new CmisRuntimeException("Unable get CMIS repository " + this.storageConfig.getId() + ". " + rce.getMessage(), (Throwable)rce);
        }
        catch (SearchServiceException rce) {
            throw new CmisRuntimeException("Unable get CMIS repository " + this.storageConfig.getId() + ". " + rce.getMessage(), (Throwable)rce);
        }
    }

    private SearchService getSearchService(String id) throws SearchServiceException {
        return this.searchServices.get(id);
    }

    public String getStorageID() {
        return this.storageConfig.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider systemProvider = SessionProvider.createSystemProvider();
        try {
            Node xCmisSystem;
            ManageableRepository repository = this.repositoryService.getRepository(this.storageConfig.getRepository());
            Session session = systemProvider.getSession(this.storageConfig.getWorkspace(), repository);
            Node root = session.getRootNode();
            Node node = xCmisSystem = session.itemExists("/xcmis:system") ? (Node)session.getItem("/xcmis:system") : root.addNode("/xcmis:system".substring(1), "xcmis:system");
            if (!xCmisSystem.hasNode("xcmis:unfileStore")) {
                xCmisSystem.addNode("xcmis:unfileStore", "xcmis:unfiled");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"CMIS unfiled storage /xcmis:system/xcmis:unfileStore created.");
                }
            }
            if (!xCmisSystem.hasNode("xcmis:workingCopyStore")) {
                xCmisSystem.addNode("xcmis:workingCopyStore", "xcmis:workingCopies");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"CMIS Working Copies store /xcmis:system/xcmis:workingCopyStore created.");
                }
            }
            if (!xCmisSystem.hasNode("xcmis:relationshipStore")) {
                xCmisSystem.addNode("xcmis:relationshipStore", "xcmis:relationships");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"CMIS relationship store /xcmis:system/xcmis:relationshipStore created.");
                }
            }
            if (!xCmisSystem.hasNode("xcmis:policiesStore")) {
                xCmisSystem.addNode("xcmis:policiesStore", "xcmis:policies");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"CMIS policies store /xcmis:system/xcmis:policiesStore created.");
                }
            }
            session.save();
            this.renditionManager = RenditionManager.getInstance();
            boolean isPersistRenditions = false;
            if (this.storageConfig.getProperties() != null && this.storageConfig.getProperties().get("exo.cmis.renditions.persistent") != null) {
                isPersistRenditions = (Boolean)this.storageConfig.getProperties().get("exo.cmis.renditions.persistent");
            }
            if (isPersistRenditions) {
                Workspace workspace = session.getWorkspace();
                try {
                    EventListenerIterator it = workspace.getObservationManager().getRegisteredEventListeners();
                    boolean exist = false;
                    while (it.hasNext()) {
                        EventListener one = it.nextEventListener();
                        if (one.getClass() != RenditionsUpdateListener.class) continue;
                        exist = true;
                    }
                    if (!exist) {
                        workspace.getObservationManager().addEventListener((EventListener)new RenditionsUpdateListener((Repository)repository, this.storageConfig.getWorkspace(), this.renditionManager), 21, "/", true, null, new String[]{"nt:file", "nt:resource"}, false);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to create event listener, " + ex.getMessage()));
                }
            }
            StorageImpl storage = new StorageImpl(session, this.storageConfig, this.permissionService);
            CmisSchema schema = new CmisSchema((TypeManager)storage);
            CmisSchemaTableResolver tableResolver = new CmisSchemaTableResolver((NameConverter)new ToStringNameConverter(), schema, (TypeManager)storage);
            IndexConfiguration indexConfiguration = this.storageConfig.getIndexConfiguration();
            indexConfiguration.setRootUuid(storage.getRepositoryInfo().getRootFolderId());
            indexConfiguration.setRootParentUuid("");
            indexConfiguration.setDocumentReaderService(this.documentReaderService);
            InvocationContext invocationContext = new InvocationContext();
            invocationContext.setNameConverter((NameConverter)new ToStringNameConverter());
            invocationContext.setSchema((Schema)schema);
            invocationContext.setPathSplitter((PathSplitter)new SlashSplitter());
            invocationContext.setTableResolver((VirtualTableResolver)tableResolver);
            SearchServiceConfiguration configuration = new SearchServiceConfiguration();
            configuration.setIndexConfiguration(indexConfiguration);
            configuration.setContentReader((ContentReaderInterceptor)new CmisContentReader(storage));
            configuration.setNameConverter((NameConverter)new ToStringNameConverter());
            configuration.setDefaultInvocationContext(invocationContext);
            configuration.setTableResolver((VirtualTableResolver)tableResolver);
            configuration.setPathSplitter((PathSplitter)new SlashSplitter());
            SearchService searchService = new SearchService(configuration);
            searchService.start();
            IndexListener indexListener = new IndexListener(storage, searchService);
            storage.setIndexListener(indexListener);
            this.searchServices.put(this.storageConfig.getId(), searchService);
        }
        catch (RepositoryConfigurationException rce) {
            LOG.error((Object)"Unable to initialize storage. ", (Throwable)rce);
        }
        catch (RepositoryException re) {
            LOG.error((Object)"Unable to initialize storage. ", (Throwable)re);
        }
        catch (SearchServiceException e) {
            LOG.error((Object)"Unable to initialize storage. ", (Throwable)e);
        }
        finally {
            systemProvider.close();
        }
    }

    public void stop() {
        for (SearchService searchService : this.searchServices.values()) {
            searchService.stop();
        }
    }

    public StorageConfiguration getStorageConfiguration() {
        return this.storageConfig;
    }

    public static class StorageProviderConfig {
        private StorageConfiguration storage;

        public StorageConfiguration getStorage() {
            return this.storage;
        }

        public void setStorage(StorageConfiguration storage) {
            this.storage = storage;
        }
    }
}

