/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo.index;

import java.util.ArrayList;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.command.read.GetChildEntriesCommand;
import org.xcmis.search.content.command.read.GetContentEntryCommand;
import org.xcmis.search.content.command.read.GetUnfiledEntriesCommand;
import org.xcmis.search.content.interceptors.ContentReaderInterceptor;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.Storage;

public class CmisContentReader
extends ContentReaderInterceptor {
    private final Storage storage;
    private final IndexListener.ContentEntryAdapter contentEntryAdapter;

    public CmisContentReader(Storage storage) {
        this.storage = storage;
        this.contentEntryAdapter = new IndexListener.ContentEntryAdapter();
    }

    public Object visitChildEntriesCommand(InvocationContext ctx, GetChildEntriesCommand command) throws Throwable {
        ArrayList<ContentEntry> childs = new ArrayList<ContentEntry>();
        ObjectData parent = this.storage.getObjectById(command.getParentUuid());
        if (parent instanceof FolderData) {
            ItemsIterator childDatas = ((FolderData)parent).getChildren(null);
            while (childDatas.hasNext()) {
                childs.add(this.contentEntryAdapter.createEntry((ObjectData)childDatas.next()));
            }
        }
        return childs;
    }

    public Object visitGetContentEntryCommand(InvocationContext ctx, GetContentEntryCommand command) throws Throwable {
        ObjectData entry;
        try {
            entry = this.storage.getObjectById(command.getEntryUuid());
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        return this.contentEntryAdapter.createEntry(entry);
    }

    public Object visitGetUnfiledEntriesCommand(InvocationContext ctx, GetUnfiledEntriesCommand command) throws Throwable {
        return this.storage.getUnfiledObjectsId();
    }
}

