/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsTree;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UserContext;
import org.xcmis.spi.model.ACLCapability;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.Permission;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.RepositoryCapabilities;
import org.xcmis.spi.model.RepositoryShortInfo;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.model.impl.BooleanProperty;
import org.xcmis.spi.model.impl.DateTimeProperty;
import org.xcmis.spi.model.impl.DecimalProperty;
import org.xcmis.spi.model.impl.HtmlProperty;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.IntegerProperty;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.model.impl.UriProperty;
import org.xcmis.spi.utils.CmisUtils;
import org.xcmis.spi.utils.MimeType;

public class BaseTest {
    protected static ACLCapability aclCapability;
    protected static RepositoryCapabilities capabilities;
    protected static Connection connection;
    protected static boolean isPoliciesSupported;
    protected static boolean isRelationshipsSupported;
    protected static FolderData rootFolder;
    protected static String rootFolderID;
    protected static byte[] TEST_CONTENT;
    protected static final ContentStream TEST_CONTENT_STREAM;
    protected static final String TEST_POLICY_TEXT = "__TEST_POLICY__";

    @BeforeClass
    public static void init() throws Exception {
        CmisRegistry reg = CmisRegistry.getInstance();
        Iterator it = reg.getStorageInfos().iterator();
        if (!it.hasNext()) {
            Assert.fail((String)"Could not find storages to test");
        }
        connection = reg.getConnection(((RepositoryShortInfo)it.next()).getRepositoryId());
        UserContext ctx = new UserContext("root");
        UserContext.setCurrent((UserContext)ctx);
        rootFolderID = connection.getStorage().getRepositoryInfo().getRootFolderId();
        try {
            connection.getTypeDefinition("cmis:policy");
            isPoliciesSupported = true;
        }
        catch (TypeNotFoundException e) {
            // empty catch block
        }
        try {
            connection.getTypeDefinition("cmis:relationship");
            isRelationshipsSupported = true;
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
        capabilities = connection.getStorage().getRepositoryInfo().getCapabilities();
        aclCapability = connection.getStorage().getRepositoryInfo().getAclCapability();
    }

    public static void clear(String root) {
        try {
            if (isRelationshipsSupported) {
                BaseTest.removeRelationships(root);
            }
            connection.deleteTree(root, Boolean.valueOf(true), UnfileObject.DELETE, Boolean.valueOf(true));
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static List<AccessControlEntry> createACL(String name, String ... permission) {
        AccessControlEntry acl = new AccessControlEntry();
        acl.setPrincipal(name);
        acl.getPermissions().addAll(Arrays.asList(permission));
        ArrayList<AccessControlEntry> addACL = new ArrayList<AccessControlEntry>();
        addACL.add(acl);
        return addACL;
    }

    protected static String createDocument(String parentId, String typeId, String name, ContentStream content, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies, VersioningState versioningState) throws Exception {
        Map<String, Property<?>> properties;
        StringProperty nameProperty;
        ContentStreamAllowed streamAllowed;
        TypeDefinition type = connection.getTypeDefinition(typeId, true);
        boolean versionable = type.isVersionable();
        if (!versionable) {
            versioningState = VersioningState.NONE;
        }
        if ((streamAllowed = type.getContentStreamAllowed()) == ContentStreamAllowed.REQUIRED && content == null) {
            content = TEST_CONTENT_STREAM;
        }
        if ((nameProperty = (StringProperty)(properties = BaseTest.createPropertyMap(type)).get("cmis:name")) != null) {
            nameProperty.getValues().add(name);
        }
        String documentId = connection.createDocument(parentId, properties, content, addACL, removeACL, policies, versioningState);
        return documentId;
    }

    protected static String createFolder(String parentId, String typeId, String name, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies) throws Exception {
        TypeDefinition type = connection.getTypeDefinition(typeId, true);
        Map<String, Property<?>> properties = BaseTest.createPropertyMap(type);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add(name);
        }
        String folderId = connection.createFolder(parentId, properties, addACL, removeACL, policies);
        return folderId;
    }

    protected static String createPolicy(String parentId, String typeId, String name, String policyText, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies) throws Exception {
        String policyId = null;
        if (isPoliciesSupported) {
            StringProperty policyTextProperty;
            TypeDefinition type = connection.getTypeDefinition(typeId, true);
            Map<String, Property<?>> properties = BaseTest.createPropertyMap(type);
            StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
            if (nameProperty != null) {
                nameProperty.getValues().add(name);
            }
            if ((policyTextProperty = (StringProperty)properties.get("cmis:policyText")) != null) {
                policyTextProperty.getValues().add(policyText != null ? policyText : TEST_POLICY_TEXT);
            }
            policyId = connection.createPolicy(type.isFileable() ? parentId : null, properties, null, null, null);
        }
        return policyId;
    }

    protected static Map<String, Property<?>> createPropertyMap(TypeDefinition type) throws Exception {
        HashMap properties = new HashMap();
        for (PropertyDefinition propertyDefinition : type.getPropertyDefinitions()) {
            Updatability updatability = propertyDefinition.getUpdatability();
            if (updatability != Updatability.ONCREATE && updatability != Updatability.READWRITE) continue;
            BooleanProperty property = null;
            PropertyType propertyType = propertyDefinition.getPropertyType();
            switch (propertyType) {
                case BOOLEAN: {
                    property = new BooleanProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (Boolean)null);
                    break;
                }
                case DATETIME: {
                    property = new DateTimeProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (Calendar)null);
                    break;
                }
                case DECIMAL: {
                    property = new DecimalProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (BigDecimal)null);
                    break;
                }
                case HTML: {
                    property = new HtmlProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (String)null);
                    break;
                }
                case ID: {
                    property = new IdProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (String)null);
                    break;
                }
                case INTEGER: {
                    property = new IntegerProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (BigInteger)null);
                    break;
                }
                case STRING: {
                    property = new StringProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (String)null);
                    break;
                }
                case URI: {
                    property = new UriProperty(propertyDefinition.getId(), propertyDefinition.getQueryName(), propertyDefinition.getLocalName(), propertyDefinition.getDisplayName(), (URI)null);
                }
            }
            properties.put(propertyDefinition.getId(), (Property<?>)property);
        }
        PropertyDefinition typeIdPropertyDefinition = type.getPropertyDefinition("cmis:objectTypeId");
        IdProperty typeIdProperty = new IdProperty(typeIdPropertyDefinition.getId(), typeIdPropertyDefinition.getQueryName(), typeIdPropertyDefinition.getLocalName(), typeIdPropertyDefinition.getDisplayName(), type.getId());
        properties.put(typeIdPropertyDefinition.getId(), (Property<?>)typeIdProperty);
        return properties;
    }

    protected static String createRelationship(String typeId, String name, String sourceId, String targetId, List<AccessControlEntry> addACL, List<AccessControlEntry> removeACL, Collection<String> policies) throws Exception {
        String relationshipId = null;
        if (isRelationshipsSupported) {
            IdProperty targetIdProperty;
            IdProperty sourceIdProperty;
            TypeDefinition type = connection.getTypeDefinition(typeId, true);
            Map<String, Property<?>> properties = BaseTest.createPropertyMap(type);
            StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
            if (nameProperty != null) {
                nameProperty.getValues().add(name);
            }
            if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
                sourceIdProperty.getValues().add(sourceId);
            }
            if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
                targetIdProperty.getValues().add(targetId);
            }
            relationshipId = connection.createRelationship(properties, null, null, null);
        }
        return relationshipId;
    }

    protected static String generateName(TypeDefinition type, String suffix) {
        StringBuilder b = new StringBuilder();
        switch (type.getBaseId()) {
            case DOCUMENT: {
                b.append("document");
                break;
            }
            case FOLDER: {
                b.append("folder");
                break;
            }
            case POLICY: {
                b.append("policy");
                break;
            }
            case RELATIONSHIP: {
                b.append("relationship");
            }
        }
        b.append('_').append(UUID.randomUUID().toString());
        if (suffix != null && suffix.length() > 0) {
            b.append('.').append(suffix);
        }
        return b.toString();
    }

    protected static TypeDefinition getControllableAclType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        for (ItemsTree<TypeDefinition> item : types) {
            TypeDefinition container = (TypeDefinition)item.getContainer();
            if (container.isControllableACL()) {
                return container;
            }
            List children = item.getChildren();
            if (children == null || children.isEmpty()) continue;
            return BaseTest.getControllableAclType(children);
        }
        return null;
    }

    protected static TypeDefinition getControllablePolicyType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        if (isPoliciesSupported) {
            for (ItemsTree<TypeDefinition> item : types) {
                TypeDefinition container = (TypeDefinition)item.getContainer();
                if (container.isControllablePolicy()) {
                    return container;
                }
                List children = item.getChildren();
                if (children == null || children.isEmpty()) continue;
                return BaseTest.getControllablePolicyType(children);
            }
        }
        return null;
    }

    protected static TypeDefinition getNotControllableAclType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        for (ItemsTree<TypeDefinition> item : types) {
            TypeDefinition container = (TypeDefinition)item.getContainer();
            if (!container.isControllableACL()) {
                return container;
            }
            List children = item.getChildren();
            if (children == null || children.isEmpty()) continue;
            return BaseTest.getNotControllableAclType(children);
        }
        return null;
    }

    protected static TypeDefinition getNotControllablePolicyType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        for (ItemsTree<TypeDefinition> item : types) {
            TypeDefinition container = (TypeDefinition)item.getContainer();
            if (!container.isControllablePolicy()) {
                return container;
            }
            List children = item.getChildren();
            if (children == null || children.isEmpty()) continue;
            return BaseTest.getNotControllablePolicyType(children);
        }
        return null;
    }

    protected static TypeDefinition getNotVersionableDocType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        for (ItemsTree<TypeDefinition> item : types) {
            TypeDefinition container = (TypeDefinition)item.getContainer();
            if (container.getBaseId() != BaseType.DOCUMENT) continue;
            if (!container.isVersionable()) {
                return container;
            }
            List children = item.getChildren();
            if (children == null || children.isEmpty()) continue;
            return BaseTest.getNotVersionableDocType(children);
        }
        return null;
    }

    protected static TypeDefinition getStreamNotSupportedDocType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        for (ItemsTree<TypeDefinition> item : types) {
            TypeDefinition container = (TypeDefinition)item.getContainer();
            if (container.getBaseId() != BaseType.DOCUMENT) continue;
            if (container.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED) {
                return container;
            }
            List children = item.getChildren();
            if (children == null || children.isEmpty()) continue;
            return BaseTest.getStreamNotSupportedDocType(children);
        }
        return null;
    }

    protected static TypeDefinition getStreamRequiredDocType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        for (ItemsTree<TypeDefinition> item : types) {
            TypeDefinition container = (TypeDefinition)item.getContainer();
            if (container.getBaseId() != BaseType.DOCUMENT) continue;
            if (container.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
                return container;
            }
            List children = item.getChildren();
            if (children == null || children.isEmpty()) continue;
            return BaseTest.getStreamRequiredDocType(children);
        }
        return null;
    }

    protected static TypeDefinition getVersionableDocType(List<ItemsTree<TypeDefinition>> types) throws Exception {
        for (ItemsTree<TypeDefinition> item : types) {
            TypeDefinition container = (TypeDefinition)item.getContainer();
            if (container.getBaseId() != BaseType.DOCUMENT) continue;
            if (container.isVersionable()) {
                return container;
            }
            List children = item.getChildren();
            if (children == null || children.isEmpty()) continue;
            return BaseTest.getVersionableDocType(children);
        }
        return null;
    }

    protected static void removeRelationships(String testroot) {
        try {
            List descendants = connection.getDescendants(testroot, -1, false, IncludeRelationships.BOTH, false, true, "*", "cmis:none");
            for (ItemsTree tr : descendants) {
                for (CmisObject relationship : ((CmisObject)tr.getContainer()).getRelationship()) {
                    try {
                        connection.deleteObject(relationship.getObjectInfo().getId(), null);
                    }
                    catch (ObjectNotFoundException e) {}
                }
                List children = tr.getChildren();
                if (children == null || children.size() <= 0) continue;
                BaseTest.removeRelationships(((CmisObject)tr.getContainer()).getObjectInfo().getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void checkACL(List<AccessControlEntry> expected, List<AccessControlEntry> actual) {
        HashMap m1 = new HashMap();
        CmisUtils.addAclToPermissionMap(m1, expected);
        HashMap m2 = new HashMap();
        CmisUtils.addAclToPermissionMap(m2, actual);
        for (Map.Entry e : m1.entrySet()) {
            String principal = (String)e.getKey();
            Set permissions2 = (Set)m2.get(principal);
            if (permissions2 == null) {
                Assert.fail((String)"ACLs are not matched.");
            }
            if (actual.contains("cmis:all")) continue;
            for (String permission : (Set)e.getValue()) {
                Assert.assertTrue((String)("ACLs are not matched. Permission " + permission + " for principal " + principal + " not found"), (boolean)permissions2.contains(permission));
            }
        }
    }

    protected List<CmisObject> objectTreeAsList(List<ItemsTree<CmisObject>> source) {
        ArrayList<CmisObject> result = new ArrayList<CmisObject>();
        for (ItemsTree<CmisObject> one : source) {
            CmisObject o = (CmisObject)one.getContainer();
            if (one.getChildren() != null) {
                result.addAll(this.objectTreeAsList(one.getChildren()));
            }
            result.add(o);
        }
        return result;
    }

    protected List<TypeDefinition> typeTreeAsList(List<ItemsTree<TypeDefinition>> source) {
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        for (ItemsTree<TypeDefinition> one : source) {
            TypeDefinition type = (TypeDefinition)one.getContainer();
            if (one.getChildren() != null) {
                result.addAll(this.typeTreeAsList(one.getChildren()));
            }
            result.add(type);
        }
        return result;
    }

    protected void validateACL(List<AccessControlEntry> actual) {
        HashMap m1 = new HashMap();
        CmisUtils.addAclToPermissionMap(m1, actual);
        HashSet<String> allowed = new HashSet<String>();
        for (Permission permission : aclCapability.getPermissions()) {
            allowed.add(permission.getPermission());
        }
        for (Map.Entry entry : m1.entrySet()) {
            for (String permission : (Set)entry.getValue()) {
                Assert.assertTrue((String)("ACLs contains unknown permission: " + permission), (boolean)allowed.contains(permission));
            }
        }
    }

    static {
        isPoliciesSupported = false;
        isRelationshipsSupported = false;
        TEST_CONTENT = "__TEST_CONTENT__".getBytes();
        TEST_CONTENT_STREAM = new ContentStream(){
            MimeType mimeType = new MimeType("text", "plain");

            public String getFileName() {
                return "";
            }

            public MimeType getMediaType() {
                return this.mimeType;
            }

            public InputStream getStream() throws IOException {
                return new ByteArrayInputStream(TEST_CONTENT);
            }

            public long length() {
                return TEST_CONTENT.length;
            }
        };
    }
}

