/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.HashSet;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.ChangeLogTokenHolder;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.CapabilityChanges;
import org.xcmis.spi.model.CapabilityQuery;
import org.xcmis.spi.model.CapabilityRendition;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.tck.BaseTest;
import org.xcmis.spi.utils.MimeType;

public class DiscoveryTest
extends BaseTest {
    private static String testRootFolderId;
    private static String name0;
    private static String name1;
    private static String name2;
    private static String document0;
    private static String document1;
    private static String document2;
    private static TypeDefinition documentType;

    @BeforeClass
    public static void start() throws Exception {
        testRootFolderId = DiscoveryTest.createFolder(rootFolderID, "cmis:folder", "discovery_testroot", null, null, null);
        documentType = connection.getTypeDefinition("cmis:document");
        document0 = DiscoveryTest.createDocument(testRootFolderId, documentType.getId(), name0, (ContentStream)(documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : new BaseContentStream("test query 000".getBytes(), "", new MimeType("text", "plain"))), null, null, null, null);
        document1 = DiscoveryTest.createDocument(testRootFolderId, documentType.getId(), name1, (ContentStream)(documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : new BaseContentStream("test query 001".getBytes(), "", new MimeType("text", "plain"))), null, null, null, null);
        document2 = DiscoveryTest.createDocument(testRootFolderId, documentType.getId(), name2, (ContentStream)(documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : new BaseContentStream("test query 002".getBytes(), "", new MimeType("text", "plain"))), null, null, null, null);
        System.out.println("Running Discovery Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            DiscoveryTest.clear(testRootFolderId);
        }
    }

    @Test
    public void testContentChanges() throws Exception {
        CapabilityChanges capabilityChanges = capabilities.getCapabilityChanges();
        if (capabilityChanges == CapabilityChanges.NONE) {
            return;
        }
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        DiscoveryTest.createDocument(testRootFolderId, documentType.getId(), DiscoveryTest.generateName(documentType, null), null, null, null, null, null);
        String logToken = connection.getStorage().getRepositoryInfo().getLatestChangeLogToken();
        ChangeLogTokenHolder logTokenHolder = new ChangeLogTokenHolder();
        logTokenHolder.setValue((Object)logToken);
        ItemsList changes = connection.getContentChanges(logTokenHolder, capabilityChanges == CapabilityChanges.ALL || capabilityChanges == CapabilityChanges.PROPERTIES, null, isPoliciesSupported, capabilities.getCapabilityACL() != CapabilityACL.NONE, true, -1);
        Assert.assertEquals((long)1L, (long)changes.getNumItems());
    }

    @Test
    public void testQuery() throws Exception {
        if (capabilities.getCapabilityQuery() == CapabilityQuery.NONE) {
            return;
        }
        String statement = null;
        statement = documentType.getContentStreamAllowed() != ContentStreamAllowed.NOT_ALLOWED ? "SELECT * FROM cmis:document WHERE CONTAINS(\"test query 000\")" : "SELECT * FROM cmis:document WHERE cmis:name='test query 000'";
        ItemsList query = connection.query(statement, capabilities.isCapabilityAllVersionsSearchable(), true, isRelationshipsSupported ? IncludeRelationships.BOTH : IncludeRelationships.NONE, true, capabilities.getCapabilityRenditions() != CapabilityRendition.NONE ? "*" : "cmis:none", -1, 0);
        Assert.assertNotNull((Object)query);
        List items = query.getItems();
        Assert.assertEquals((long)1L, (long)items.size());
        CmisObject item = (CmisObject)items.get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)document0, (Object)item.getObjectInfo().getId());
    }

    @Test
    public void testQuery2() throws Exception {
        if (capabilities.getCapabilityQuery() == CapabilityQuery.NONE) {
            return;
        }
        String statement = null;
        statement = documentType.getContentStreamAllowed() != ContentStreamAllowed.NOT_ALLOWED ? "SELECT * FROM cmis:document WHERE CONTAINS(\"test query\")" : "SELECT * FROM cmis:document WHERE cmis:name LIKE 'test query%'";
        ItemsList query = connection.query(statement, capabilities.isCapabilityAllVersionsSearchable(), true, isRelationshipsSupported ? IncludeRelationships.BOTH : IncludeRelationships.NONE, true, capabilities.getCapabilityRenditions() != CapabilityRendition.NONE ? "*" : "cmis:none", -1, 0);
        Assert.assertNotNull((Object)query);
        List items = query.getItems();
        Assert.assertEquals((long)3L, (long)items.size());
        HashSet<String> ids = new HashSet<String>(3);
        for (CmisObject item : items) {
            ids.add(item.getObjectInfo().getId());
        }
        Assert.assertTrue((String)("Expected item " + document0 + " not found in result set. "), (boolean)ids.contains(document0));
        Assert.assertTrue((String)("Expected item " + document1 + " not found in result set. "), (boolean)ids.contains(document1));
        Assert.assertTrue((String)("Expected item " + document2 + " not found in result set. "), (boolean)ids.contains(document2));
    }

    static {
        name0 = "test query 000";
        name1 = "test query 001";
        name2 = "test query 002";
    }
}

