/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.tck.BaseTest;

public class RelationshipTest
extends BaseTest {
    private static String document0;
    private static String document1;
    private static String document2;
    private static String relationship0_1;
    private static String relationship1_2;
    private static String relationship2_0;
    private static TypeDefinition relationshipType;
    private static String testRootFolderId;

    @BeforeClass
    public static void start() throws Exception {
        TypeDefinition folderType = connection.getTypeDefinition("cmis:folder");
        testRootFolderId = RelationshipTest.createFolder(rootFolderID, folderType.getId(), "relationship_testroot", null, null, null);
        if (isRelationshipsSupported) {
            relationshipType = connection.getTypeDefinition("cmis:relationship");
            TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
            document0 = RelationshipTest.createDocument(testRootFolderId, documentType.getId(), RelationshipTest.generateName(documentType, null), null, null, null, null, null);
            document1 = RelationshipTest.createDocument(testRootFolderId, documentType.getId(), RelationshipTest.generateName(documentType, null), null, null, null, null, null);
            document2 = RelationshipTest.createDocument(testRootFolderId, documentType.getId(), RelationshipTest.generateName(documentType, null), null, null, null, null, null);
            relationship0_1 = RelationshipTest.createRelationship(relationshipType.getId(), RelationshipTest.generateName(relationshipType, null), document0, document1, null, null, null);
            relationship1_2 = RelationshipTest.createRelationship(relationshipType.getId(), RelationshipTest.generateName(relationshipType, null), document1, document2, null, null, null);
            relationship2_0 = RelationshipTest.createRelationship(relationshipType.getId(), RelationshipTest.generateName(relationshipType, null), document2, document0, null, null, null);
        }
        System.out.println("Running Relationship Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            RelationshipTest.clear(testRootFolderId);
        }
    }

    @Test
    public void testGetChildren_MaxItems() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        ItemsList relationships = connection.getObjectRelationships(document0, RelationshipDirection.EITHER, null, true, false, true, null, 1, 0);
        Assert.assertTrue((String)"Wrong number of items in result. ", (relationships.getItems().size() <= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetObjectRelationships() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        ItemsList relationships = connection.getObjectRelationships(document0, RelationshipDirection.EITHER, null, true, false, true, null, -1, 0);
        HashSet<String> ids = new HashSet<String>(relationships.getItems().size());
        for (CmisObject o : relationships.getItems()) {
            ids.add(o.getObjectInfo().getId());
        }
        Assert.assertEquals((long)2L, (long)ids.size());
        Assert.assertTrue((String)("Expected relationship " + relationship0_1 + "is not found in result. "), (boolean)ids.contains(relationship0_1));
        Assert.assertTrue((String)("Expected relationship " + relationship2_0 + "is not found in result. "), (boolean)ids.contains(relationship2_0));
    }

    @Test
    public void testGetObjectRelationships_AllowableActions() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        ItemsList relationships = connection.getObjectRelationships(document0, RelationshipDirection.EITHER, null, true, true, true, null, -1, 0);
        for (CmisObject o : relationships.getItems()) {
            Assert.assertNotNull((String)"Allowable actions must be include in response. ", (Object)o.getAllowableActions());
        }
    }

    @Test
    public void testGetObjectRelationships_Direction() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        ItemsList relationships = connection.getObjectRelationships(document0, RelationshipDirection.SOURCE, null, true, false, true, null, -1, 0);
        HashSet<String> ids = new HashSet<String>(relationships.getItems().size());
        for (CmisObject o : relationships.getItems()) {
            ids.add(o.getObjectInfo().getId());
        }
        Assert.assertEquals((long)1L, (long)ids.size());
        Assert.assertTrue((String)("Expected relationship " + relationship0_1 + "is not found in result. "), (boolean)ids.contains(relationship0_1));
    }

    @Test
    public void testGetObjectRelationships_SkipCount() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        ItemsList relationships = connection.getObjectRelationships(document0, RelationshipDirection.EITHER, null, true, false, true, null, -1, 0);
        ArrayList<String> relationshipIDs = new ArrayList<String>(2);
        for (CmisObject o : relationships.getItems()) {
            relationshipIDs.add(o.getObjectInfo().getId());
        }
        Assert.assertEquals((long)2L, (long)relationshipIDs.size());
        relationships = connection.getObjectRelationships(document0, RelationshipDirection.EITHER, null, true, false, true, null, -1, 1);
        ArrayList<String> relationshipIDsPage = new ArrayList<String>(6);
        for (CmisObject o : relationships.getItems()) {
            relationshipIDsPage.add(o.getObjectInfo().getId());
        }
        Assert.assertEquals((long)1L, (long)relationshipIDsPage.size());
        Iterator iterator0 = relationshipIDs.iterator();
        iterator0.next();
        iterator0.remove();
        Assert.assertEquals(relationshipIDs, relationshipIDsPage);
    }
}

