/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.RepositoryShortInfo;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.tck.BaseTest;

public class RepositoryTest
extends BaseTest {
    @BeforeClass
    public static void start() throws Exception {
        System.out.println("Running Repository Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
    }

    @Test
    public void testGetRepositories() throws Exception {
        Set storageInfos = CmisRegistry.getInstance().getStorageInfos();
        Assert.assertNotNull((String)"StorageInfo is null.", (Object)storageInfos);
        Assert.assertTrue((String)"StorageInfo is empty.", (!storageInfos.isEmpty() ? 1 : 0) != 0);
        for (RepositoryShortInfo repositoryShortInfo : storageInfos) {
            Assert.assertTrue((String)"Repository id is missing.", (repositoryShortInfo.getRepositoryId() != null && repositoryShortInfo.getRepositoryId().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Repository name is missing.", (repositoryShortInfo.getRepositoryName() != null && repositoryShortInfo.getRepositoryName().length() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((String)"Root folder id is missing.", (Object)repositoryShortInfo.getRootFolderId());
        }
    }

    @Test
    public void testGetRepositoryInfo() throws Exception {
        RepositoryInfo repositoryInfo = connection.getStorage().getRepositoryInfo();
        Assert.assertNotNull((String)"RepositoryInfo is null.", (Object)repositoryInfo);
        Assert.assertTrue((String)"Repository id is missing.", (repositoryInfo.getRepositoryId() != null && repositoryInfo.getRepositoryId().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Repository name is missing.", (Object)repositoryInfo.getRepositoryName());
        Assert.assertNotNull((String)"Repository VendorName is missing.", (Object)repositoryInfo.getVendorName());
        Assert.assertNotNull((String)"Repository ProductName is missing.", (Object)repositoryInfo.getProductName());
        Assert.assertNotNull((String)"Repository PropductVersion is missing.", (Object)repositoryInfo.getProductVersion());
        Assert.assertNotNull((String)"Repository Root Folder id is missing.", (Object)repositoryInfo.getRootFolderId());
        Assert.assertNotNull((String)"Repository Capabilities is missing.", (Object)repositoryInfo.getCapabilities());
        Assert.assertNotNull((String)"Repository version supported is missing.", (Object)repositoryInfo.getCmisVersionSupported());
        Assert.assertNotNull((String)"Repository Changes on type is missing.", (Object)repositoryInfo.getChangesOnType());
        Assert.assertNotNull((String)"Repository ACL capability is missing.", (Object)repositoryInfo.getAclCapability());
        if (!repositoryInfo.getCapabilities().getCapabilityACL().equals((Object)CapabilityACL.NONE)) {
            Assert.assertNotNull((String)"Repository supported permissions is missing.", (Object)repositoryInfo.getAclCapability().getSupportedPermissions());
            Assert.assertNotNull((String)"Repository ACL propagation is missing.", (Object)repositoryInfo.getAclCapability().getPropagation());
            Assert.assertNotNull((String)"Repository ACL permissions is missing.", (Object)repositoryInfo.getAclCapability().getPermissions());
            Assert.assertNotNull((String)"Repository ACL mapping is missing.", (Object)repositoryInfo.getAclCapability().getMapping());
        }
        Assert.assertNotNull((String)"Repository principal anonymous is missing.", (Object)repositoryInfo.getPrincipalAnonymous());
        Assert.assertNotNull((String)"Repository principal anyone is missing.", (Object)repositoryInfo.getPrincipalAnyone());
    }

    @Test
    public void testGetTypeChildren() throws Exception {
        ItemsList typeChildren = connection.getTypeChildren(null, false, -1, 0);
        ArrayList<String> tids = new ArrayList<String>();
        for (TypeDefinition t : typeChildren.getItems()) {
            tids.add(t.getId());
            Assert.assertNull((Object)t.getPropertyDefinitions());
        }
        ArrayList<String> exp = new ArrayList<String>();
        exp.add("cmis:document");
        exp.add("cmis:folder");
        if (isPoliciesSupported) {
            exp.add("cmis:policy");
        }
        if (isRelationshipsSupported) {
            exp.add("cmis:relationship");
        }
        for (String s : exp) {
            Assert.assertTrue((String)("Expected type " + s + " is not found in result. "), (boolean)tids.contains(s));
        }
    }

    @Test
    public void testGetTypeChildren_IncludeProperty() throws Exception {
        ItemsList typeChildren = connection.getTypeChildren(null, true, -1, 0);
        for (TypeDefinition t : typeChildren.getItems()) {
            Assert.assertNotNull((String)"Property definitions not found.", (Object)t.getPropertyDefinitions());
        }
    }

    @Test
    public void testGetTypeChildren_MaxItems() throws Exception {
        ItemsList types = connection.getTypeChildren(null, false, 1, 0);
        Assert.assertNotNull((String)"Root type childrens is null.", (Object)types);
        Assert.assertTrue((String)"Incorrect Root type childrens size.", (types.getItems().size() <= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTypeChildren_SkipCount() throws Exception {
        ItemsList types = connection.getTypeChildren(null, false, -1, 0);
        ArrayList<String> tids = new ArrayList<String>();
        for (TypeDefinition t : types.getItems()) {
            tids.add(t.getId());
        }
        types = connection.getTypeChildren(null, false, -1, 1);
        ArrayList<String> tidsPage = new ArrayList<String>();
        for (TypeDefinition t : types.getItems()) {
            tidsPage.add(t.getId());
        }
        Iterator iterator0 = tids.iterator();
        iterator0.next();
        iterator0.remove();
        Assert.assertEquals(tids, tidsPage);
    }

    @Test
    public void testGetTypeChildren_TypeNotFoundException() throws Exception {
        String type = "cmis:document" + System.currentTimeMillis();
        try {
            connection.getTypeChildren(type, false, -1, 0);
            Assert.fail((String)("TypeNotFoundException must be thrown, type definition " + type + " shouldn't exist. "));
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTypeDefinition_Document() throws Exception {
        TypeDefinition type = connection.getTypeDefinition("cmis:document", false);
        Assert.assertEquals((Object)"cmis:document", (Object)type.getId());
        Assert.assertEquals((Object)BaseType.DOCUMENT, (Object)type.getBaseId());
        Assert.assertNotNull((Object)("Query name required. " + type.getQueryName()));
        Assert.assertNull((String)"Root type may not have parent type. ", (Object)type.getParentId());
        Assert.assertNull((String)"Property definitions was not requested. ", (Object)type.getPropertyDefinitions());
    }

    @Test
    public void testGetTypeDefinition_Folder() throws Exception {
        TypeDefinition type = connection.getTypeDefinition("cmis:folder", false);
        Assert.assertEquals((Object)"cmis:folder", (Object)type.getId());
        Assert.assertEquals((Object)BaseType.FOLDER, (Object)type.getBaseId());
        Assert.assertNotNull((Object)("Query name required. " + type.getQueryName()));
        Assert.assertNull((String)"Root type may not have parent type. ", (Object)type.getParentId());
        Assert.assertTrue((String)"Folder type is fileable. ", (boolean)type.isFileable());
        Assert.assertNull((String)"Property definitions was not requested. ", (Object)type.getPropertyDefinitions());
    }

    @Test
    public void testGetTypeDefinition_Policy() throws Exception {
        if (!isPoliciesSupported) {
            return;
        }
        TypeDefinition type = connection.getTypeDefinition("cmis:policy", false);
        Assert.assertEquals((Object)"cmis:policy", (Object)type.getId());
        Assert.assertEquals((Object)BaseType.POLICY, (Object)type.getBaseId());
        Assert.assertNotNull((Object)("Query name required. " + type.getQueryName()));
        Assert.assertNull((String)"Root type may not have parent type. ", (Object)type.getParentId());
        Assert.assertNull((String)"Property definitions was not requested. ", (Object)type.getPropertyDefinitions());
    }

    @Test
    public void testGetTypeDefinition_Relationship() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        TypeDefinition type = connection.getTypeDefinition("cmis:relationship", false);
        Assert.assertEquals((Object)"cmis:relationship", (Object)type.getId());
        Assert.assertEquals((Object)BaseType.RELATIONSHIP, (Object)type.getBaseId());
        Assert.assertNotNull((Object)("Query name required. " + type.getQueryName()));
        Assert.assertNull((String)"Root type may not have parent type. ", (Object)type.getParentId());
        Assert.assertFalse((String)"Relationship type is not fileable. ", (boolean)type.isFileable());
        Assert.assertNull((String)"Property definitions was not requested. ", (Object)type.getPropertyDefinitions());
    }

    @Test
    public void testGetTypeDefinition_TypeNotFoundException() throws Exception {
        String type = "cmis:document" + System.currentTimeMillis();
        try {
            connection.getTypeDefinition(type, false);
            Assert.fail((String)("TypeNotFoundException must be thrown, type definition " + type + " shouldn't exist. "));
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTypeDescendants() throws Exception {
        List typeDescendants = connection.getTypeDescendants(null, -1, false);
        List<TypeDefinition> treeAsList = this.typeTreeAsList(typeDescendants);
        ArrayList<String> tids = new ArrayList<String>();
        for (TypeDefinition t : treeAsList) {
            tids.add(t.getId());
            Assert.assertNull((Object)t.getPropertyDefinitions());
        }
        ArrayList<String> exp = new ArrayList<String>();
        exp.add("cmis:document");
        exp.add("cmis:folder");
        if (isPoliciesSupported) {
            exp.add("cmis:policy");
        }
        if (isRelationshipsSupported) {
            exp.add("cmis:relationship");
        }
        for (String s : exp) {
            Assert.assertTrue((String)("Expected type " + s + " is not found in result. "), (boolean)tids.contains(s));
        }
    }

    @Test
    public void testGetTypeDescendants_IncludeProperty() throws Exception {
        List typeDescendants = connection.getTypeDescendants(null, -1, true);
        List<TypeDefinition> treeAsList = this.typeTreeAsList(typeDescendants);
        for (TypeDefinition t : treeAsList) {
            Assert.assertNotNull((String)"Property definitions not found.", (Object)t.getPropertyDefinitions());
        }
    }

    @Test
    public void testGetTypeDescendants_TypeNotFoundException() throws Exception {
        String type = "cmis:document" + System.currentTimeMillis();
        try {
            connection.getTypeDescendants(type, -1, false);
            Assert.fail((String)("TypeNotFoundException must be thrown, type definition " + type + " shouldn't exist. "));
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
    }
}

