/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StreamNotSupportedException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.tck.BaseTest;
import org.xcmis.spi.utils.MimeType;

public class VersioningTest
extends BaseTest {
    private static String testRootFolderId;
    private static TypeDefinition documentTypeVersionable;
    private static TypeDefinition documentTypeNotVersionable;
    private String principal = "root";

    @BeforeClass
    public static void start() throws Exception {
        testRootFolderId = VersioningTest.createFolder(rootFolderID, "cmis:folder", "versioning_testroot", null, null, null);
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        List allDocs = connection.getTypeDescendants(documentType.getId(), -1, true);
        if (documentType.isVersionable()) {
            documentTypeVersionable = documentType;
        } else {
            documentTypeNotVersionable = documentType;
        }
        if (documentTypeNotVersionable == null) {
            documentTypeNotVersionable = VersioningTest.getNotVersionableDocType(allDocs);
        }
        if (documentTypeVersionable == null) {
            documentTypeVersionable = VersioningTest.getVersionableDocType(allDocs);
        }
        System.out.println("Running Versioning Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            VersioningTest.clear(testRootFolderId);
        }
    }

    @Test
    public void testCheckOut() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        String pwc = connection.checkout(document);
        CmisObject pwcObject = null;
        try {
            pwcObject = connection.getObject(pwc, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        }
        catch (ObjectNotFoundException e) {
            Assert.fail((String)"PWC not found. ");
        }
        Assert.assertNotNull(pwcObject);
        this.validateVersionSeries(pwcObject.getObjectInfo().getVersionSeriesId(), document, pwc);
        this.validateCheckedOutState(document, pwc);
        this.validateCheckedOutState(pwc, pwc);
    }

    @Test
    public void testCheckOut_ConstraintException() throws Exception {
        if (documentTypeNotVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeNotVersionable.getId(), VersioningTest.generateName(documentTypeNotVersionable, null), null, null, null, null, null);
        try {
            connection.checkout(document);
            Assert.fail((String)"ConstraintException must be thrown since document type is not versionable. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testCancelCheckOut_PWC() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        connection.cancelCheckout(pwc);
        this.validateVersionSeries(vs, document);
        this.validateCheckedInState(document);
        try {
            connection.getObject(pwc, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            Assert.fail((String)"PWC must be removed. ");
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void testCancelCheckOut_Document() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        connection.cancelCheckout(document);
        this.validateVersionSeries(vs, document);
        this.validateCheckedInState(document);
        try {
            connection.getObject(pwc, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            Assert.fail((String)"PWC must be removed. ");
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void testCancelCheckOut_ConstraintException() throws Exception {
        if (documentTypeNotVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeNotVersionable.getId(), VersioningTest.generateName(documentTypeNotVersionable, null), null, null, null, null, null);
        try {
            connection.cancelCheckout(document);
            Assert.fail((String)"ConstraintException must be thrown since document type is not versionable. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckIn() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", null, null, null);
        this.validateVersionSeries(vs, document, v1);
        this.validateCheckedInState(document);
    }

    @Test
    public void testCheckIn_ApplyACL() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        List<AccessControlEntry> acl = VersioningTest.createACL(this.principal, "cmis:all");
        if (capabilities.getCapabilityACL() != CapabilityACL.MANAGE) {
            try {
                connection.checkin(pwc, true, null, null, "testCheckIn", acl, null, null);
                Assert.fail((String)"NotSupportedException must be thrown, managin ACL is not supported. ");
            }
            catch (NotSupportedException e) {}
        } else if (!documentTypeVersionable.isControllableACL()) {
            try {
                connection.checkin(pwc, true, null, null, "testCheckIn", acl, null, null);
                Assert.fail((String)"ConstraintException must be thrown, type is not controllable by ACL. ");
            }
            catch (ConstraintException e) {}
        } else {
            String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", acl, null, null);
            this.validateVersionSeries(vs, document, v1);
            this.validateCheckedInState(document);
            List actualACL = connection.getACL(v1, false);
            this.validateACL(actualACL);
            this.checkACL(acl, actualACL);
        }
    }

    @Test
    public void testCheckIn_ApplyPolicy() throws Exception {
        if (documentTypeVersionable == null || !isPoliciesSupported) {
            return;
        }
        TypeDefinition policyType = connection.getTypeDefinition("cmis:policy");
        String policy = VersioningTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), VersioningTest.generateName(policyType, null), "policy1", null, null, null);
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        if (!documentTypeVersionable.isControllablePolicy()) {
            try {
                connection.checkin(pwc, true, null, null, "testCheckIn", null, null, Arrays.asList(policy));
                Assert.fail((String)"ConstraintException must be thrown, type is not controllable by policy. ");
            }
            catch (ConstraintException e) {}
        } else {
            String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", null, null, Arrays.asList(policy));
            this.validateVersionSeries(vs, document, v1);
            this.validateCheckedInState(document);
            List policies = connection.getAppliedPolicies(v1, true, null);
            Assert.assertTrue((policies.size() >= 1 ? 1 : 0) != 0);
            HashSet<String> policiesId = new HashSet<String>(policies.size());
            for (CmisObject o : policies) {
                policiesId.add(o.getObjectInfo().getId());
            }
            Assert.assertTrue((String)"Expected policy is not found. ", (boolean)policiesId.contains(policy));
        }
    }

    @Test
    public void testCheckIn_UpdateContent() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        if (documentTypeVersionable.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED) {
            try {
                connection.checkin(pwc, true, null, TEST_CONTENT_STREAM, "testCheckIn", null, null, null);
                Assert.fail((String)"ConstraintException must be thrown, content stream is not allowed. ");
            }
            catch (StreamNotSupportedException e) {}
        } else {
            byte[] newContent = "__CONTENT__".getBytes();
            String v1 = connection.checkin(pwc, true, null, (ContentStream)new BaseContentStream(newContent, "", new MimeType("text", "plain")), "testCheckIn", null, null, null);
            this.validateVersionSeries(vs, document, v1);
            this.validateCheckedInState(document);
            ContentStream content = connection.getContentStream(v1, null);
            Assert.assertEquals((Object)content.getMediaType(), (Object)content.getMediaType());
            byte[] buf = new byte[1024];
            int read = content.getStream().read(buf);
            byte[] res = new byte[read];
            System.arraycopy(buf, 0, res, 0, read);
            Assert.assertArrayEquals((byte[])newContent, (byte[])res);
        }
    }

    @Test
    public void testGetObjectOfLatestVersion() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", null, null, null);
        pwc = connection.checkout(v1);
        String v2 = connection.checkin(pwc, true, null, null, "testCheckIn", null, null, null);
        CmisObject latest = connection.getObjectOfLatestVersion(vs, false, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        Assert.assertNotNull((Object)latest);
        Assert.assertEquals((Object)v2, (Object)latest.getObjectInfo().getId());
        Assert.assertNull((Object)latest.getAllowableActions());
        Assert.assertEquals((long)0L, (long)latest.getPolicyIds().size());
        Assert.assertEquals((long)0L, (long)latest.getRelationship().size());
        Assert.assertEquals((long)0L, (long)latest.getRenditions().size());
    }

    @Test
    public void testGetObjectOfLatestVersion_AllowableActions() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", null, null, null);
        CmisObject latest = connection.getObjectOfLatestVersion(vs, false, true, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        Assert.assertNotNull((Object)latest);
        Assert.assertEquals((Object)v1, (Object)latest.getObjectInfo().getId());
        Assert.assertNotNull((Object)latest.getAllowableActions());
    }

    @Test
    public void testGetObjectOfLatestVersion_IncludePolicies() throws Exception {
        if (documentTypeVersionable == null || !isPoliciesSupported || !documentTypeVersionable.isControllablePolicy()) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        TypeDefinition policyType = connection.getTypeDefinition("cmis:policy");
        String policy = VersioningTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), VersioningTest.generateName(policyType, null), "policy1", null, null, null);
        String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", null, null, Arrays.asList(policy));
        CmisObject latest = connection.getObjectOfLatestVersion(vs, false, false, IncludeRelationships.NONE, true, false, true, null, "cmis:none");
        Assert.assertNotNull((Object)latest);
        Assert.assertEquals((Object)v1, (Object)latest.getObjectInfo().getId());
        Assert.assertTrue((latest.getPolicyIds().size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected policy " + policy + " not found in result. "), (boolean)latest.getPolicyIds().contains(policy));
    }

    @Test
    public void testGetObjectOfLatestVersion_IncludeACL() throws Exception {
        if (documentTypeVersionable == null || capabilities.getCapabilityACL() != CapabilityACL.MANAGE || !documentTypeVersionable.isControllableACL()) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        List<AccessControlEntry> acl = VersioningTest.createACL(this.principal, "cmis:all");
        String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", acl, null, null);
        CmisObject latest = connection.getObjectOfLatestVersion(vs, false, false, IncludeRelationships.NONE, false, true, true, null, "cmis:none");
        Assert.assertNotNull((Object)latest);
        Assert.assertEquals((Object)v1, (Object)latest.getObjectInfo().getId());
        List actualACL = latest.getACL();
        this.validateACL(actualACL);
        this.checkACL(acl, actualACL);
    }

    @Test
    public void testGetObjectOfLatestVersion_Major() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, null);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        String v1 = connection.checkin(pwc, true, null, null, "testCheckIn", null, null, null);
        pwc = connection.checkout(v1);
        String v2 = connection.checkin(pwc, false, null, null, "testCheckIn", null, null, null);
        CmisObject latest = connection.getObjectOfLatestVersion(vs, true, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        Assert.assertNotNull((Object)latest);
        Assert.assertEquals((Object)v1, (Object)latest.getObjectInfo().getId());
    }

    @Test
    public void testGetObjectOfLatestVersion_Major_ObjectNotFoundException() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        String document = VersioningTest.createDocument(testRootFolderId, documentTypeVersionable.getId(), VersioningTest.generateName(documentTypeVersionable, null), null, null, null, null, VersioningState.MINOR);
        CmisObject documentObject = connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        String vs = documentObject.getObjectInfo().getVersionSeriesId();
        String pwc = connection.checkout(document);
        String v1 = connection.checkin(pwc, false, null, null, "testCheckIn", null, null, null);
        pwc = connection.checkout(v1);
        String v2 = connection.checkin(pwc, false, null, null, "testCheckIn", null, null, null);
        try {
            connection.getObjectOfLatestVersion(vs, true, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            Assert.fail((String)"ObjectNotFoundException must be thrown, there is not major versions in version series.");
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
    }

    private void validateCheckedOutState(String d, String pwc) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("cmis:isVersionSeriesCheckedOut");
        b.append("cmis:versionSeriesCheckedOutId");
        CmisObject object = connection.getProperties(d, true, b.toString());
        for (Map.Entry p : object.getProperties().entrySet()) {
            if (((String)p.getKey()).equals("cmis:isVersionSeriesCheckedOut")) {
                Boolean checkedout = (Boolean)((Property)p.getValue()).getValues().get(0);
                Assert.assertTrue((boolean)checkedout);
            }
            if (!((String)p.getKey()).equals("cmis:versionSeriesCheckedOutId")) continue;
            String pwc0 = (String)((Property)p.getValue()).getValues().get(0);
            Assert.assertEquals((Object)pwc, (Object)pwc0);
        }
    }

    private void validateCheckedInState(String d) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("cmis:isVersionSeriesCheckedOut");
        b.append("cmis:versionSeriesCheckedOutId");
        CmisObject object = connection.getProperties(d, true, b.toString());
        for (Map.Entry p : object.getProperties().entrySet()) {
            if (((String)p.getKey()).equals("cmis:isVersionSeriesCheckedOut")) {
                Boolean checkedout = (Boolean)((Property)p.getValue()).getValues().get(0);
                Assert.assertFalse((boolean)checkedout);
            }
            if (!((String)p.getKey()).equals("cmis:versionSeriesCheckedOutId")) continue;
            Assert.assertTrue((String)"cmis:versionSeriesCheckedOutId must not be set. ", (boolean)((Property)p.getValue()).getValues().isEmpty());
        }
    }

    private void validateVersionSeries(String vs, String ... exp) throws Exception {
        List versions = connection.getAllVersions(vs, false, true, null);
        Assert.assertEquals((long)exp.length, (long)versions.size());
        HashSet<String> ids = new HashSet<String>(versions.size());
        for (CmisObject v : versions) {
            Assert.assertEquals((Object)vs, (Object)v.getObjectInfo().getVersionSeriesId());
            ids.add(v.getObjectInfo().getId());
        }
        for (String v : exp) {
            Assert.assertTrue((String)("Expected version " + v + "not found in version series."), (boolean)ids.contains(v));
        }
    }
}

