/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.xcmis.spi.model;

/**
 * Describe CMIS object parent.
 *
 * @author <a href="mailto:alexey.zavizionov@exoplatform.com">Alexey
 *         Zavizionov</a>
 * @version $Id: CmisObjectParents.java 34360 2009-07-22 23:58:59Z sunman $
 */
public final class ObjectParent
{

   private CmisObject parent;

   private String relativePathSegment;

   public ObjectParent(CmisObject parent, String relativePathSegment)
   {
      this.parent = parent;
      this.relativePathSegment = relativePathSegment;
   }

   /**
    * @return object's parent
    */
   public CmisObject getObject()
   {
      return parent;
   }

   /**
    * @return relative path segment of the object for which parent was requested
    */
   public String getRelativePathSegment()
   {
      return relativePathSegment;
   }
}
