/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl.server;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.wssoap.impl.server.WebServiceLoader;

public class CmisSoapServletExt
extends CXFNonSpringServlet {
    private static final long serialVersionUID = -8056126542859194574L;
    private static final Log LOG = ExoLogger.getLogger(CmisSoapServletExt.class);
    protected ServletConfig config;
    protected String servletContextName;
    private volatile Boolean requirePortalEnvironment;

    public final void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.servletContextName = config.getServletContext().getServletContextName();
        super.init(config);
        this.afterInit(config);
    }

    protected void afterInit(ServletConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBus(ServletConfig servletConfig) throws ServletException {
        super.loadBus(servletConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"loadBus method entering");
        }
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ExoContainer container = null;
        boolean hasBeenSet = false;
        try {
            container = this.getContainer();
            if (!container.equals(oldContainer)) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance((PortalContainer)((PortalContainer)container));
                }
                ExoContainerContext.setCurrentContainer((ExoContainer)container);
                hasBeenSet = true;
            }
            if (this.requirePortalEnvironment() && container instanceof PortalContainer) {
                if (PortalContainer.getInstanceIfPresent() == null) {
                    PortalContainer.setInstance((PortalContainer)((PortalContainer)container));
                    hasBeenSet = true;
                }
                Thread.currentThread().setContextClassLoader(((PortalContainer)container).getPortalClassLoader());
            }
            this.onService(container);
        }
        finally {
            if (hasBeenSet) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance(null);
                }
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
            }
            if (this.requirePortalEnvironment()) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    protected void onService(ExoContainer container) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SOAPServlet.onService() container = " + container));
        }
        WebServiceLoader loader = (WebServiceLoader)container.getComponentInstance(WebServiceLoader.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SOAPServlet.onService() loader = " + loader));
        }
        loader.init();
        Bus bus = this.getBus();
        BusFactory.setDefaultBus((Bus)bus);
    }

    protected final ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer && (container = PortalContainer.getCurrentInstance((ServletContext)this.config.getServletContext())) == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requirePortalEnvironment() {
        if (this.requirePortalEnvironment == null) {
            CmisSoapServletExt cmisSoapServletExt = this;
            synchronized (cmisSoapServletExt) {
                if (this.requirePortalEnvironment == null) {
                    this.requirePortalEnvironment = PortalContainer.isPortalContainerName((String)this.servletContextName);
                }
            }
        }
        return this.requirePortalEnvironment;
    }
}

