/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.util.List;
import javax.jws.WebService;
import org.xcmis.core.CmisAccessControlListType;
import org.xcmis.core.EnumACLPropagation;
import org.xcmis.messaging.CmisACLType;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.soap.ACLServicePort;
import org.xcmis.soap.CmisException;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.model.AccessControlPropagation;
import org.xcmis.spi.utils.Logger;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

@WebService(serviceName="ACLService", portName="AccessControlServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class ACLServicePortImpl
implements ACLServicePort {
    private static final Logger LOG = Logger.getLogger(ACLServicePortImpl.class);

    public CmisACLType applyACL(String repositoryId, String objectId, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, EnumACLPropagation aclPropagation, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation applyACL");
        }
        Connection conn = null;
        try {
            CmisACLType res;
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.applyACL(objectId, TypeConverter.getAccessControlEntryList(addACEs.getPermission()), TypeConverter.getAccessControlEntryList(removeACEs.getPermission()), aclPropagation == null ? AccessControlPropagation.REPOSITORYDETERMINED : AccessControlPropagation.fromValue((String)aclPropagation.value()));
            CmisACLType cmisACLType = res = new CmisACLType();
            return cmisACLType;
        }
        catch (Exception e) {
            LOG.error("Apply ACL error: " + e.getMessage());
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public CmisACLType getACL(String repositoryId, String objectId, Boolean onlyBasicPermissions, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getACL");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List list = conn.getACL(objectId, onlyBasicPermissions == null ? true : onlyBasicPermissions);
            CmisAccessControlListType type = TypeConverter.getCmisAccessControlListType(list);
            CmisACLType res = new CmisACLType();
            res.setACL(type);
            CmisACLType cmisACLType = res;
            return cmisACLType;
        }
        catch (Exception e) {
            LOG.error("Get ACL error: " + e.getMessage());
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

