/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.xcmis.core.CmisObjectType;
import org.xcmis.core.EnumIncludeRelationships;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.messaging.CmisObjectInFolderContainerType;
import org.xcmis.messaging.CmisObjectInFolderListType;
import org.xcmis.messaging.CmisObjectListType;
import org.xcmis.messaging.CmisObjectParentsType;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.NavigationServicePort;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.ObjectParent;
import org.xcmis.spi.utils.Logger;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="NavigationService", portName="NavigationServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class NavigationServicePortImpl
implements NavigationServicePort {
    private static final Logger LOG = Logger.getLogger(NavigationServicePortImpl.class);

    @Override
    public CmisObjectListType getCheckedOutDocs(String repositoryId, String folderId, String propertyFilter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getCheckedoutDocs");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisObjectListType cmisObjectListType = TypeConverter.getCmisObjectListType((ItemsList<CmisObject>)conn.getCheckedOutDocs(folderId, includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), false, propertyFilter, renditionFilter, orderBy, maxItems == null ? Integer.MAX_VALUE : maxItems.intValue(), skipCount == null ? 0 : skipCount.intValue()));
            return cmisObjectListType;
        }
        catch (Exception e) {
            LOG.error("Get checked-out documents error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisObjectInFolderListType getChildren(String repositoryId, String folderId, String propertyFilter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getChildren");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisObjectInFolderListType cmisObjectInFolderListType = TypeConverter.getCmisObjectInFolderListType(conn.getChildren(folderId, includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), includePathSegments == null ? false : includePathSegments, false, propertyFilter, renditionFilter, orderBy, maxItems == null ? Integer.MAX_VALUE : maxItems.intValue(), skipCount == null ? 0 : skipCount.intValue()));
            return cmisObjectInFolderListType;
        }
        catch (Exception e) {
            LOG.error("Get children error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public List<CmisObjectInFolderContainerType> getDescendants(String repositoryId, String folderId, BigInteger depth, String propertyFilter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getDescendants");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List<CmisObjectInFolderContainerType> list = TypeConverter.getCmisObjectInFolderContainerTypeList(conn.getDescendants(folderId, depth == null ? 1 : depth.intValue(), includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), includePathSegments == null ? false : includePathSegments, false, propertyFilter, renditionFilter));
            return list;
        }
        catch (Exception e) {
            LOG.error("Get descendants error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisObjectType getFolderParent(String repositoryId, String folderId, String propertyFilter, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getFolderParent");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisObjectType cmisObjectType = TypeConverter.getCmisObjectType(conn.getFolderParent(folderId, false, propertyFilter));
            return cmisObjectType;
        }
        catch (Exception e) {
            LOG.error("Get folder parent error: " + e.getMessage());
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public List<CmisObjectInFolderContainerType> getFolderTree(String repositoryId, String folderId, BigInteger depth, String propertyFilter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getFolderTree");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List<CmisObjectInFolderContainerType> list = TypeConverter.getCmisObjectInFolderContainerTypeList(conn.getFolderTree(folderId, depth == null ? 1 : depth.intValue(), includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), includePathSegments == null ? false : includePathSegments, false, propertyFilter, renditionFilter));
            return list;
        }
        catch (Exception e) {
            LOG.error("Get folder tree error: " + e.getMessage());
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public List<CmisObjectParentsType> getObjectParents(String repositoryId, String objectId, String propertyFilter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getObjectParents");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            ArrayList<CmisObjectParentsType> res = new ArrayList<CmisObjectParentsType>();
            List out = conn.getObjectParents(objectId, includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), includeRelativePathSegment == null ? true : includeRelativePathSegment, false, propertyFilter, renditionFilter);
            for (ObjectParent one : out) {
                res.add(TypeConverter.getCmisObjectParentsType(one));
            }
            ArrayList<CmisObjectParentsType> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error("Get object parents error: " + e.getMessage());
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

