/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.math.BigInteger;
import javax.jws.WebService;
import org.xcmis.core.EnumRelationshipDirection;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.messaging.CmisObjectListType;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.RelationshipServicePort;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.utils.Logger;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

@WebService(serviceName="RelationshipService", portName="RelationshipServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class RelationshipServicePortImpl
implements RelationshipServicePort {
    private static final Logger LOG = Logger.getLogger(RelationshipServicePortImpl.class);

    public CmisObjectListType getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, EnumRelationshipDirection relationshipDirection, String typeId, String propertyFilter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getRelationships");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisObjectListType cmisObjectListType = TypeConverter.getCmisObjectListType(conn.getObjectRelationships(objectId, relationshipDirection == null ? RelationshipDirection.SOURCE : RelationshipDirection.fromValue((String)relationshipDirection.value()), typeId, includeSubRelationshipTypes == null ? false : includeSubRelationshipTypes, includeAllowableActions == null ? false : includeAllowableActions, false, propertyFilter, maxItems == null ? Integer.MAX_VALUE : maxItems.intValue(), skipCount == null ? 0 : skipCount.intValue()).getItems());
            return cmisObjectListType;
        }
        catch (Exception e) {
            LOG.error("Get relationships error : " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

