/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.xcmis.core.CmisAccessControlListType;
import org.xcmis.core.CmisObjectType;
import org.xcmis.core.CmisPropertiesType;
import org.xcmis.core.EnumIncludeRelationships;
import org.xcmis.messaging.CmisContentStreamType;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.VersioningServicePort;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.utils.Logger;
import org.xcmis.spi.utils.MimeType;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="VersioningService", portName="VersioningServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class VersioningServicePortImpl
implements VersioningServicePort {
    private static final Logger LOG = Logger.getLogger(VersioningServicePortImpl.class);

    @Override
    public CmisExtensionType cancelCheckOut(String repositoryId, String documentId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation cancelCheckOut");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.cancelCheckout(documentId);
            CmisExtensionType cmisExtensionType = new CmisExtensionType();
            return cmisExtensionType;
        }
        catch (Exception e) {
            LOG.error("Cancel checkout error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void checkIn(String repositoryId, Holder<String> documentId, Boolean major, CmisPropertiesType properties, CmisContentStreamType contentStream, String checkinComment, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation checkIn");
        }
        Connection conn = null;
        BaseContentStream cs = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            if (contentStream != null) {
                cs = new BaseContentStream(contentStream.getStream().getInputStream(), contentStream.getFilename(), MimeType.fromString((String)contentStream.getMimeType()));
            }
            String res = conn.checkin((String)documentId.value, major == null ? true : major, TypeConverter.getPropertyMap(properties), (ContentStream)cs, checkinComment, TypeConverter.getListAccessControlEntry(addACEs), TypeConverter.getListAccessControlEntry(removeACEs), policies);
            documentId.value = res;
            CmisExtensionType ext = new CmisExtensionType();
            extension.value = ext;
        }
        catch (Exception e) {
            LOG.error("CheckIn error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void checkOut(String repositoryId, Holder<String> documentId, Holder<CmisExtensionType> extension, Holder<Boolean> contentCopied) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation checkOut");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            String res = conn.checkout((String)documentId.value);
            documentId.value = res;
            CmisExtensionType ext = new CmisExtensionType();
            extension.value = ext;
            contentCopied.value = true;
        }
        catch (Exception e) {
            LOG.error("Checkout error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public List<CmisObjectType> getAllVersions(String repositoryId, String versionSeriesId, String propertyFilter, Boolean includeAllowableActions, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getAllVersions");
        }
        Connection conn = null;
        ArrayList<CmisObjectType> res = new ArrayList<CmisObjectType>();
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List list = conn.getAllVersions(versionSeriesId, includeAllowableActions == null ? false : includeAllowableActions, false, propertyFilter);
            for (CmisObject one : list) {
                res.add(TypeConverter.getCmisObjectType(one));
            }
        }
        catch (Exception e) {
            LOG.error("Get all versions error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return res;
    }

    @Override
    public CmisObjectType getObjectOfLatestVersion(String repositoryId, String versionSeriesId, Boolean major, String propertyFilter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, CmisExtensionType extension) throws CmisException {
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisObjectType cmisObjectType = TypeConverter.getCmisObjectType(conn.getObjectOfLatestVersion(versionSeriesId, major == null ? false : major, includeAllowableActions == null ? false : includeAllowableActions, includeRelationships == null ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)includeRelationships.value()), includePolicyIds == null ? false : includePolicyIds, includeACL == null ? false : includeACL, false, propertyFilter, renditionFilter));
            return cmisObjectType;
        }
        catch (Exception e) {
            LOG.error("Get object of latest version error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisPropertiesType getPropertiesOfLatestVersion(String repositoryId, String objectId, Boolean major, String filter, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getPropertiesOfLatestVersion");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            CmisPropertiesType cmisPropertiesType = TypeConverter.getCmisPropertiesType(conn.getPropertiesOfLatestVersion(objectId, major == null ? false : major, false, filter));
            return cmisPropertiesType;
        }
        catch (Exception e) {
            LOG.error("Get properties of latest version error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

