/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.MarginBoxName;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.RulesetContainer;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;

public class PageRule
implements RulesetContainer {
    private String _name;
    private String _pseudoPage;
    private Ruleset _ruleset;
    private final StylesheetInfo.Origin _origin;
    private final Map<MarginBoxName, List<PropertyDeclaration>> _marginBoxes = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
    private int _pos;
    private int _specificityF;
    private int _specificityG;
    private int _specificityH;

    public PageRule(StylesheetInfo.Origin origin) {
        this._origin = origin;
    }

    public String getPseudoPage() {
        return this._pseudoPage;
    }

    public void setPseudoPage(String pseudoPage) {
        this._pseudoPage = pseudoPage;
        if (pseudoPage.equals("first")) {
            this._specificityG = 1;
        } else {
            this._specificityH = 1;
        }
    }

    public Ruleset getRuleset() {
        return this._ruleset;
    }

    public void setRuleset(Ruleset ruleset) {
        this._ruleset = ruleset;
    }

    @Override
    public void addContent(Ruleset ruleset) {
        if (this._ruleset != null) {
            throw new IllegalStateException("Ruleset has already been set");
        }
        this._ruleset = ruleset;
    }

    @Override
    public StylesheetInfo.Origin getOrigin() {
        return this._origin;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        this._specificityF = 1;
    }

    public List<PropertyDeclaration> getMarginBoxProperties(MarginBoxName name) {
        return this._marginBoxes.get(name);
    }

    public void addMarginBoxProperties(MarginBoxName name, List<PropertyDeclaration> props) {
        this._marginBoxes.put(name, props);
    }

    public Map<MarginBoxName, List<PropertyDeclaration>> getMarginBoxes() {
        return this._marginBoxes;
    }

    public long getOrder() {
        long result = 0L;
        result |= (long)this._specificityF << 32;
        result |= (long)this._specificityG << 24;
        result |= (long)this._specificityH << 16;
        return result |= (long)this._pos;
    }

    public boolean applies(@Nullable String pageName, String pseudoPage) {
        if (this._name == null && this._pseudoPage == null) {
            return true;
        }
        if (this._name == null && (this._pseudoPage.equals(pseudoPage) || this._pseudoPage.equals("right") && pseudoPage != null && pseudoPage.equals("first"))) {
            return true;
        }
        if (this._name != null && this._name.equals(pageName) && this._pseudoPage == null) {
            return true;
        }
        return this._name != null && this._name.equals(pageName) && this._pseudoPage.equals(pseudoPage);
    }

    public int getPos() {
        return this._pos;
    }

    public void setPos(int pos) {
        this._pos = pos;
    }
}

