/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml;

import java.util.ArrayList;
import java.util.List;
import org.xhtmlrenderer.simple.extend.URLUTF8Encoder;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormListener;

public class XhtmlForm {
    private final String _action;
    private final String _method;
    private final List<FormControl> _controls = new ArrayList<FormControl>();
    private final List<FormListener> _listeners = new ArrayList<FormListener>();

    public XhtmlForm(String action, String method) {
        this._action = action;
        this._method = method;
    }

    public void addFormListener(FormListener listener) {
        this._listeners.add(listener);
    }

    public List<FormControl> getAllControls(String name) {
        ArrayList<FormControl> result = new ArrayList<FormControl>();
        for (FormControl control : this._controls) {
            if (!control.getName().equals(name)) continue;
            result.add(control);
        }
        return result;
    }

    public Iterable<FormControl> controls() {
        return this._controls;
    }

    public void reset() {
        for (FormListener listener : this._listeners) {
            listener.resetted(this);
        }
    }

    public void submit() {
        StringBuilder data = new StringBuilder();
        for (FormControl control : this._controls) {
            if (!control.isSuccessful()) continue;
            if (control.isMultiple()) {
                String[] values;
                for (String value : values = control.getMultipleValues()) {
                    if (!data.isEmpty()) {
                        data.append('&');
                    }
                    data.append(URLUTF8Encoder.encode(control.getName()));
                    data.append('=');
                    data.append(URLUTF8Encoder.encode(value));
                }
                continue;
            }
            if (!data.isEmpty()) {
                data.append('&');
            }
            data.append(URLUTF8Encoder.encode(control.getName()));
            data.append('=');
            data.append(URLUTF8Encoder.encode(control.getValue()));
        }
        System.out.println("Form submitted!");
        System.out.println("Action: " + this._action);
        System.out.println("Method: " + this._method);
        System.out.println("Data: " + data);
        for (FormListener listener : this._listeners) {
            listener.submitted(this);
        }
    }
}

