/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Objects;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.HSBColor;

public class FSRGBColor
implements FSColor {
    public static final FSRGBColor TRANSPARENT = new FSRGBColor(0, 0, 0);
    public static final FSRGBColor RED = new FSRGBColor(255, 0, 0);
    public static final FSRGBColor GREEN = new FSRGBColor(0, 255, 0);
    public static final FSRGBColor BLUE = new FSRGBColor(0, 0, 255);
    private final int _red;
    private final int _green;
    private final int _blue;

    public FSRGBColor(int red, int green, int blue) {
        this._red = this.validateColor("Red", red);
        this._green = this.validateColor("Green", green);
        this._blue = this.validateColor("Blue", blue);
    }

    private int validateColor(String name, int color) {
        if (color < 0 || color > 255) {
            throw new IllegalArgumentException(String.format("%s %s is out of range [0, 255]", name, color));
        }
        return color;
    }

    public FSRGBColor(int color) {
        this((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
    }

    public int getBlue() {
        return this._blue;
    }

    public int getGreen() {
        return this._green;
    }

    public int getRed() {
        return this._red;
    }

    public String toString() {
        return "#" + this.toString(this._red) + this.toString(this._green) + this.toString(this._blue);
    }

    private String toString(int color) {
        String result = Integer.toHexString(color);
        if (result.length() == 1) {
            return "0" + result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FSRGBColor)) {
            return false;
        }
        FSRGBColor that = (FSRGBColor)o;
        return this._blue == that._blue && this._green == that._green && this._red == that._red;
    }

    public int hashCode() {
        return Objects.hash(this._red, this._green, this._blue);
    }

    @Override
    @CheckReturnValue
    public FSColor lightenColor() {
        HSBColor hsb = this.toHSB();
        float sLighter = 0.35f * hsb.brightness() * hsb.saturation();
        float bLighter = 0.6999f + 0.3f * hsb.brightness();
        return new HSBColor(hsb.hue(), sLighter, bLighter).toRGB();
    }

    @Override
    @CheckReturnValue
    public FSColor darkenColor() {
        HSBColor hsb = this.toHSB();
        float hBase = hsb.hue();
        float sBase = hsb.saturation();
        float bBase = hsb.brightness();
        float bDarker = 0.56f * bBase;
        return new HSBColor(hBase, sBase, bDarker).toRGB();
    }

    private HSBColor toHSB() {
        return FSRGBColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue());
    }

    private static HSBColor RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        int cmax = Math.max(r, g);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new HSBColor(hue, saturation, brightness);
    }
}

