/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.util.Iterator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlbeam.DomChangeTracker;
import org.xmlbeam.dom.DOMAccess;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.types.XBAutoValue;
import org.xmlbeam.util.intern.DOMHelper;

class AutoValue<E>
implements XBAutoValue<E> {
    private final InvocationContext invocationContext;
    private Node dataNode;
    private Node baseNode = null;
    private final DomChangeTracker domChangeTracker = new DomChangeTracker(){

        @Override
        void refresh(boolean forWrite) throws XPathExpressionException {
            NodeList nodes = (NodeList)AutoValue.this.invocationContext.getxPathExpression().evaluate(AutoValue.this.baseNode, XPathConstants.NODESET);
            if (nodes.getLength() == 0 && forWrite) {
                AutoValue.this.dataNode = AutoValue.this.invocationContext.getDuplexExpression().ensureExistence(AutoValue.this.baseNode);
                return;
            }
            AutoValue.this.dataNode = nodes.getLength() == 0 ? null : nodes.item(0);
        }
    };

    public AutoValue(Node baseNode, InvocationContext invocationContext) {
        this.baseNode = baseNode;
        this.invocationContext = invocationContext;
        invocationContext.getProjector().addDOMChangeListener(this.domChangeTracker);
    }

    @Override
    public E get() {
        this.domChangeTracker.refreshForReadIfNeeded();
        if (this.dataNode == null) {
            return null;
        }
        return DefaultXPathEvaluator.convertToComponentType(this.invocationContext, this.dataNode, this.invocationContext.getTargetComponentType());
    }

    @Override
    public E set(E element) {
        if (this.dataNode == null) {
            this.domChangeTracker.domChanged();
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        Node prevNode = this.dataNode;
        Object result = DefaultXPathEvaluator.convertToComponentType(this.invocationContext, prevNode, this.invocationContext.getTargetComponentType());
        Node oldNode = this.dataNode;
        this.domChangeTracker.domChanged();
        this.domChangeTracker.refreshForWriteIfNeeded();
        if (element instanceof Node) {
            Node newNode = ((Node)element).cloneNode(true);
            oldNode.getParentNode().replaceChild(oldNode, newNode);
            this.dataNode = newNode;
            return result;
        }
        if (element instanceof DOMAccess) {
            Node newNode = ((DOMAccess)element).getDOMBaseElement().cloneNode(true);
            oldNode.getParentNode().replaceChild(oldNode, newNode);
            this.dataNode = newNode;
            return result;
        }
        String asString = this.invocationContext.getProjector().config().getStringRenderer().render(element.getClass(), element, this.invocationContext.getDuplexExpression().getExpressionFormatPattern());
        this.dataNode.setTextContent(asString);
        return result;
    }

    @Override
    public E remove() {
        E oldValue = this.get();
        if (this.dataNode == null) {
            return oldValue;
        }
        if (this.dataNode.getNodeType() == 2) {
            DOMHelper.removeAttribute((Attr)this.dataNode);
            this.dataNode = null;
            return oldValue;
        }
        if (this.dataNode.getParentNode() == null) {
            return oldValue;
        }
        DOMHelper.trim(this.dataNode);
        this.dataNode.getParentNode().removeChild(this.dataNode);
        this.dataNode = null;
        return oldValue;
    }

    @Override
    public boolean isPresent() {
        this.domChangeTracker.refreshForReadIfNeeded();
        return this.dataNode != null;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            boolean read;
            {
                this.read = !AutoValue.this.isPresent();
            }

            @Override
            public boolean hasNext() {
                return !this.read && AutoValue.this.isPresent();
            }

            @Override
            public E next() {
                if (this.read) {
                    throw new IllegalStateException();
                }
                this.read = true;
                return AutoValue.this.get();
            }

            @Override
            public void remove() {
                if (!this.read || !AutoValue.this.isPresent()) {
                    throw new IllegalStateException();
                }
                AutoValue.this.remove();
            }
        };
    }

    @Override
    public XBAutoValue<E> rename(String newName) {
        this.domChangeTracker.domChanged();
        this.domChangeTracker.refreshForWriteIfNeeded();
        if (this.dataNode == null) {
            throw new IllegalStateException("Can not rename when no value is present.");
        }
        this.dataNode = DOMHelper.renameNode(this.dataNode, newName);
        this.domChangeTracker.domChanged();
        return this;
    }

    @Override
    public String getName() {
        this.domChangeTracker.refreshForReadIfNeeded();
        if (this.dataNode == null) {
            throw new IllegalStateException("No value is present.");
        }
        return this.dataNode.getNodeName();
    }

    Node getNode() {
        this.domChangeTracker.refreshForReadIfNeeded();
        return this.dataNode;
    }

    public boolean equals(Object o) {
        if (!this.isPresent()) {
            return false;
        }
        E e = this.get();
        if (e == null) {
            return false;
        }
        return e.equals(o);
    }

    public int hashCode() {
        if (!this.isPresent()) {
            return 0;
        }
        E e = this.get();
        if (e == null) {
            return 0;
        }
        return this.get().hashCode();
    }

    @Override
    public E getOrDefault(E defaultValue) {
        return this.isPresent() ? this.get() : defaultValue;
    }
}

