/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.util;

import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.cache.Cache;
import org.xwiki.cache.DisposableCacheValue;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;

public abstract class AbstractCache<T>
implements Cache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCache.class);
    protected final CacheConfiguration configuration;
    protected final EventListenerList cacheEntryListeners = new EventListenerList();

    @Deprecated
    public AbstractCache() {
        this(null);
    }

    public AbstractCache(CacheConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void dispose() {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            this.cacheEntryListeners.remove(CacheEntryListener.class, listener);
        }
    }

    @Override
    public void addCacheEntryListener(CacheEntryListener<T> listener) {
        this.cacheEntryListeners.add(CacheEntryListener.class, listener);
    }

    @Override
    public void removeCacheEntryListener(CacheEntryListener<T> listener) {
        this.cacheEntryListeners.remove(CacheEntryListener.class, listener);
    }

    protected void sendEntryAddedEvent(CacheEntryEvent<T> event) {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            listener.cacheEntryAdded(event);
        }
    }

    protected void sendEntryRemovedEvent(CacheEntryEvent<T> event) {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            listener.cacheEntryRemoved(event);
        }
        this.disposeCacheValue(event.getEntry().getValue());
    }

    protected void sendEntryModifiedEvent(CacheEntryEvent<T> event) {
        for (CacheEntryListener listener : (CacheEntryListener[])this.cacheEntryListeners.getListeners(CacheEntryListener.class)) {
            listener.cacheEntryModified(event);
        }
    }

    protected void disposeCacheValue(T value) {
        if (value instanceof DisposableCacheValue) {
            try {
                ((DisposableCacheValue)value).dispose();
            }
            catch (Throwable e) {
                LOGGER.warn("Error when trying to dispose a cache object of cache [{}]", (Object)(this.configuration != null ? this.configuration.getConfigurationId() : null), (Object)e);
            }
        }
    }
}

