/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Collection<Field> getAllFields(Class<?> componentClass) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Class<?> targetClass = componentClass; targetClass != null; targetClass = targetClass.getSuperclass()) {
            Field[] componentClassFields;
            try {
                componentClassFields = targetClass.getDeclaredFields();
            }
            catch (NoClassDefFoundError e) {
                throw new NoClassDefFoundError("Failed to get fields for class [" + targetClass.getName() + "] because the class [" + e.getMessage() + "] couldn't be found in the ClassLoader.");
            }
            for (Field field : componentClassFields) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object instanceContainingField, String fieldName, Object fieldValue) {
        for (Class<?> targetClass = instanceContainingField.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                try {
                    boolean isAccessible = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        field.set(instanceContainingField, fieldValue);
                    }
                    finally {
                        field.setAccessible(isAccessible);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set field [" + fieldName + "] in instance of [" + instanceContainingField.getClass().getName() + "]. The Java Security Manager has " + "probably been configured to prevent settting private field values. XWiki requires " + "this ability to work.", e);
                }
                return;
            }
        }
    }

    public static Class<?> getLastGenericFieldType(Field field) {
        ParameterizedType pType;
        Type[] types;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (types = (pType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && types[types.length - 1] instanceof Class) {
            return (Class)types[types.length - 1];
        }
        return null;
    }

    public static Class<?> getLastGenericClassType(Class clazz, Class filterClass) {
        for (Type type : clazz.getGenericInterfaces()) {
            Type[] actualTypes;
            ParameterizedType pType;
            if (!(type instanceof ParameterizedType) || !filterClass.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType()) || (actualTypes = pType.getActualTypeArguments()).length <= 0 || !(actualTypes[actualTypes.length - 1] instanceof Class)) continue;
            return (Class)actualTypes[actualTypes.length - 1];
        }
        return null;
    }
}

