/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescriptorFactory {
    public List<ComponentDescriptor> createComponentDescriptors(Class<?> componentClass, Class<?> componentRoleClass) {
        Component component;
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        Named named = componentClass.getAnnotation(Named.class);
        String[] hints = named != null ? new String[]{named.value()} : ((component = componentClass.getAnnotation(Component.class)) != null && component.hints().length > 0 ? component.hints() : (component != null && component.value().trim().length() > 0 ? new String[]{component.value().trim()} : new String[]{"default"}));
        for (String hint : hints) {
            descriptors.add(this.createComponentDescriptor(componentClass, hint, componentRoleClass));
        }
        return descriptors;
    }

    private ComponentDescriptor createComponentDescriptor(Class<?> componentClass, String hint, Class<?> componentRoleClass) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRole(componentRoleClass);
        descriptor.setImplementation(componentClass);
        descriptor.setRoleHint(hint);
        descriptor.setInstantiationStrategy(this.createComponentInstantiationStrategy(componentClass));
        for (Field field : ReflectionUtils.getAllFields(componentClass)) {
            ComponentDependency dependency = this.createComponentDependency(field);
            if (dependency == null) continue;
            descriptor.addComponentDependency(dependency);
        }
        return descriptor;
    }

    private ComponentInstantiationStrategy createComponentInstantiationStrategy(Class<?> componentClass) {
        InstantiationStrategy instantiationStrategy;
        Singleton singleton = componentClass.getAnnotation(Singleton.class);
        ComponentInstantiationStrategy strategy = singleton != null ? ComponentInstantiationStrategy.SINGLETON : ((instantiationStrategy = componentClass.getAnnotation(InstantiationStrategy.class)) != null ? instantiationStrategy.value() : ComponentInstantiationStrategy.SINGLETON);
        return strategy;
    }

    private ComponentDependency createComponentDependency(Field field) {
        ComponentDependency dependency = this.createComponentDependencyFromInjectAnnotation(field);
        if (dependency == null) {
            dependency = this.createComponentDependencyFromRequirementAnnotation(field);
        }
        return dependency;
    }

    private ComponentDependency createComponentDependencyFromInjectAnnotation(Field field) {
        DefaultComponentDependency dependency = null;
        Inject inject = field.getAnnotation(Inject.class);
        if (inject != null) {
            dependency = new DefaultComponentDependency();
            dependency.setMappingType(field.getType());
            dependency.setName(field.getName());
            Class<?> role = this.getFieldRole(field);
            if (role == null) {
                return null;
            }
            dependency.setRole(role);
            Named named = field.getAnnotation(Named.class);
            if (named != null) {
                dependency.setRoleHint(named.value());
            }
        }
        return dependency;
    }

    private ComponentDependency createComponentDependencyFromRequirementAnnotation(Field field) {
        DefaultComponentDependency dependency = null;
        Requirement requirement = field.getAnnotation(Requirement.class);
        if (requirement != null) {
            dependency = new DefaultComponentDependency();
            dependency.setMappingType(field.getType());
            dependency.setName(field.getName());
            Class<?> role = this.getFieldRole(field, requirement);
            if (role == null) {
                return null;
            }
            dependency.setRole(role);
            if (requirement.value().trim().length() > 0) {
                dependency.setRoleHint(requirement.value());
            }
            if (requirement.hints().length > 0) {
                dependency.setHints(requirement.hints());
            }
        }
        return dependency;
    }

    private Class<?> getFieldRole(Field field) {
        return this.getFieldRole(field, null);
    }

    private Class<?> getFieldRole(Field field, Requirement requirement) {
        Class<Object> role = this.isRequirementListType(field.getType()) ? (requirement != null && !requirement.role().getName().equals(Object.class.getName()) ? requirement.role() : this.getGenericRole(field)) : field.getType();
        return role;
    }

    private Class<?> getGenericRole(Field field) {
        ParameterizedType pType;
        Type[] types;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (types = (pType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && types[types.length - 1] instanceof Class) {
            return (Class)types[types.length - 1];
        }
        return null;
    }

    private boolean isRequirementListType(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }
}

