/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.context.internal.concurrent;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xwiki.context.concurrent.ContextStore;

public abstract class AbstractContextStore
implements ContextStore {
    private List<String> supportedEntries;

    public AbstractContextStore(String ... entries) {
        this.supportedEntries = Collections.unmodifiableList(Arrays.asList(entries));
    }

    @Override
    public Collection<String> getSupportedEntries() {
        return this.supportedEntries;
    }

    protected void save(Map<String, Serializable> contextStore, String key, Serializable value, Collection<String> entries) {
        if (entries.contains(key)) {
            contextStore.put(key, value);
        }
    }

    protected void save(SubContextStore store, String prefix, Collection<String> entries) {
        for (String key : entries) {
            if (!key.startsWith(prefix)) continue;
            store.save(key, key.substring(prefix.length()));
        }
    }

    protected <T> T get(Map<String, Serializable> contextStore, String key, T def) {
        if (contextStore.containsKey(key)) {
            return (T)contextStore.get(key);
        }
        return def;
    }

    @FunctionalInterface
    protected static interface SubContextStore {
        public void save(String var1, String var2);
    }
}

