/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.asymmetric.factory;

import java.security.SecureRandom;
import javax.inject.Named;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.AsymmetricCipher;
import org.xwiki.crypto.cipher.CipherFactory;
import org.xwiki.crypto.cipher.internal.asymmetric.BcBufferedAsymmetricCipher;
import org.xwiki.crypto.internal.asymmetric.BcAsymmetricKeyParameters;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;

public abstract class AbstractBcAsymmetricCipherFactory
implements CipherFactory {
    private static final int[] DEFAULT_SUPPORTED_KEYSIZE = new int[]{32, 48, 64, 96, 128, 256, 384, 512};

    protected abstract AsymmetricBlockCipher getEngineInstance();

    protected abstract AsymmetricBlockCipher getCipherInstance(boolean var1, AsymmetricCipherParameters var2);

    protected abstract SecureRandom getRandomSource();

    protected static int[] newKeySizeArray(int minSize, int maxSize, int step) {
        int[] result = new int[(maxSize - minSize) / step + 1];
        int i = minSize;
        int j = 0;
        while (i <= maxSize) {
            result[j] = i;
            i += step;
            ++j;
        }
        return result;
    }

    @Override
    public String getCipherAlgorithmName() {
        String hint = null;
        Named named = this.getClass().getAnnotation(Named.class);
        if (named != null) {
            hint = named.value();
        } else {
            Component component = this.getClass().getAnnotation(Component.class);
            if (component != null && component.hints().length > 0) {
                hint = component.hints()[0];
            }
        }
        return hint;
    }

    @Override
    public int getIVSize() {
        return -1;
    }

    @Override
    public int[] getSupportedKeySizes() {
        return DEFAULT_SUPPORTED_KEYSIZE;
    }

    @Override
    public int getKeySize() {
        int[] sizes = this.getSupportedKeySizes();
        return sizes[sizes.length - 1];
    }

    @Override
    public boolean isSupportedKeySize(int keySize) {
        int[] sizes;
        for (int i : sizes = this.getSupportedKeySizes()) {
            if (i != keySize) continue;
            return true;
        }
        return false;
    }

    private ParametersWithRandom toParametersWithRandom(AsymmetricCipherParameters parameters) {
        return new ParametersWithRandom(this.getBcCipherParameter(parameters), this.getRandomSource());
    }

    protected org.bouncycastle.crypto.CipherParameters getBcCipherParameter(AsymmetricCipherParameters parameters) {
        if (parameters instanceof BcAsymmetricKeyParameters) {
            return ((BcAsymmetricKeyParameters)parameters).getParameters();
        }
        throw new UnsupportedOperationException("Cipher parameters are incompatible with this cipher: " + parameters.getClass().getName());
    }

    @Override
    public AsymmetricCipher getInstance(boolean forEncryption, CipherParameters parameters) {
        if (!(parameters instanceof AsymmetricCipherParameters)) {
            throw new IllegalArgumentException("Unexpected parameters received for a asymmetric cipher: " + parameters.getClass().getName());
        }
        return new BcBufferedAsymmetricCipher(this.getCipherInstance(forEncryption, (AsymmetricCipherParameters)parameters), forEncryption, (org.bouncycastle.crypto.CipherParameters)this.toParametersWithRandom((AsymmetricCipherParameters)parameters), this.getCipherAlgorithmName());
    }
}

