/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class ScryptKDFParams
extends ASN1Object {
    private ASN1OctetString salt;
    private ASN1Integer costParameter;
    private ASN1Integer blockSize;
    private ASN1Integer parallelizationParameter;
    private ASN1Integer keyLength;

    public ScryptKDFParams(byte[] salt, int costParameter, int blockSize, int parallelizationParameter) {
        this(salt, costParameter, blockSize, parallelizationParameter, -1);
    }

    public ScryptKDFParams(byte[] salt, int costParameter, int blockSize, int parallelizationParameter, int keyLength) {
        this.salt = new DEROctetString(salt);
        this.costParameter = new ASN1Integer((long)costParameter);
        this.blockSize = new ASN1Integer((long)blockSize);
        this.parallelizationParameter = new ASN1Integer((long)parallelizationParameter);
        this.keyLength = keyLength >= 0 ? new ASN1Integer((long)keyLength) : null;
    }

    private ScryptKDFParams(ASN1Sequence seq) {
        this.salt = (ASN1OctetString)seq.getObjectAt(0);
        this.costParameter = (ASN1Integer)seq.getObjectAt(1);
        this.blockSize = (ASN1Integer)seq.getObjectAt(2);
        this.parallelizationParameter = (ASN1Integer)seq.getObjectAt(3);
        if (seq.size() > 4) {
            this.keyLength = (ASN1Integer)seq.getObjectAt(4);
        }
    }

    public static ScryptKDFParams getInstance(Object obj) {
        if (obj instanceof ScryptKDFParams) {
            return (ScryptKDFParams)((Object)obj);
        }
        if (obj != null) {
            return new ScryptKDFParams(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public byte[] getSalt() {
        return this.salt.getOctets();
    }

    public BigInteger getCostParameter() {
        return this.costParameter.getValue();
    }

    public BigInteger getBlockSize() {
        return this.blockSize.getValue();
    }

    public BigInteger getParallelizationParameter() {
        return this.parallelizationParameter.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength == null) {
            return null;
        }
        return this.keyLength.getValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.salt);
        v.add((ASN1Encodable)this.costParameter);
        v.add((ASN1Encodable)this.blockSize);
        v.add((ASN1Encodable)this.parallelizationParameter);
        if (this.keyLength != null) {
            v.add((ASN1Encodable)this.keyLength);
        }
        return new DERSequence(v);
    }
}

