/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.params.cipher.asymmetric.PrivateKeyParameters;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.PasswordBasedCipherFactory;
import org.xwiki.crypto.password.PrivateKeyPasswordBasedEncryptor;
import org.xwiki.crypto.password.internal.pbe.AbstractBcPBCipher;
import org.xwiki.crypto.password.internal.pbe.factory.AbstractBcPBCipherFactory;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;
import org.xwiki.crypto.password.params.PBKDF2Parameters;

@Component
@Singleton
public class DefaultPrivateKeyPasswordBasedEncryptor
implements PrivateKeyPasswordBasedEncryptor {
    @Inject
    private ComponentManager manager;
    @Inject
    private AsymmetricKeyFactory keyFactory;
    @Inject
    private Provider<SecureRandom> randomProvider;

    @Override
    public PrivateKeyParameters decrypt(byte[] password, byte[] encoded) throws GeneralSecurityException, IOException {
        EncryptedPrivateKeyInfo encKeyInfo = EncryptedPrivateKeyInfo.getInstance((Object)encoded);
        return this.decrypt(password, encKeyInfo.getEncryptionAlgorithm(), encKeyInfo.getEncryptedData());
    }

    @Override
    public PrivateKeyParameters decrypt(byte[] password, javax.crypto.EncryptedPrivateKeyInfo privateKeyInfo) throws GeneralSecurityException, IOException {
        return this.decrypt(password, privateKeyInfo.getEncoded());
    }

    private PrivateKeyParameters decrypt(byte[] password, AlgorithmIdentifier algId, byte[] encoded) throws GeneralSecurityException, IOException {
        return this.keyFactory.fromPKCS8(this.getPBECipher(password, algId).doFinal(encoded));
    }

    private PasswordBasedCipher getPBECipher(byte[] password, AlgorithmIdentifier algId) throws IOException {
        PasswordBasedCipherFactory factory = this.getPBEFactory(algId.getAlgorithm().getId());
        if (factory instanceof AbstractBcPBCipherFactory) {
            return ((AbstractBcPBCipherFactory)factory).getInstance(false, password, (ASN1Encodable)algId);
        }
        return factory.getInstance(false, password, algId.getEncoded());
    }

    private PasswordBasedCipherFactory getPBEFactory(String hint) {
        try {
            return (PasswordBasedCipherFactory)this.manager.getInstance(PasswordBasedCipherFactory.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Password based cipher factory not found: " + hint, e);
        }
    }

    @Override
    public byte[] encrypt(String algHint, SymmetricCipherParameters password, KeyDerivationFunctionParameters kdfParameters, PrivateKeyParameters privateKey) throws GeneralSecurityException, IOException {
        PasswordBasedCipher cipher = this.getPBEFactory(algHint).getInstance(true, password, kdfParameters);
        return this.encrypt(cipher, privateKey);
    }

    @Override
    public byte[] encrypt(String algHint, SymmetricCipherParameters password, KeyDerivationFunction function, PrivateKeyParameters privateKey) throws GeneralSecurityException, IOException {
        PasswordBasedCipher cipher = this.getPBEFactory(algHint).getInstance(true, password, function);
        return this.encrypt(cipher, privateKey);
    }

    @Override
    public byte[] encrypt(String algHint, byte[] password, byte[] encoded, PrivateKeyParameters privateKey) throws GeneralSecurityException, IOException {
        PasswordBasedCipher cipher = this.getPBEFactory(algHint).getInstance(true, password, encoded);
        return this.encrypt(cipher, privateKey);
    }

    @Override
    public byte[] encrypt(String algHint, byte[] password, KeyDerivationFunctionParameters kdfParameters, PrivateKeyParameters privateKey) throws GeneralSecurityException, IOException {
        PasswordBasedCipherFactory factory = this.getPBEFactory(algHint);
        PasswordBasedCipher cipher = factory.getInstance(true, (SymmetricCipherParameters)new KeyWithIVParameters(password, factory.getIVSize(), (SecureRandom)this.randomProvider.get()), kdfParameters);
        return this.encrypt(cipher, privateKey);
    }

    @Override
    public byte[] encrypt(byte[] password, PrivateKeyParameters privateKey) throws GeneralSecurityException, IOException {
        PasswordBasedCipherFactory factory = this.getPBEFactory("PBES2-AES-CBC-Pad");
        PasswordBasedCipher cipher = factory.getInstance(true, (SymmetricCipherParameters)new KeyWithIVParameters(password, factory.getIVSize(), (SecureRandom)this.randomProvider.get()), new PBKDF2Parameters((SecureRandom)this.randomProvider.get()));
        return this.encrypt(cipher, privateKey);
    }

    @Override
    public byte[] encrypt(PasswordBasedCipher cipher, PrivateKeyParameters privateKey) throws IOException, GeneralSecurityException {
        AlgorithmIdentifier algId = cipher instanceof AbstractBcPBCipher ? ((AbstractBcPBCipher)cipher).getPBEParameters() : AlgorithmIdentifier.getInstance((Object)cipher.getEncoded());
        return new EncryptedPrivateKeyInfo(algId, cipher.doFinal(privateKey.getEncoded())).getEncoded();
    }
}

