/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe.factory;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.CipherFactory;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.internal.pbe.AbstractBcPBES2Cipher;
import org.xwiki.crypto.password.internal.pbe.factory.AbstractBcPBES2CipherFactory;

@Component(hints={"PBES2-AES-CBC-Pad", "2.16.840.1.101.3.4.1.2", "2.16.840.1.101.3.4.1.22", "2.16.840.1.101.3.4.1.42", "2.16.840.1.101.3.4.2", "2.16.840.1.101.3.4.22", "2.16.840.1.101.3.4.42"})
@Singleton
public class BcPBES2AesCipherFactory
extends AbstractBcPBES2CipherFactory {
    @Inject
    @Named(value="AES/CBC/PKCS7Padding")
    private CipherFactory cipherFactory;

    @Override
    protected CipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    @Override
    protected PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, KeyDerivationFunc kdfParams, EncryptionScheme scheme) {
        KeyDerivationFunction kdf = this.getKeyDerivationFunction(kdfParams);
        kdf.overrideKeySize(this.getAESKeySize(scheme.getAlgorithm()));
        return this.getPasswordBasedCipher(forEncryption, kdf, (SymmetricCipherParameters)new KeyWithIVParameters(kdf.derive(password).getKey(), ((ASN1OctetString)scheme.getParameters()).getOctets()));
    }

    @Override
    protected PasswordBasedCipher getPasswordBasedCipher(boolean forEncryption, KeyDerivationFunction kdf, SymmetricCipherParameters params) {
        kdf.overrideKeySize(kdf.getKeySize());
        return new AbstractBcPBES2Cipher(this.getCipherFactory().getInstance(forEncryption, (CipherParameters)params), kdf, params){

            @Override
            protected EncryptionScheme getScheme(SymmetricCipherParameters parameters) {
                return new EncryptionScheme(BcPBES2AesCipherFactory.this.getAESAlgoritmIdentifier(((KeyWithIVParameters)parameters).getKey().length), (ASN1Encodable)new DEROctetString(((KeyWithIVParameters)parameters).getIV()));
            }
        };
    }

    private int getAESKeySize(ASN1ObjectIdentifier algId) {
        if (algId.equals((Object)NISTObjectIdentifiers.id_aes128_CBC)) {
            return 16;
        }
        if (algId.equals((Object)NISTObjectIdentifiers.id_aes192_CBC)) {
            return 24;
        }
        if (algId.equals((Object)NISTObjectIdentifiers.id_aes256_CBC)) {
            return 32;
        }
        throw new IllegalArgumentException("Unexpected algorithm identifier used for PBES2 AES encryption scheme: " + algId.toString());
    }

    private ASN1ObjectIdentifier getAESAlgoritmIdentifier(int keySize) {
        switch (keySize) {
            case 16: {
                return NISTObjectIdentifiers.id_aes128_CBC;
            }
            case 24: {
                return NISTObjectIdentifiers.id_aes192_CBC;
            }
            case 32: {
                return NISTObjectIdentifiers.id_aes256_CBC;
            }
        }
        throw new IllegalArgumentException("Unexpected key size used for PBES2 AES encryption scheme: " + keySize);
    }
}

