/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params.x509certificate.extension;

import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xwiki.crypto.pkix.internal.extension.BcGeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509StringGeneralName;

public class X509DnsName
implements X509StringGeneralName,
BcGeneralName {
    private final String domain;

    public X509DnsName(String domain) {
        this.domain = domain;
    }

    public X509DnsName(GeneralName name) {
        if (name.getTagNo() != 2) {
            throw new IllegalArgumentException("Incompatible general name: " + name.getTagNo());
        }
        this.domain = DERIA5String.getInstance((Object)name.getName()).getString();
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getName() {
        return this.domain;
    }

    @Override
    public GeneralName getGeneralName() {
        return new GeneralName(2, this.domain);
    }
}

