/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.cert.X509CertificateHolder;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.internal.BcX509CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.SignerFactory;

@Component
@Singleton
@Named(value="X509")
public class BcX509CertificateFactory
implements CertificateFactory {
    @Inject
    private SignerFactory factory;

    @Override
    public CertifiedPublicKey decode(byte[] encoded) throws IOException {
        return this.convert(new X509CertificateHolder(encoded));
    }

    public CertifiedPublicKey convert(X509CertificateHolder cert) {
        if (cert == null) {
            return null;
        }
        return new BcX509CertifiedPublicKey(cert, this.factory);
    }
}

