/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.cms;

import java.security.GeneralSecurityException;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.crypto.pkix.CertificateChainBuilder;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.CMSSignedDataVerifier;
import org.xwiki.crypto.signer.internal.BcContentVerifierProviderBuilder;
import org.xwiki.crypto.signer.internal.cms.BcCMSSignedDataVerified;
import org.xwiki.crypto.signer.internal.cms.BcCMSSignerVerifiedInformation;
import org.xwiki.crypto.signer.internal.cms.BcCMSUtils;
import org.xwiki.crypto.signer.internal.cms.BcStoreUtils;
import org.xwiki.crypto.signer.param.CMSSignedDataVerified;

@Component
@Singleton
public class DefaultCMSSignedDataVerifier
implements CMSSignedDataVerifier,
Initializable {
    @Inject
    private DigestFactory digestProvider;
    @Inject
    private BcContentVerifierProviderBuilder contentVerifierProviderBuilder;
    @Inject
    @Named(value="X509")
    private CertificateFactory certFactory;
    @Inject
    @Named(value="X509")
    private CertificateChainBuilder chainBuilder;
    @Inject
    private ComponentManager manager;

    public void initialize() throws InitializationException {
        if (!(this.digestProvider instanceof DigestCalculatorProvider)) {
            throw new InitializationException("Incompatible DigestFactory for this signed data verifier.");
        }
    }

    @Override
    public CMSSignedDataVerified verify(byte[] signature) throws GeneralSecurityException {
        return this.verify(signature, null, (CertificateProvider)null);
    }

    @Override
    public CMSSignedDataVerified verify(byte[] signature, Collection<CertifiedPublicKey> certificates) throws GeneralSecurityException {
        return this.verify(signature, null, certificates);
    }

    @Override
    public CMSSignedDataVerified verify(byte[] signature, CertificateProvider certificateProvider) throws GeneralSecurityException {
        return this.verify(signature, null, certificateProvider);
    }

    @Override
    public CMSSignedDataVerified verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        return this.verify(signature, data, (CertificateProvider)null);
    }

    @Override
    public CMSSignedDataVerified verify(byte[] signature, byte[] data, Collection<CertifiedPublicKey> certificates) throws GeneralSecurityException {
        return this.verify(signature, data, BcStoreUtils.getCertificateProvider(this.manager, certificates));
    }

    @Override
    public CMSSignedDataVerified verify(byte[] signature, byte[] data, CertificateProvider certificateProvider) throws GeneralSecurityException {
        CMSSignedData signedData = BcCMSUtils.getSignedData(signature, data);
        CertificateProvider provider = BcStoreUtils.getCertificateProvider(this.manager, signedData.getCertificates(), certificateProvider);
        return this.verify(signedData, provider);
    }

    private CMSSignedDataVerified verify(CMSSignedData signedData, CertificateProvider provider) {
        BcCMSSignedDataVerified verifiedData = BcCMSUtils.getCMSSignedDataVerified(signedData, this.certFactory);
        for (SignerInformation signer : BcCMSUtils.getSigners(signedData)) {
            CertifiedPublicKey certKey = BcStoreUtils.getCertificate(provider, signer, this.certFactory);
            try {
                verifiedData.addSignature(new BcCMSSignerVerifiedInformation(signer, BcCMSUtils.verify(signer, certKey, this.contentVerifierProviderBuilder, this.digestProvider), this.chainBuilder.build(certKey, provider)));
            }
            catch (CMSException e) {
                verifiedData.addSignature(new BcCMSSignerVerifiedInformation(signer, false, this.chainBuilder.build(certKey, provider)));
            }
        }
        return verifiedData;
    }
}

