/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.factory;

import javax.inject.Inject;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.crypto.internal.asymmetric.BcAsymmetricKeyParameters;
import org.xwiki.crypto.internal.digest.factory.AbstractBcDigestFactory;
import org.xwiki.crypto.internal.digest.factory.BcDigestFactory;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyParameters;
import org.xwiki.crypto.signer.internal.factory.AbstractBcSignerFactory;
import org.xwiki.crypto.signer.params.PssParameters;
import org.xwiki.crypto.signer.params.PssSignerParameters;

public abstract class AbstractBcPssSignerFactory
extends AbstractBcSignerFactory {
    private static final String PSS_PARAMS_ERROR = "PSS signer parameters are invalid: ";
    @Inject
    private ComponentManager manager;

    protected abstract AsymmetricBlockCipher getCipherEngine();

    @Override
    protected Signer getSignerInstance(AsymmetricCipherParameters parameters) {
        if (parameters instanceof AsymmetricKeyParameters) {
            return new PSSSigner(this.getCipherEngine(), (Digest)new SHA1Digest(), 20);
        }
        if (parameters instanceof PssSignerParameters) {
            PssParameters pssParams = ((PssSignerParameters)parameters).getPssParameters();
            Digest digest = this.getDigestFactory(pssParams.getHashAlgorithm()).getDigestInstance();
            return new PSSSigner(this.getCipherEngine(), digest, this.getDigestFactory(pssParams.getMaskGenAlgorithm()).getDigestInstance(), pssParams.getSaltLength() >= 0 ? pssParams.getSaltLength() : digest.getDigestSize(), pssParams.getTrailerByte());
        }
        throw new UnsupportedOperationException(PSS_PARAMS_ERROR + parameters.getClass().getName());
    }

    @Override
    protected CipherParameters getBcCipherParameter(AsymmetricCipherParameters parameters) {
        AsymmetricKeyParameters keyParams = null;
        if (parameters instanceof AsymmetricKeyParameters) {
            keyParams = (AsymmetricKeyParameters)parameters;
        } else if (parameters instanceof PssSignerParameters) {
            keyParams = ((PssSignerParameters)parameters).getKeyParameters();
        }
        if (keyParams != null && keyParams instanceof BcAsymmetricKeyParameters) {
            return ((BcAsymmetricKeyParameters)keyParams).getParameters();
        }
        throw new UnsupportedOperationException("Cipher parameters are incompatible with this signer: " + parameters.getClass().getName());
    }

    protected BcDigestFactory getDigestFactory(String hint) {
        try {
            DigestFactory factory = (DigestFactory)this.manager.getInstance(DigestFactory.class, hint);
            if (!(factory instanceof BcDigestFactory)) {
                throw new IllegalArgumentException("Requested digest algorithm is not implemented by a factory compatible with this factory. Factory found: " + factory.getClass().getName());
            }
            return (AbstractBcDigestFactory)factory;
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Digest algorithm not found: " + hint, e);
        }
    }
}

