/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.factory;

import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.crypto.internal.asymmetric.BcAsymmetricKeyParameters;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.internal.BcSigner;
import org.xwiki.crypto.signer.internal.factory.AbstractSignerFactory;
import org.xwiki.crypto.signer.internal.factory.BcSignerFactory;

public abstract class AbstractBcSignerFactory
extends AbstractSignerFactory
implements BcSignerFactory {
    protected abstract org.bouncycastle.crypto.Signer getSignerInstance(AsymmetricCipherParameters var1);

    protected abstract AlgorithmIdentifier getSignerAlgorithmIdentifier(AsymmetricCipherParameters var1);

    protected AsymmetricCipherParameters getCipherParameters(CipherParameters parameters) {
        if (!(parameters instanceof AsymmetricCipherParameters)) {
            throw new IllegalArgumentException("Unexpected parameters received for signer: " + parameters.getClass().getName());
        }
        return (AsymmetricCipherParameters)parameters;
    }

    @Override
    public Signer getInstance(boolean forSigning, CipherParameters parameters) {
        return new BcSigner(this.getSignerInstance((AsymmetricCipherParameters)parameters), forSigning, this.getBcCipherParameter(this.getCipherParameters(parameters)), this.getSignerAlgorithmName(), this.getSignerAlgorithmIdentifier((AsymmetricCipherParameters)parameters));
    }

    @Override
    public Signer getInstance(boolean forSigning, CipherParameters parameters, byte[] encoded) {
        return this.getInstance(forSigning, parameters, AlgorithmIdentifier.getInstance((Object)encoded));
    }

    @Override
    public Signer getInstance(boolean forSigning, CipherParameters parameters, AlgorithmIdentifier algId) {
        if (!algId.getAlgorithm().equals((Object)this.getSignerAlgorithmIdentifier(this.getCipherParameters(parameters)).getAlgorithm())) {
            throw new IllegalArgumentException("Incompatible algorithm for this signer: " + algId.getAlgorithm().getId());
        }
        return this.getInstance(forSigning, parameters);
    }

    protected org.bouncycastle.crypto.CipherParameters getBcCipherParameter(AsymmetricCipherParameters parameters) {
        if (parameters instanceof BcAsymmetricKeyParameters) {
            return ((BcAsymmetricKeyParameters)parameters).getParameters();
        }
        throw new UnsupportedOperationException("Cipher parameters are incompatible with this signer: " + parameters.getClass().getName());
    }
}

