/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.factory;

import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.internal.digest.factory.BcDigestFactory;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyParameters;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.internal.factory.AbstractBcPssSignerFactory;
import org.xwiki.crypto.signer.params.PssParameters;
import org.xwiki.crypto.signer.params.PssSignerParameters;

@Component(hints={"RSASSA-PSS", "1.2.840.113549.1.1.10"})
@Singleton
public class BcRsaSsaPssSignerFactory
extends AbstractBcPssSignerFactory {
    private static final String PSS_PARAMS_ERROR = "PSS signer parameters are invalid: ";

    @Override
    protected AsymmetricBlockCipher getCipherEngine() {
        return new RSABlindedEngine();
    }

    @Override
    public Signer getInstance(boolean forSigning, CipherParameters parameters, AlgorithmIdentifier algId) {
        if (!algId.getAlgorithm().equals((Object)PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            throw new IllegalArgumentException("Incompatible algorithm for this signer: " + algId.getAlgorithm().getId());
        }
        ASN1Encodable algParams = algId.getParameters();
        if (DERNull.INSTANCE.equals((Object)algParams)) {
            return this.getInstance(forSigning, parameters);
        }
        RSASSAPSSparams pssParams = RSASSAPSSparams.getInstance((Object)algId.getParameters());
        if (parameters instanceof AsymmetricKeyParameters) {
            return this.getInstance(forSigning, (CipherParameters)new PssSignerParameters((AsymmetricKeyParameters)parameters, pssParams.getHashAlgorithm().getAlgorithm().getId(), AlgorithmIdentifier.getInstance((Object)pssParams.getMaskGenAlgorithm().getParameters()).getAlgorithm().getId(), pssParams.getSaltLength().intValue(), pssParams.getTrailerField().intValue()));
        }
        throw new UnsupportedOperationException(PSS_PARAMS_ERROR + parameters.getClass().getName());
    }

    @Override
    protected AlgorithmIdentifier getSignerAlgorithmIdentifier(AsymmetricCipherParameters parameters) {
        if (parameters instanceof AsymmetricKeyParameters) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)DERNull.INSTANCE);
        }
        if (parameters instanceof PssSignerParameters) {
            PssParameters pssParams = ((PssSignerParameters)parameters).getPssParameters();
            BcDigestFactory factory = this.getDigestFactory(pssParams.getHashAlgorithm());
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)new RSASSAPSSparams(factory.getAlgorithmIdentifier(), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)this.getDigestFactory(pssParams.getMaskGenAlgorithm()).getAlgorithmIdentifier()), new ASN1Integer(pssParams.getSaltLength() >= 0 ? (long)pssParams.getSaltLength() : (long)factory.getDigestSize()), new ASN1Integer((long)pssParams.getTrailerField())));
        }
        throw new UnsupportedOperationException(PSS_PARAMS_ERROR + parameters.getClass().getName());
    }
}

