/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.ConflictDecision;
import org.xwiki.diff.internal.DefaultChunk;

public class DefaultConflictDecision<E>
implements ConflictDecision<E> {
    private ConflictDecision.DecisionType type;
    private Chunk<E> chunk;
    private Conflict<E> conflict;

    public DefaultConflictDecision(Conflict conflict) {
        this.conflict = conflict;
        this.setType(ConflictDecision.DecisionType.UNDECIDED);
    }

    @Override
    public void setType(ConflictDecision.DecisionType type) {
        this.type = type;
        switch (type) {
            case NEXT: {
                this.chunk = this.conflict.getDeltaNext().getNext();
                break;
            }
            case CURRENT: {
                this.chunk = this.conflict.getDeltaCurrent().getNext();
                break;
            }
            case PREVIOUS: {
                this.chunk = this.conflict.getDeltaCurrent().getPrevious();
                break;
            }
            case CUSTOM: {
                this.chunk = new DefaultChunk(this.conflict.getIndex(), Collections.emptyList());
                break;
            }
            default: {
                this.chunk = null;
            }
        }
    }

    @Override
    public void setCustom(List<E> chunkElement) {
        this.type = ConflictDecision.DecisionType.CUSTOM;
        this.chunk = new DefaultChunk<E>(this.conflict.getIndex(), chunkElement);
    }

    @Override
    public ConflictDecision.DecisionType getType() {
        return this.type;
    }

    @Override
    public Chunk<E> getChunk() {
        return this.chunk;
    }

    @Override
    public Conflict<E> getConflict() {
        return this.conflict;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DefaultConflictDecision otherDecision = (DefaultConflictDecision)object;
        return new EqualsBuilder().append((Object)this.type, (Object)otherDecision.type).append(this.chunk, otherDecision.chunk).append(this.conflict, otherDecision.conflict).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 34).append((Object)this.type).append(this.chunk).append(this.conflict).toHashCode();
    }
}

