/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import difflib.DiffUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.ConflictDecision;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffConfiguration;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.MergeConfiguration;
import org.xwiki.diff.MergeException;
import org.xwiki.diff.MergeResult;
import org.xwiki.diff.Patch;
import org.xwiki.diff.internal.AbstractDelta;
import org.xwiki.diff.internal.DefaultChunk;
import org.xwiki.diff.internal.DefaultConflict;
import org.xwiki.diff.internal.DefaultDiffResult;
import org.xwiki.diff.internal.DefaultMergeResult;
import org.xwiki.diff.internal.DefaultPatch;
import org.xwiki.diff.internal.DeleteDelta;
import org.xwiki.diff.internal.DeltaFactory;
import org.xwiki.diff.internal.InsertDelta;

@Component
@Singleton
public class DefaultDiffManager
implements DiffManager {
    @Override
    public <E> DiffResult<E> diff(List<E> previous, List<E> next, DiffConfiguration<E> diff) throws DiffException {
        DefaultPatch<AbstractDelta> patch;
        DefaultDiffResult result = new DefaultDiffResult(previous, next);
        if (previous == null || previous.isEmpty()) {
            patch = new DefaultPatch<AbstractDelta>();
            if (next != null && !next.isEmpty()) {
                patch.add(new InsertDelta(new DefaultChunk(0, Collections.emptyList()), new DefaultChunk<E>(0, next)));
            }
        } else if (next == null || next.isEmpty()) {
            patch = new DefaultPatch();
            patch.add(new DeleteDelta<E>(new DefaultChunk<E>(0, previous), new DefaultChunk(0, Collections.emptyList())));
        } else {
            patch = new DefaultPatch(DiffUtils.diff(previous, next));
        }
        result.setPatch(patch);
        return result;
    }

    @Override
    public <E> MergeResult<E> merge(List<E> commonAncestor, List<E> next, List<E> current, MergeConfiguration<E> configuration) throws MergeException {
        DiffResult<E> diffNextResult;
        DefaultMergeResult<E> mergeResult = new DefaultMergeResult<E>(commonAncestor, next, current);
        try {
            diffNextResult = this.diff(commonAncestor, next, null);
        }
        catch (DiffException e) {
            throw new MergeException("Faile to diff between common ancestor and next version", e);
        }
        mergeResult.getLog().addAll((Collection)diffNextResult.getLog());
        Patch<E> patchNext = diffNextResult.getPatch();
        if (patchNext.isEmpty()) {
            return mergeResult;
        }
        if (current.isEmpty() && (commonAncestor.isEmpty() || next.isEmpty())) {
            if (commonAncestor.isEmpty()) {
                mergeResult.setMerged(next);
            } else if (next.isEmpty()) {
                mergeResult.getLog().warn("The modification was already applied");
            }
        } else {
            DiffResult<E> diffCurrentResult;
            try {
                diffCurrentResult = this.diff(commonAncestor, current, null);
            }
            catch (DiffException e) {
                throw new MergeException("Fail to diff between common ancestor and current version", e);
            }
            mergeResult.getLog().addAll((Collection)diffCurrentResult.getLog());
            Patch<E> patchCurrent = diffCurrentResult.getPatch();
            mergeResult.setMerged(new ArrayList());
            if (patchCurrent.isEmpty()) {
                mergeResult.setMerged(next);
            } else if (!current.equals(next) && (this.isFullyModified(commonAncestor, patchCurrent) || this.isFullyModified(commonAncestor, patchNext))) {
                Delta deltaNext = (Delta)this.nextElement(patchNext);
                Delta deltaCurrent = (Delta)this.nextElement(patchCurrent);
                List<Object> conflictDecisionList = configuration != null ? configuration.getConflictDecisionList() : Collections.emptyList();
                int newIndex = this.applyDecision(conflictDecisionList, mergeResult.getMerged(), 0);
                if (newIndex == Integer.MIN_VALUE) {
                    this.logConflict(mergeResult, deltaCurrent, deltaNext, commonAncestor, next, current, 0);
                    mergeResult.setMerged(this.fallback(commonAncestor, next, current, configuration));
                }
            } else {
                this.merge(mergeResult, commonAncestor, next, current, patchNext, patchCurrent, configuration);
            }
        }
        return mergeResult;
    }

    private <E> ConflictDecision<E> findDecision(List<ConflictDecision<E>> decisions, int currentIndex) {
        ConflictDecision<E> result = null;
        if (decisions != null && !decisions.isEmpty()) {
            for (ConflictDecision<E> decision : decisions) {
                if (decision.getConflict().getIndex() != currentIndex) continue;
                result = decision;
                break;
            }
        }
        return result;
    }

    private <E> int applyDecision(List<ConflictDecision<E>> decisions, List<E> merged, int currentIndex) {
        ConflictDecision<E> conflictDecision = this.findDecision(decisions, currentIndex);
        if (conflictDecision == null || conflictDecision.getType() == ConflictDecision.DecisionType.UNDECIDED) {
            return Integer.MIN_VALUE;
        }
        merged.addAll(conflictDecision.getChunk().getElements());
        return merged.size();
    }

    private <E> int applyDecision(List<ConflictDecision<E>> decisions, List<E> commonAncestor, Delta<E> deltaNext, Delta<E> deltaCurrent, List<E> merged, int currentIndex) {
        ConflictDecision<E> conflictDecision = this.findDecision(decisions, currentIndex);
        if (conflictDecision == null || conflictDecision.getType() == ConflictDecision.DecisionType.UNDECIDED) {
            return Integer.MIN_VALUE;
        }
        switch (conflictDecision.getType()) {
            case PREVIOUS: {
                return this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, currentIndex, MergeConfiguration.Version.PREVIOUS);
            }
            case NEXT: {
                return this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, currentIndex, MergeConfiguration.Version.NEXT);
            }
            case CURRENT: {
                return this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, currentIndex, MergeConfiguration.Version.CURRENT);
            }
            case CUSTOM: {
                merged.addAll(conflictDecision.getChunk().getElements());
                return Math.max(deltaCurrent.getPrevious().getLastIndex(), deltaNext.getPrevious().getLastIndex());
            }
        }
        throw new IllegalArgumentException();
    }

    private <E> List<E> fallback(List<E> commonAncestor, List<E> next, List<E> current, MergeConfiguration<E> configuration) {
        MergeConfiguration.Version fallbackVersion = configuration != null ? configuration.getFallbackOnConflict() : MergeConfiguration.Version.CURRENT;
        switch (fallbackVersion) {
            case NEXT: {
                return next;
            }
            case PREVIOUS: {
                return commonAncestor;
            }
        }
        return current;
    }

    private <E> int fallback(List<E> commonAncestor, Delta<E> deltaNext, Delta<E> deltaCurrent, List<E> merged, int currentIndex, MergeConfiguration<E> configuration) {
        MergeConfiguration.Version fallbackVersion = configuration != null ? configuration.getFallbackOnConflict() : MergeConfiguration.Version.CURRENT;
        return this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, currentIndex, fallbackVersion);
    }

    private <E> int fallback(List<E> commonAncestor, Delta<E> deltaNext, Delta<E> deltaCurrent, List<E> merged, int currentIndex, MergeConfiguration.Version fallbackVersion) {
        int newIndex;
        switch (fallbackVersion) {
            case NEXT: {
                for (newIndex = currentIndex; newIndex < deltaNext.getPrevious().getIndex(); ++newIndex) {
                    merged.add(commonAncestor.get(newIndex));
                }
                newIndex = this.apply(deltaNext, merged, currentIndex);
                break;
            }
            case PREVIOUS: {
                int stopIndex = Math.max(deltaCurrent.getPrevious().getLastIndex(), deltaNext.getPrevious().getLastIndex()) + 1;
                while (newIndex < stopIndex) {
                    merged.add(commonAncestor.get(newIndex));
                    ++newIndex;
                }
                if (currentIndex == newIndex) break;
                --newIndex;
                break;
            }
            default: {
                while (newIndex < deltaCurrent.getPrevious().getIndex()) {
                    merged.add(commonAncestor.get(newIndex));
                    ++newIndex;
                }
                newIndex = this.apply(deltaCurrent, merged, currentIndex);
            }
        }
        return newIndex;
    }

    private <E> void merge(DefaultMergeResult<E> mergeResult, List<E> commonAncestor, List<E> next, List<E> current, Patch<E> patchNext, Patch<E> patchCurrent, MergeConfiguration<E> configuration) throws MergeException {
        List<ConflictDecision<E>> conflictDecisions = configuration != null ? configuration.getConflictDecisionList() : Collections.emptyList();
        ArrayList merged = new ArrayList();
        mergeResult.setMerged(merged);
        Delta<E> deltaNext = (Delta<E>)this.nextElement(patchNext);
        Delta<E> deltaCurrent = (Delta<E>)this.nextElement(patchCurrent);
        if (deltaCurrent.getType() == Delta.Type.INSERT && deltaCurrent.getPrevious().getIndex() == 0 && deltaNext.getType() == Delta.Type.INSERT && deltaNext.getPrevious().getIndex() == 0) {
            merged.addAll(this.or(deltaCurrent.getNext().getElements(), deltaNext.getNext().getElements()));
            deltaCurrent = (Delta)this.nextElement(patchCurrent);
            deltaNext = (Delta)this.nextElement(patchNext);
        } else {
            if (deltaCurrent.getType() == Delta.Type.INSERT && deltaCurrent.getPrevious().getIndex() == 0) {
                merged.addAll(deltaCurrent.getNext().getElements());
                deltaCurrent = (Delta)this.nextElement(patchCurrent);
            }
            if (deltaNext.getType() == Delta.Type.INSERT && deltaNext.getPrevious().getIndex() == 0) {
                merged.addAll(deltaNext.getNext().getElements());
                deltaNext = (Delta)this.nextElement(patchNext);
            }
        }
        for (int index = 0; index < commonAncestor.size(); ++index) {
            int newIndex;
            if (this.isPreviousIndex(deltaCurrent, index)) {
                if (this.isPreviousIndex(deltaNext, index)) {
                    if (deltaNext.equals(deltaCurrent)) {
                        index = this.apply(deltaCurrent, merged, index);
                        if (deltaCurrent.getType() == Delta.Type.INSERT) {
                            merged.add(commonAncestor.get(index));
                        }
                    } else if (deltaCurrent.getType() == Delta.Type.INSERT) {
                        if (deltaNext.getType() == Delta.Type.INSERT) {
                            newIndex = this.applyDecision(conflictDecisions, commonAncestor, deltaNext, deltaCurrent, merged, index);
                            if (newIndex == Integer.MIN_VALUE) {
                                this.logConflict(mergeResult, deltaCurrent, deltaNext, commonAncestor, next, current, index);
                                index = this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, index, configuration);
                            } else {
                                index = newIndex;
                            }
                            merged.add(commonAncestor.get(index));
                        } else {
                            index = this.apply(deltaCurrent, merged, index);
                            index = this.apply(deltaNext, merged, index);
                        }
                    } else if (deltaNext.getType() == Delta.Type.INSERT) {
                        index = this.apply(deltaNext, merged, index);
                        index = this.apply(deltaCurrent, merged, index);
                    } else {
                        newIndex = this.applyDecision(conflictDecisions, commonAncestor, deltaNext, deltaCurrent, merged, index);
                        if (newIndex == Integer.MIN_VALUE) {
                            this.logConflict(mergeResult, deltaCurrent, deltaNext, commonAncestor, next, current, index);
                            index = this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, index, configuration);
                        } else {
                            index = newIndex;
                        }
                    }
                    deltaNext = this.nextElement(patchNext, index);
                } else if (deltaNext != null && deltaCurrent.getPrevious().isOverlappingWith(deltaNext.getPrevious())) {
                    newIndex = this.applyDecision(conflictDecisions, commonAncestor, deltaNext, deltaCurrent, merged, index);
                    if (newIndex == Integer.MIN_VALUE) {
                        this.logConflict(mergeResult, deltaCurrent, deltaNext, commonAncestor, next, current, index);
                        index = this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, index, configuration);
                    } else {
                        index = newIndex;
                    }
                    deltaNext = this.nextElement(patchNext, index);
                } else {
                    index = this.apply(deltaCurrent, merged, index);
                    if (deltaCurrent.getType() == Delta.Type.INSERT) {
                        merged.add(commonAncestor.get(index));
                    }
                }
                deltaCurrent = this.nextElement(patchCurrent, index);
                continue;
            }
            if (this.isPreviousIndex(deltaNext, index)) {
                if (deltaCurrent != null && deltaCurrent.getPrevious().isOverlappingWith(deltaNext.getPrevious())) {
                    newIndex = this.applyDecision(conflictDecisions, commonAncestor, deltaNext, deltaCurrent, merged, index);
                    if (newIndex == Integer.MIN_VALUE) {
                        this.logConflict(mergeResult, deltaCurrent, deltaNext, commonAncestor, next, current, index);
                        index = this.fallback(commonAncestor, deltaNext, deltaCurrent, merged, index, configuration);
                    } else {
                        index = newIndex;
                    }
                    deltaCurrent = this.nextElement(patchCurrent, index);
                } else {
                    index = this.apply(deltaNext, merged, index);
                    if (deltaNext.getType() == Delta.Type.INSERT) {
                        merged.add(commonAncestor.get(index));
                    }
                }
                deltaNext = this.nextElement(patchNext, index);
                continue;
            }
            merged.add(commonAncestor.get(index));
        }
        if (deltaCurrent != null) {
            if (deltaCurrent.getType() == Delta.Type.INSERT) {
                merged.addAll(deltaCurrent.getNext().getElements());
            }
            if (deltaNext != null && !deltaCurrent.equals(deltaNext)) {
                merged.addAll(deltaNext.getNext().getElements());
            }
        } else if (deltaNext != null) {
            merged.addAll(deltaNext.getNext().getElements());
        }
    }

    private <E> List<E> or(List<E> previous, List<E> next) throws MergeException {
        DiffResult<E> diffCurrentResult;
        try {
            diffCurrentResult = this.diff(previous, next, null);
        }
        catch (DiffException e) {
            throw new MergeException("Faile to diff between two versions", e);
        }
        ArrayList<E> result = new ArrayList<E>(previous.size() + next.size());
        int index = 0;
        for (Delta delta : diffCurrentResult.getPatch()) {
            if (delta.getPrevious().getIndex() > index) {
                result.addAll(previous.subList(index, delta.getPrevious().getIndex()));
            }
            if (delta.getType() != Delta.Type.INSERT) {
                result.addAll(delta.getPrevious().getElements());
            }
            if (delta.getType() != Delta.Type.DELETE) {
                result.addAll(delta.getNext().getElements());
            }
            index = delta.getPrevious().getLastIndex() + 1;
        }
        if (previous.size() > index) {
            result.addAll(previous.subList(index, previous.size()));
        }
        return result;
    }

    private <E> List<E> extractConflictPart(Delta<E> delta, List<E> previous, List<E> next, int chunkSize, int index) {
        switch (delta.getType()) {
            case DELETE: {
                int previousChangeSize = delta.getPrevious().size();
                int remainingChunkSize = chunkSize - previousChangeSize;
                return remainingChunkSize > 0 ? previous.subList(index + previousChangeSize, index + remainingChunkSize) : Collections.emptyList();
            }
            case CHANGE: {
                int endOffset = index + Math.min(chunkSize, next.size());
                if (endOffset > next.size()) {
                    endOffset = next.size();
                }
                return next.subList(index, endOffset);
            }
            case INSERT: {
                int newIndex = Math.min(delta.getNext().getIndex(), index);
                int indexOffset = delta.getNext().getIndex() - newIndex;
                int listSize = Math.min(chunkSize, delta.getNext().size());
                return next.subList(newIndex, newIndex + indexOffset + Math.min(listSize, next.size()));
            }
        }
        throw new IllegalArgumentException(String.format("Cannot extract conflict part for unknown type [%s]", new Object[]{delta.getType()}));
    }

    private <E> void logConflict(DefaultMergeResult<E> mergeResult, Delta<E> deltaCurrent, Delta<E> deltaNext, List<E> previous, List<E> next, List<E> current, int index) {
        List subsetPrevious;
        int chunkSize = Math.max(deltaCurrent.getMaxChunkSize(), deltaNext.getMaxChunkSize());
        if (deltaCurrent.getType() == Delta.Type.INSERT && deltaNext.getType() == Delta.Type.INSERT) {
            subsetPrevious = Collections.emptyList();
        } else {
            int newIndex = Math.min(deltaCurrent.getPrevious().getIndex(), deltaNext.getPrevious().getIndex());
            int newOffsetEnd = Math.min(chunkSize, previous.size()) + newIndex;
            if (newOffsetEnd > previous.size()) {
                newOffsetEnd = previous.size();
            }
            subsetPrevious = new ArrayList(previous.subList(newIndex, newOffsetEnd));
        }
        ArrayList<E> subsetNext = new ArrayList<E>(this.extractConflictPart(deltaNext, previous, next, chunkSize, index));
        ArrayList<E> subsetCurrent = new ArrayList<E>(this.extractConflictPart(deltaCurrent, previous, current, chunkSize, index));
        if (subsetPrevious.size() == subsetNext.size() && subsetPrevious.size() == subsetCurrent.size()) {
            for (int i = subsetNext.size() - 1; i >= 0; --i) {
                if (!subsetCurrent.get(i).equals(subsetNext.get(i))) continue;
                subsetCurrent.remove(i);
                subsetNext.remove(i);
                subsetPrevious.remove(i);
            }
        }
        DefaultChunk previousChunk = new DefaultChunk(index, subsetPrevious);
        DefaultChunk<E> nextChunk = new DefaultChunk<E>(index, subsetNext);
        DefaultChunk<E> currentChunk = new DefaultChunk<E>(index, subsetCurrent);
        Delta conflictDeltaCurrent = DeltaFactory.createDelta(previousChunk, currentChunk, Delta.Type.CHANGE);
        Delta conflictDeltaNext = DeltaFactory.createDelta(previousChunk, nextChunk, Delta.Type.CHANGE);
        mergeResult.getLog().error("Conflict between [{}] and [{}]", conflictDeltaCurrent, conflictDeltaNext);
        mergeResult.addConflict(new DefaultConflict(index, conflictDeltaCurrent, conflictDeltaNext));
    }

    private <E> int apply(Delta<E> delta, List<E> merged, int currentIndex) {
        int index = currentIndex;
        switch (delta.getType()) {
            case DELETE: {
                index = delta.getPrevious().getLastIndex();
                break;
            }
            case INSERT: {
                merged.addAll(delta.getNext().getElements());
                break;
            }
            case CHANGE: {
                merged.addAll(delta.getNext().getElements());
                index = delta.getPrevious().getLastIndex();
                break;
            }
        }
        return index;
    }

    private <E> E nextElement(List<E> list) {
        return list != null && !list.isEmpty() ? (E)list.remove(0) : null;
    }

    private <E> Delta<E> nextElement(List<Delta<E>> list, int index) {
        Delta<E> result;
        while ((result = this.nextElement(list)) != null && result.getPrevious().getLastIndex() <= index) {
        }
        return result;
    }

    private <E> boolean isPreviousIndex(Delta<E> delta, int index) {
        return delta != null && delta.getPrevious().getIndex() == index;
    }

    private <E> boolean isFullyModified(List commonAncestor, Patch<E> patchCurrent) {
        return patchCurrent.size() == 1 && commonAncestor.size() == ((Delta)patchCurrent.get(0)).getPrevious().size();
    }
}

