/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.internal.DefaultChunk;

public abstract class AbstractDelta<E>
implements Delta<E> {
    private Delta.Type type;
    private Chunk<E> previous;
    private Chunk<E> next;

    public AbstractDelta(Chunk<E> previous, Chunk<E> next, Delta.Type type) {
        this.type = type;
        this.previous = previous;
        this.next = next;
    }

    public AbstractDelta(difflib.Chunk<E> original, difflib.Chunk<E> revised, Delta.Type type) {
        this.type = type;
        this.previous = new DefaultChunk<E>(original);
        this.next = new DefaultChunk<E>(revised);
    }

    @Override
    public Delta.Type getType() {
        return this.type;
    }

    @Override
    public Chunk<E> getPrevious() {
        return this.previous;
    }

    public void setPrevious(Chunk<E> previous) {
        this.previous = previous;
    }

    @Override
    public Chunk<E> getNext() {
        return this.next;
    }

    public void setNext(Chunk<E> next) {
        this.next = next;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getType());
        builder.append(this.getPrevious());
        builder.append(this.getNext());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Delta) {
            Delta otherDelta = (Delta)obj;
            return this.getType() == otherDelta.getType() && Objects.equals(this.getPrevious(), otherDelta.getPrevious()) && Objects.equals(this.getNext(), otherDelta.getNext());
        }
        return false;
    }

    public String toString() {
        return this.getType().name() + "[-" + this.getPrevious() + " +" + this.getNext() + "]";
    }
}

