/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.internal.ChangeDelta;
import org.xwiki.diff.internal.DeleteDelta;
import org.xwiki.diff.internal.InsertDelta;

public final class DeltaFactory {
    private static final String ERROR_MESSAGE = "Cannot find a delta constructor for the type [%s].";

    private DeltaFactory() {
    }

    public static <E> Delta<E> createDelta(Chunk<E> previous, Chunk<E> next, Delta.Type type) {
        switch (type) {
            case CHANGE: {
                return new ChangeDelta<E>(previous, next);
            }
            case DELETE: {
                return new DeleteDelta<E>(previous, next);
            }
            case INSERT: {
                return new InsertDelta<E>(previous, next);
            }
        }
        throw new IllegalArgumentException(String.format(ERROR_MESSAGE, new Object[]{type}));
    }

    public static <E> Delta<E> createDelta(difflib.Chunk<E> original, difflib.Chunk<E> revised, Delta.Type type) {
        switch (type) {
            case CHANGE: {
                return new ChangeDelta<E>(original, revised);
            }
            case DELETE: {
                return new DeleteDelta<E>(original, revised);
            }
            case INSERT: {
                return new InsertDelta<E>(original, revised);
            }
        }
        throw new IllegalArgumentException(String.format(ERROR_MESSAGE, new Object[]{type}));
    }
}

