/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import difflib.DiffUtils;
import difflib.PatchFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffConfiguration;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.MergeConfiguration;
import org.xwiki.diff.MergeException;
import org.xwiki.diff.MergeResult;
import org.xwiki.diff.Patch;
import org.xwiki.diff.internal.AbstractDelta;
import org.xwiki.diff.internal.DefaultChunk;
import org.xwiki.diff.internal.DefaultDiffResult;
import org.xwiki.diff.internal.DefaultMergeResult;
import org.xwiki.diff.internal.DefaultPatch;
import org.xwiki.diff.internal.DeleteDelta;
import org.xwiki.diff.internal.InsertDelta;

@Component
@Singleton
public class DefaultDiffManager
implements DiffManager {
    @Override
    public <E> DiffResult<E> diff(List<E> previous, List<E> next, DiffConfiguration<E> diff) throws DiffException {
        DefaultPatch<AbstractDelta> patch;
        DefaultDiffResult result = new DefaultDiffResult(previous, next);
        if (previous == null || previous.isEmpty()) {
            patch = new DefaultPatch<AbstractDelta>();
            if (next != null && !next.isEmpty()) {
                patch.add(new InsertDelta(new DefaultChunk(0, Collections.emptyList()), new DefaultChunk<E>(0, next)));
            }
        } else if (next == null || next.isEmpty()) {
            patch = new DefaultPatch();
            patch.add(new DeleteDelta<E>(new DefaultChunk<E>(0, previous), new DefaultChunk(0, Collections.emptyList())));
        } else {
            patch = new DefaultPatch(DiffUtils.diff(previous, next));
        }
        result.setPatch(patch);
        return result;
    }

    @Override
    public <E> MergeResult<E> merge(List<E> commonAncestor, List<E> next, List<E> current, MergeConfiguration<E> configuration) throws MergeException {
        DiffResult<E> diffNextResult;
        DefaultMergeResult<E> mergeResult = new DefaultMergeResult<E>(commonAncestor, next, current);
        try {
            diffNextResult = this.diff(commonAncestor, next, null);
        }
        catch (DiffException e) {
            throw new MergeException("Faile to diff between common ancestor and next version", e);
        }
        mergeResult.getLog().addAll((Collection)diffNextResult.getLog());
        Patch<E> patchNext = diffNextResult.getPatch();
        if (patchNext.isEmpty()) {
            return mergeResult;
        }
        if (current.isEmpty()) {
            if (commonAncestor.isEmpty()) {
                mergeResult.setMerged(next);
            } else if (next.isEmpty()) {
                mergeResult.getLog().warn("The modification was already applied");
            } else {
                mergeResult.getLog().error("The current value is empty");
            }
        } else {
            DiffResult<E> diffCurrentResult;
            try {
                diffCurrentResult = this.diff(commonAncestor, current, null);
            }
            catch (DiffException e) {
                throw new MergeException("Faile to diff between common ancestor and current version", e);
            }
            mergeResult.getLog().addAll((Collection)diffCurrentResult.getLog());
            Patch<E> patchCurrent = diffCurrentResult.getPatch();
            if (patchCurrent.isEmpty()) {
                mergeResult.setMerged(next);
            } else {
                this.merge(mergeResult, commonAncestor, patchNext, patchCurrent, configuration);
            }
        }
        return mergeResult;
    }

    private <E> void merge(DefaultMergeResult<E> mergeResult, List<E> commonAncestor, Patch<E> patchNext, Patch<E> patchCurrent, MergeConfiguration<E> configuration) {
        ArrayList merged = new ArrayList();
        mergeResult.setMerged(merged);
        Delta deltaNext = (Delta)this.nextElement(patchNext);
        Delta deltaCurrent = (Delta)this.nextElement(patchCurrent);
        if (deltaCurrent.getType() == Delta.Type.INSERT && deltaCurrent.getPrevious().getIndex() == 0) {
            merged.addAll(deltaCurrent.getNext().getElements());
            deltaCurrent = (Delta)this.nextElement(patchCurrent);
            if (deltaNext.getType() == Delta.Type.INSERT && deltaNext.getPrevious().getIndex() == 0) {
                this.logConflict(mergeResult, deltaCurrent, deltaNext);
                deltaNext = (Delta)this.nextElement(patchNext);
            }
        } else if (deltaNext.getType() == Delta.Type.INSERT && deltaNext.getPrevious().getIndex() == 0) {
            merged.addAll(deltaNext.getNext().getElements());
            deltaNext = (Delta)this.nextElement(patchNext);
        }
        for (int index = 0; index < commonAncestor.size(); ++index) {
            if (this.isPreviousIndex(deltaCurrent, index)) {
                index = this.apply(deltaCurrent, merged, index);
                if (!this.isInPreviousDelta(deltaNext, deltaCurrent.getPrevious().getLastIndex())) continue;
                this.logConflict(mergeResult, deltaCurrent, deltaNext);
                deltaNext = (Delta)this.nextElement(patchNext);
                continue;
            }
            if (this.isPreviousIndex(deltaNext, index)) {
                if (this.isInPreviousDelta(deltaCurrent, deltaNext.getPrevious().getLastIndex())) {
                    this.logConflict(mergeResult, deltaCurrent, deltaNext);
                    deltaNext = (Delta)this.nextElement(patchNext);
                    continue;
                }
                index = this.apply(deltaNext, merged, index);
                continue;
            }
            merged.add(commonAncestor.get(index));
        }
        if (deltaCurrent != null) {
            merged.addAll(deltaCurrent.getNext().getElements());
            if (deltaNext != null) {
                this.logConflict(mergeResult, deltaCurrent, deltaNext);
            }
        } else if (deltaNext != null) {
            merged.addAll(deltaNext.getNext().getElements());
        }
    }

    private <E> void logConflict(DefaultMergeResult<E> mergeResult, Delta<E> deltaCurrent, Delta<E> deltaNext) {
        mergeResult.getLog().error("Conflict between [{}] and [{}]", deltaCurrent, deltaNext);
    }

    private <E> int apply(Delta<E> delta, List<E> merged, int currentIndex) {
        int index = currentIndex;
        switch (delta.getType()) {
            case DELETE: {
                index = delta.getPrevious().getLastIndex();
                break;
            }
            case INSERT: {
                merged.addAll(delta.getNext().getElements());
                break;
            }
            case CHANGE: {
                merged.addAll(delta.getNext().getElements());
                index = delta.getPrevious().getLastIndex();
                break;
            }
        }
        return index;
    }

    private <E> E nextElement(List<E> list) {
        return list != null && !list.isEmpty() ? (E)list.remove(0) : null;
    }

    private <E> boolean isPreviousIndex(Delta<E> delta, int index) {
        return delta != null && delta.getPrevious().getIndex() == index;
    }

    private <E> boolean isInPreviousDelta(Delta<E> delta, int index) {
        return delta != null && delta.getPrevious().getIndex() <= index && delta.getPrevious().getIndex() >= index;
    }

    public <E> void merge(List<E> commonAncestor, List<E> next, List<E> current, MergeConfiguration<E> configuration, DefaultMergeResult<E> mergeResult) {
        difflib.Patch patch = DiffUtils.diff(commonAncestor, next);
        try {
            List result = patch.applyTo(current);
            mergeResult.setMerged(result);
        }
        catch (PatchFailedException e) {
            mergeResult.getLog().error("Failed to apply differences between [{}] and [{}] on current list [{}]", new Object[]{commonAncestor, next, current, e});
        }
    }
}

