/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import java.util.List;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.PatchException;
import org.xwiki.diff.internal.AbstractDelta;

public class ChangeDelta<E>
extends AbstractDelta<E> {
    public ChangeDelta(Chunk<E> previous, Chunk<E> next) {
        super(previous, next, Delta.Type.CHANGE);
    }

    public ChangeDelta(difflib.Chunk<E> original, difflib.Chunk<E> revised) {
        super(original, revised, Delta.Type.CHANGE);
    }

    @Override
    public void apply(List<E> target) throws PatchException {
        int i;
        this.verify(target);
        int index = this.getPrevious().getIndex();
        int size = this.getPrevious().size();
        for (i = 0; i < size; ++i) {
            target.remove(index);
        }
        i = 0;
        for (Object element : this.getNext().getElements()) {
            target.add(index + i, element);
            ++i;
        }
    }

    @Override
    public void restore(List<E> target) {
        int i;
        int index = this.getNext().getIndex();
        int size = this.getNext().size();
        for (i = 0; i < size; ++i) {
            target.remove(index);
        }
        i = 0;
        for (Object element : this.getPrevious().getElements()) {
            target.add(index + i, element);
            ++i;
        }
    }

    @Override
    public void verify(List<E> target) throws PatchException {
        this.getPrevious().verify(target);
        if (this.getPrevious().getIndex() > target.size()) {
            throw new PatchException("Incorrect patch for delta: delta original position > target size");
        }
    }
}

