/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import java.util.List;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.PatchException;
import org.xwiki.diff.internal.AbstractDelta;

public class InsertDelta<E>
extends AbstractDelta<E> {
    public InsertDelta(Chunk<E> previous, Chunk<E> next) {
        super(previous, next, Delta.Type.INSERT);
    }

    public InsertDelta(difflib.Chunk<E> original, difflib.Chunk<E> revised) {
        super(original, revised, Delta.Type.INSERT);
    }

    @Override
    public void apply(List<E> target) throws PatchException {
        this.verify(target);
        int index = this.getPrevious().getIndex();
        List elements = this.getNext().getElements();
        for (int i = 0; i < elements.size(); ++i) {
            target.add(index + i, elements.get(i));
        }
    }

    @Override
    public void restore(List<E> target) {
        int index = this.getNext().getIndex();
        int size = this.getNext().size();
        for (int i = 0; i < size; ++i) {
            target.remove(index);
        }
    }

    @Override
    public void verify(List<E> target) throws PatchException {
        if (this.getPrevious().getIndex() > target.size()) {
            throw new PatchException("Incorrect patch for delta: delta original position > target size");
        }
    }
}

